/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.explorer;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gwtbootstrap3.client.ui.constants.LabelType;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.service.UserManagerService;
import org.uberfire.ext.security.management.client.widgets.management.AbstractSecurityManagementTest;
import org.uberfire.ext.security.management.client.widgets.management.events.CreateUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.NewUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.ReadUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.explorer.EntitiesExplorerView;
import org.uberfire.ext.security.management.client.widgets.management.explorer.ExplorerViewContext;
import org.uberfire.ext.security.management.client.widgets.management.explorer.UsersExplorer;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesList;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class UsersExplorerTest
extends AbstractSecurityManagementTest {
    @Mock
    EntitiesExplorerView view;
    @Mock
    EventSourceMock<OnErrorEvent> onErrorEvent;
    @Mock
    LoadingBox loadingBox;
    @Mock
    EntitiesList<User> entitiesList;
    @Mock
    EventSourceMock<ReadUserEvent> readUserEvent;
    @Mock
    EventSourceMock<NewUserEvent> newUserEvent;
    private UsersExplorer presenter;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.presenter = new UsersExplorer(this.userSystemManager, this.onErrorEvent, this.loadingBox, this.entitiesList, this.view, this.readUserEvent, this.newUserEvent);
        junit.framework.Assert.assertEquals((Object)this.view.asWidget(), (Object)this.presenter.asWidget());
    }

    @Test
    public void testClear() throws Exception {
        this.presenter.clear();
        ((EntitiesExplorerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((EntitiesExplorerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearSearch();
        ((EntitiesExplorerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showMessage((LabelType)Mockito.any(LabelType.class), Mockito.anyString());
        ((EntitiesExplorerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).show((EntitiesExplorerView.ViewContext)Mockito.any(EntitiesExplorerView.ViewContext.class), (EntitiesExplorerView.ViewCallback)Mockito.any(EntitiesExplorerView.ViewCallback.class));
        Assert.assertNull((Object)this.presenter.context);
        Assert.assertNull((Object)this.presenter.selected);
        Assert.assertEquals((long)this.presenter.currentPage, (long)1L);
    }

    @Test
    public void testLoadingViewShow() throws Exception {
        this.presenter.showLoadingView();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).show();
    }

    @Test
    public void testLoadingViewHide() throws Exception {
        this.presenter.hideLoadingView();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void testShowError() throws Exception {
        String message = "error1";
        Throwable t = (Throwable)Mockito.mock(Throwable.class);
        Mockito.when((Object)t.getMessage()).thenReturn((Object)"error1");
        this.presenter.showError(t);
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)0))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
        ((EventSourceMock)Mockito.verify(this.onErrorEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(OnErrorEvent.class));
    }

    @Test
    public void testShowNotAllowed() throws Exception {
        Mockito.when((Object)this.userSystemManager.isUserCapabilityEnabled(Capability.CAN_SEARCH_USERS)).thenReturn((Object)false);
        ExplorerViewContext context = (ExplorerViewContext)Mockito.mock(ExplorerViewContext.class);
        this.presenter.show(context);
        ((EntitiesExplorerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showMessage((LabelType)Mockito.any(LabelType.class), Mockito.anyString());
        ((EntitiesExplorerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).show((EntitiesExplorerView.ViewContext)Mockito.any(EntitiesExplorerView.ViewContext.class), (EntitiesExplorerView.ViewCallback)Mockito.any(EntitiesExplorerView.ViewCallback.class));
    }

    @Test
    public void testShow() throws Exception {
        ExplorerViewContext context = this.createContext(true, true, true, true, true, new HashSet<String>());
        List<User> users = this.buildUsersList(10);
        AbstractEntityManager.SearchResponse<User> response = this.createResponse(users, 10, false);
        this.testShow(context, response);
    }

    @Test
    public void testShowWithSelectedUsers() throws Exception {
        HashSet<String> selectedUsers = new HashSet<String>(5);
        selectedUsers.add("user0");
        selectedUsers.add("user1");
        selectedUsers.add("user2");
        selectedUsers.add("user3");
        selectedUsers.add("user4");
        ExplorerViewContext context = this.createContext(true, true, true, true, true, selectedUsers);
        List<User> users = this.buildUsersList(10);
        AbstractEntityManager.SearchResponse<User> response = this.createResponse(users, 10, false);
        this.testShow(context, response);
    }

    @Test
    public void testOnUserDeleted() throws Exception {
        DeleteUserEvent deleteUserEvent = (DeleteUserEvent)Mockito.mock(DeleteUserEvent.class);
        this.presenter.onUserDeleted(deleteUserEvent);
        ((UserManagerService)Mockito.verify((Object)this.userManagerService, (VerificationMode)Mockito.times((int)1))).search((AbstractEntityManager.SearchRequest)Mockito.any(AbstractEntityManager.SearchRequest.class));
    }

    @Test
    public void testOnCreateUser() throws Exception {
        CreateUserEvent createUserEvent = (CreateUserEvent)Mockito.mock(CreateUserEvent.class);
        this.presenter.onUserCreated(createUserEvent);
        ((UserManagerService)Mockito.verify((Object)this.userManagerService, (VerificationMode)Mockito.times((int)1))).search((AbstractEntityManager.SearchRequest)Mockito.any(AbstractEntityManager.SearchRequest.class));
    }

    @Test
    public void testOnSaveUser() throws Exception {
        SaveUserEvent saveUserEvent = (SaveUserEvent)Mockito.mock(SaveUserEvent.class);
        this.presenter.onUserSaved(saveUserEvent);
        ((UserManagerService)Mockito.verify((Object)this.userManagerService, (VerificationMode)Mockito.times((int)1))).search((AbstractEntityManager.SearchRequest)Mockito.any(AbstractEntityManager.SearchRequest.class));
    }

    private ExplorerViewContext createContext(boolean canCreate, boolean canRead, boolean canDelete, boolean canSearch, boolean canSelect, Set<String> selectedUsers) {
        ExplorerViewContext context = (ExplorerViewContext)Mockito.mock(ExplorerViewContext.class);
        Mockito.when((Object)context.canCreate()).thenReturn((Object)canCreate);
        Mockito.when((Object)context.canRead()).thenReturn((Object)canRead);
        Mockito.when((Object)context.canDelete()).thenReturn((Object)canDelete);
        Mockito.when((Object)context.canSearch()).thenReturn((Object)canSearch);
        Mockito.when((Object)context.canSelect()).thenReturn((Object)canSelect);
        Mockito.when((Object)context.getSelectedEntities()).thenReturn(selectedUsers);
        return context;
    }

    private AbstractEntityManager.SearchResponse<User> createResponse(List<User> users, int size, boolean hasNextPage) {
        AbstractEntityManager.SearchResponse response = (AbstractEntityManager.SearchResponse)Mockito.mock(AbstractEntityManager.SearchResponse.class);
        Mockito.when((Object)response.getResults()).thenReturn(users);
        Mockito.when((Object)response.getTotal()).thenReturn((Object)size);
        Mockito.when((Object)response.hasNextPage()).thenReturn((Object)hasNextPage);
        return response;
    }

    private void testShow(ExplorerViewContext context, final AbstractEntityManager.SearchResponse<User> response) {
        Mockito.when((Object)this.userManagerService.search((AbstractEntityManager.SearchRequest)Mockito.any(AbstractEntityManager.SearchRequest.class))).thenAnswer((Answer)new Answer<AbstractEntityManager.SearchResponse<User>>(){

            public AbstractEntityManager.SearchResponse<User> answer(InvocationOnMock invocationOnMock) throws Throwable {
                return response;
            }
        });
        this.presenter.show(context);
        junit.framework.Assert.assertEquals((Object)context, (Object)this.presenter.context);
        junit.framework.Assert.assertEquals((Object)context.getSelectedEntities(), (Object)this.presenter.selected);
        ((ExplorerViewContext)Mockito.verify((Object)context, (VerificationMode)Mockito.times((int)1))).setParent((EntitiesExplorerView.ViewContext)Mockito.any(EntitiesExplorerView.ViewContext.class));
        ((EntitiesExplorerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showMessage((LabelType)Mockito.any(LabelType.class), Mockito.anyString());
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
        ArgumentCaptor responseArgumentCaptor = ArgumentCaptor.forClass(AbstractEntityManager.SearchResponse.class);
        ArgumentCaptor callbackArgumentCaptor = ArgumentCaptor.forClass(EntitiesList.Callback.class);
        ((EntitiesList)Mockito.verify(this.entitiesList, (VerificationMode)Mockito.times((int)1))).show((AbstractEntityManager.SearchResponse)responseArgumentCaptor.capture(), (EntitiesList.Callback)callbackArgumentCaptor.capture());
        AbstractEntityManager.SearchResponse responseArgumentCaptured = (AbstractEntityManager.SearchResponse)responseArgumentCaptor.getValue();
        List results = response.getResults();
        junit.framework.Assert.assertEquals((Object)results, (Object)responseArgumentCaptured.getResults());
        junit.framework.Assert.assertEquals((int)response.getTotal(), (int)responseArgumentCaptured.getTotal());
        junit.framework.Assert.assertEquals((boolean)response.hasNextPage(), (boolean)responseArgumentCaptured.hasNextPage());
        EntitiesList.Callback callbackArgumentCaptured = (EntitiesList.Callback)callbackArgumentCaptor.getValue();
        junit.framework.Assert.assertEquals((boolean)context.canRead(), (boolean)callbackArgumentCaptured.canRead());
        junit.framework.Assert.assertEquals((boolean)context.canDelete(), (boolean)callbackArgumentCaptured.canRemove());
        junit.framework.Assert.assertEquals((boolean)context.canSelect(), (boolean)callbackArgumentCaptured.canSelect());
        int x = 0;
        for (User user : results) {
            String username = this.getUserIdentifier(x);
            junit.framework.Assert.assertEquals((String)username, (String)callbackArgumentCaptured.getIdentifier((Object)user));
            junit.framework.Assert.assertEquals((String)username, (String)callbackArgumentCaptured.getTitle((Object)user));
            boolean isSelected = context.getSelectedEntities() != null && context.getSelectedEntities().contains(username);
            junit.framework.Assert.assertEquals((boolean)isSelected, (boolean)callbackArgumentCaptured.isSelected(user.getIdentifier()));
            ++x;
        }
    }
}

