/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user.workflow;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashSet;
import javax.enterprise.event.Event;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.service.UserManagerService;
import org.uberfire.ext.security.management.client.editor.user.UserEditorDriver;
import org.uberfire.ext.security.management.client.widgets.management.AbstractSecurityManagementTest;
import org.uberfire.ext.security.management.client.widgets.management.ChangePassword;
import org.uberfire.ext.security.management.client.widgets.management.CreateEntity;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedGroupsEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedGroupsExplorer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedRolesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAttributesEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.workflow.UserCreationWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.editor.workflow.EntityWorkflowView;
import org.uberfire.ext.security.management.client.widgets.management.events.CreateUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.CreateUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnChangePasswordEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnDeleteEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnRemoveUserGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnUpdateUserGroupsEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.UpdateUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class UserCreationWorkflowTest
extends AbstractSecurityManagementTest {
    @Mock
    EventSourceMock<OnErrorEvent> errorEvent;
    @Mock
    EventSourceMock<DeleteUserEvent> deleteUserEvent;
    @Mock
    EventSourceMock<SaveUserEvent> saveUserEvent;
    @Mock
    ConfirmBox confirmBox;
    @Mock
    UserEditor userEditor;
    @Mock
    UserEditorDriver userEditorDriver;
    @Mock
    ChangePassword changePassword;
    @Mock
    LoadingBox loadingBox;
    @Mock
    CreateEntity createEntity;
    @Mock
    EventSourceMock<CreateUserEvent> createUserEvent;
    @Mock
    EntityWorkflowView view;
    @Mock
    UserAttributesEditor userAttributesEditor;
    @Mock
    UserAssignedGroupsExplorer userAssignedGroupsExplorer;
    @Mock
    UserAssignedGroupsEditor userAssignedGroupsEditor;
    @Mock
    UserAssignedRolesExplorer userAssignedRolesExplorer;
    @Mock
    User user;
    private UserCreationWorkflow tested;

    @Override
    @Before
    public void setup() {
        super.setup();
        HashSet<Group> groups = new HashSet<Group>();
        Group group1 = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)group1.getName()).thenReturn((Object)"group1");
        groups.add(group1);
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"user1");
        Mockito.when((Object)this.user.getGroups()).thenReturn(groups);
        Mockito.when((Object)this.view.setWidget((IsWidget)Mockito.any(IsWidget.class))).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.clearNotifications()).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setCallback((EntityWorkflowView.Callback)Mockito.any(EntityWorkflowView.Callback.class))).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setCancelButtonVisible(Mockito.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonEnabled(Mockito.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonVisible(Mockito.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonText(Mockito.anyString())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.showNotification(Mockito.anyString())).thenReturn((Object)this.view);
        Mockito.when((Object)this.userEditor.setEditButtonVisible(Mockito.anyBoolean())).thenReturn((Object)this.userEditor);
        Mockito.when((Object)this.userEditor.setChangePasswordButtonVisible(Mockito.anyBoolean())).thenReturn((Object)this.userEditor);
        Mockito.when((Object)this.userEditor.setDeleteButtonVisible(Mockito.anyBoolean())).thenReturn((Object)this.userEditor);
        Mockito.when((Object)this.userEditor.attributesEditor()).thenReturn((Object)this.userAttributesEditor);
        Mockito.when((Object)this.userEditor.groupsExplorer()).thenReturn((Object)this.userAssignedGroupsExplorer);
        Mockito.when((Object)this.userEditor.groupsEditor()).thenReturn((Object)this.userAssignedGroupsEditor);
        Mockito.when((Object)this.userEditor.rolesExplorer()).thenReturn((Object)this.userAssignedRolesExplorer);
        this.tested = new UserCreationWorkflow(this.userSystemManager, this.errorEvent, (Event)this.workbenchNotification, this.deleteUserEvent, this.saveUserEvent, this.createUserEvent, this.confirmBox, this.createEntity, this.userEditor, this.userEditorDriver, this.changePassword, this.loadingBox, this.view);
    }

    @Test
    public void testCreate() {
        this.tested.create();
        ((UserEditor)Mockito.verify((Object)this.userEditor, (VerificationMode)Mockito.times((int)1))).clear();
        ((UserEditor)Mockito.verify((Object)this.userEditor, (VerificationMode)Mockito.times((int)1))).setPermissionsVisible(false);
        ((CreateEntity)Mockito.verify((Object)this.createEntity, (VerificationMode)Mockito.times((int)1))).show(Mockito.anyString(), Mockito.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCancelButtonVisible(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCallback((EntityWorkflowView.Callback)Mockito.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonText(Mockito.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setWidget((IsWidget)Mockito.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonVisible(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonEnabled(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearNotifications();
    }

    @Test
    public void testOnCreateEntityAlreadyExisting() {
        Mockito.when((Object)this.userManagerService.get(Mockito.anyString())).thenReturn((Object)this.user);
        Mockito.when((Object)this.createEntity.getEntityIdentifier()).thenReturn((Object)"user1");
        this.tested.onCreateEntityClick();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
        ((CreateEntity)Mockito.verify((Object)this.createEntity, (VerificationMode)Mockito.times((int)1))).setErrorState();
    }

    @Test
    public void testDoEdit() {
        this.tested.user = this.user;
        this.tested.doEdit();
        Assert.assertFalse((boolean)this.tested.isDirty);
        ((UserManagerService)Mockito.verify((Object)this.userManagerService, (VerificationMode)Mockito.times((int)0))).get(Mockito.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).setCancelButtonVisible(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCallback((EntityWorkflowView.Callback)Mockito.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setSaveButtonText(Mockito.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setWidget((IsWidget)Mockito.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).setSaveButtonVisible(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)4))).setSaveButtonEnabled(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonEnabled(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearNotifications();
        ((UserEditor)Mockito.verify((Object)this.userEditor, (VerificationMode)Mockito.times((int)0))).clear();
        ((UserEditorDriver)Mockito.verify((Object)this.userEditorDriver, (VerificationMode)Mockito.times((int)0))).show(this.user, (org.uberfire.ext.security.management.client.editor.user.UserEditor)this.userEditor);
        ((UserEditorDriver)Mockito.verify((Object)this.userEditorDriver, (VerificationMode)Mockito.times((int)1))).edit(this.user, (org.uberfire.ext.security.management.client.editor.user.UserEditor)this.userEditor);
        ((UserEditor)Mockito.verify((Object)this.userEditor, (VerificationMode)Mockito.times((int)1))).setEditButtonVisible(false);
        ((UserEditor)Mockito.verify((Object)this.userEditor, (VerificationMode)Mockito.times((int)1))).setChangePasswordButtonVisible(false);
        ((UserEditor)Mockito.verify((Object)this.userEditor, (VerificationMode)Mockito.times((int)1))).setDeleteButtonVisible(false);
    }

    @Test
    public void testAfterSaveSetPassword() {
        this.tested.user = this.user;
        ((ConfirmBox)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                Command callback = (Command)invocationOnMock.getArguments()[2];
                callback.execute();
                return null;
            }
        }).when((Object)this.confirmBox)).show(Mockito.anyString(), Mockito.anyString(), (Command)Mockito.any(Command.class), (Command)Mockito.any(Command.class));
        String id = "user1";
        this.tested.afterSave("user1");
        ((ConfirmBox)Mockito.verify((Object)this.confirmBox, (VerificationMode)Mockito.times((int)1))).show(Mockito.anyString(), Mockito.anyString(), (Command)Mockito.any(Command.class), (Command)Mockito.any(Command.class));
        ((ChangePassword)Mockito.verify((Object)this.changePassword, (VerificationMode)Mockito.times((int)1))).show(Mockito.anyString(), (ChangePassword.ChangePasswordCallback)Mockito.any(ChangePassword.ChangePasswordCallback.class));
    }

    @Test
    public void testAfterSaveSkipSetPassword() {
        this.tested.user = this.user;
        ((ConfirmBox)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                Command callback = (Command)invocationOnMock.getArguments()[3];
                callback.execute();
                return null;
            }
        }).when((Object)this.confirmBox)).show(Mockito.anyString(), Mockito.anyString(), (Command)Mockito.any(Command.class), (Command)Mockito.any(Command.class));
        String id = "user1";
        this.tested.afterSave("user1");
        ((ConfirmBox)Mockito.verify((Object)this.confirmBox, (VerificationMode)Mockito.times((int)1))).show(Mockito.anyString(), Mockito.anyString(), (Command)Mockito.any(Command.class), (Command)Mockito.any(Command.class));
        ((ChangePassword)Mockito.verify((Object)this.changePassword, (VerificationMode)Mockito.times((int)0))).show(Mockito.anyString(), (ChangePassword.ChangePasswordCallback)Mockito.any(ChangePassword.ChangePasswordCallback.class));
        ((EventSourceMock)Mockito.verify((Object)this.workbenchNotification, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(NotificationEvent.class));
        ((EventSourceMock)Mockito.verify(this.createUserEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(CreateUserEvent.class));
        ((CreateEntity)Mockito.verify((Object)this.createEntity, (VerificationMode)Mockito.times((int)1))).show(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void testOnDeleteUserEvent() {
        OnDeleteEvent onDeleteEvent = (OnDeleteEvent)Mockito.mock(OnDeleteEvent.class);
        Mockito.when((Object)onDeleteEvent.getContext()).thenReturn((Object)this.userEditor);
        this.tested.user = this.user;
        ((ConfirmBox)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                Command callback = (Command)invocationOnMock.getArguments()[2];
                callback.execute();
                return null;
            }
        }).when((Object)this.confirmBox)).show(Mockito.anyString(), Mockito.anyString(), (Command)Mockito.any(Command.class), (Command)Mockito.any(Command.class));
        this.tested.onDeleteUserEvent(onDeleteEvent);
        ((ConfirmBox)Mockito.verify((Object)this.confirmBox, (VerificationMode)Mockito.times((int)1))).show(Mockito.anyString(), Mockito.anyString(), (Command)Mockito.any(Command.class), (Command)Mockito.any(Command.class));
        ((UserManagerService)Mockito.verify((Object)this.userManagerService, (VerificationMode)Mockito.times((int)1))).delete(new String[]{Mockito.anyString()});
    }

    @Test
    public void testOnChangeUserPasswordEvent() {
        OnChangePasswordEvent onChangePasswordEvent = (OnChangePasswordEvent)Mockito.mock(OnChangePasswordEvent.class);
        Mockito.when((Object)onChangePasswordEvent.getContext()).thenReturn((Object)this.userEditor);
        this.tested.user = this.user;
        this.tested.onChangeUserPasswordEvent(onChangePasswordEvent);
        ((ChangePassword)Mockito.verify((Object)this.changePassword, (VerificationMode)Mockito.times((int)1))).show(Mockito.anyString(), (ChangePassword.ChangePasswordCallback)Mockito.any(ChangePassword.ChangePasswordCallback.class));
    }

    @Test
    public void testOnAttributeCreated() {
        CreateUserAttributeEvent createUserAttributeEvent = (CreateUserAttributeEvent)Mockito.mock(CreateUserAttributeEvent.class);
        Mockito.when((Object)createUserAttributeEvent.getContext()).thenReturn((Object)this.userAttributesEditor);
        this.tested.user = this.user;
        this.tested.onAttributeCreated(createUserAttributeEvent);
        this.assertSetDirty();
    }

    @Test
    public void testOnAttributeDeleted() {
        DeleteUserAttributeEvent deleteUserAttributeEvent = (DeleteUserAttributeEvent)Mockito.mock(DeleteUserAttributeEvent.class);
        Mockito.when((Object)deleteUserAttributeEvent.getContext()).thenReturn((Object)this.userAttributesEditor);
        this.tested.user = this.user;
        this.tested.onAttributeDeleted(deleteUserAttributeEvent);
        this.assertSetDirty();
    }

    @Test
    public void testOnAttributeUpdated() {
        UpdateUserAttributeEvent updateUserAttributeEvent = (UpdateUserAttributeEvent)Mockito.mock(UpdateUserAttributeEvent.class);
        Mockito.when((Object)updateUserAttributeEvent.getContext()).thenReturn((Object)this.userAttributesEditor);
        this.tested.user = this.user;
        this.tested.onAttributeUpdated(updateUserAttributeEvent);
        this.assertSetDirty();
    }

    @Test
    public void testOnRemoveUserGroupEvent() {
        OnRemoveUserGroupEvent onRemoveUserGroupEvent = (OnRemoveUserGroupEvent)Mockito.mock(OnRemoveUserGroupEvent.class);
        Mockito.when((Object)onRemoveUserGroupEvent.getContext()).thenReturn((Object)this.userAssignedGroupsExplorer);
        this.tested.user = this.user;
        this.tested.onOnRemoveUserGroupEvent(onRemoveUserGroupEvent);
        this.assertSetDirty();
    }

    @Test
    public void testOnUserGroupsUpdatedEvent() {
        OnUpdateUserGroupsEvent onUpdateUserGroupsEvent = (OnUpdateUserGroupsEvent)Mockito.mock(OnUpdateUserGroupsEvent.class);
        Mockito.when((Object)onUpdateUserGroupsEvent.getContext()).thenReturn((Object)this.userAssignedGroupsEditor);
        this.tested.user = this.user;
        this.tested.onOnUserGroupsUpdatedEvent(onUpdateUserGroupsEvent);
        this.assertSetDirty();
    }

    private void assertSetDirty() {
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonEnabled(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).showNotification(Mockito.anyString());
    }
}

