/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.MultiplePermissionNodeViewer;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionNodeViewer;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionWidgetFactory;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.client.authz.tree.LoadCallback;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.impl.PermissionGroupNode;
import org.uberfire.security.client.authz.tree.impl.PermissionResourceNode;
import org.uberfire.security.impl.authz.DotNamedPermission;

@RunWith(value=MockitoJUnitRunner.class)
public class MultiplePermissionNodeViewerTest {
    @Mock
    MultiplePermissionNodeViewer.View view;
    @Mock
    PermissionWidgetFactory widgetFactory;
    @Mock
    PermissionNode childNode1;
    @Mock
    PermissionNode childNode2;
    @Mock
    PermissionNodeViewer childViewer1;
    @Mock
    PermissionNodeViewer childViewer2;
    MultiplePermissionNodeViewer presenter;
    PermissionGroupNode permissionGroupNode;
    PermissionResourceNode permissionResourceNode;
    Permission permission1;
    Permission permission2;
    Permission permission3;

    @Before
    public void setUp() {
        this.presenter = new MultiplePermissionNodeViewer(this.view, this.widgetFactory);
        Mockito.when((Object)this.widgetFactory.createViewer(this.childNode1)).thenReturn((Object)this.childViewer1);
        Mockito.when((Object)this.widgetFactory.createViewer(this.childNode2)).thenReturn((Object)this.childViewer2);
        this.permission1 = new DotNamedPermission("p1", Boolean.valueOf(false));
        this.permission2 = new DotNamedPermission("p2", Boolean.valueOf(true));
        this.permission3 = new DotNamedPermission("p2.a", Boolean.valueOf(false));
        this.permissionGroupNode = (PermissionGroupNode)Mockito.spy((Object)new PermissionGroupNode(null));
        this.permissionGroupNode.setNodeName("r1");
        this.permissionResourceNode = (PermissionResourceNode)Mockito.spy((Object)new PermissionResourceNode("r2", null));
        this.permissionResourceNode.setNodeName("r2");
        this.permissionResourceNode.addPermission(this.permission1, "grant1", "deny1");
        this.permissionResourceNode.addPermission(this.permission2, "grant2", "deny2");
        Mockito.when((Object)this.childNode1.getNodeName()).thenReturn((Object)"p2.a");
        Mockito.when((Object)this.childNode1.getPermissionList()).thenReturn(Arrays.asList(this.permission3));
        ((PermissionGroupNode)Mockito.doAnswer(invocationOnMock -> {
            LoadCallback callback = (LoadCallback)invocationOnMock.getArguments()[0];
            callback.afterLoad(Arrays.asList(this.childNode1, this.childNode2));
            return null;
        }).when((Object)this.permissionGroupNode)).expand((LoadCallback)Mockito.any(LoadCallback.class));
        ((PermissionResourceNode)Mockito.doAnswer(invocationOnMock -> {
            LoadCallback callback = (LoadCallback)invocationOnMock.getArguments()[0];
            callback.afterLoad(Arrays.asList(this.childNode1));
            return null;
        }).when((Object)this.permissionResourceNode)).expand((LoadCallback)Mockito.any(LoadCallback.class));
    }

    @Test
    public void testInitGroupNode() {
        this.presenter.show((PermissionNode)this.permissionGroupNode);
        Assert.assertEquals((Object)this.presenter.getPermissionNode(), (Object)this.permissionGroupNode);
        ((MultiplePermissionNodeViewer.View)Mockito.verify((Object)this.view)).setNodeName("r1");
        ((MultiplePermissionNodeViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setNodeFullName(Mockito.anyString());
        ((MultiplePermissionNodeViewer.View)Mockito.verify((Object)this.view)).setPermissionsVisible(false);
        ((MultiplePermissionNodeViewer.View)Mockito.verify((Object)this.view)).addChildViewer(this.childViewer1);
        ((MultiplePermissionNodeViewer.View)Mockito.verify((Object)this.view)).addChildViewer(this.childViewer2);
    }

    @Test
    public void testInitResourceNode() {
        this.presenter.show((PermissionNode)this.permissionResourceNode);
        Assert.assertEquals((Object)this.presenter.getPermissionNode(), (Object)this.permissionResourceNode);
        ((MultiplePermissionNodeViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addChildViewer((PermissionNodeViewer)Mockito.any());
        ((MultiplePermissionNodeViewer.View)Mockito.verify((Object)this.view)).setNodeName("r2");
        ((MultiplePermissionNodeViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setNodeFullName(Mockito.anyString());
        ((MultiplePermissionNodeViewer.View)Mockito.verify((Object)this.view)).setPermissionsVisible(true);
        ((MultiplePermissionNodeViewer.View)Mockito.verify((Object)this.view)).addItemsGrantedPermission("grant2", "r2");
        ((MultiplePermissionNodeViewer.View)Mockito.verify((Object)this.view)).addItemException("p2.a");
    }
}

