/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchDropDown;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchResults;
import org.uberfire.mvp.Command;

@Dependent
public class PriorityDropDown
implements IsWidget {
    LiveSearchDropDown liveSearchDropDown;
    List<String> priorityItemList;

    @Inject
    public PriorityDropDown(LiveSearchDropDown liveSearchDropDown) {
        this.liveSearchDropDown = liveSearchDropDown;
        this.priorityItemList = new ArrayList<String>();
    }

    @PostConstruct
    private void init() {
        this.priorityItemList.add(UsersManagementWidgetsConstants.INSTANCE.priorityVeryHigh());
        this.priorityItemList.add(UsersManagementWidgetsConstants.INSTANCE.priorityHigh());
        this.priorityItemList.add(UsersManagementWidgetsConstants.INSTANCE.priorityNormal());
        this.priorityItemList.add(UsersManagementWidgetsConstants.INSTANCE.priorityLow());
        this.priorityItemList.add(UsersManagementWidgetsConstants.INSTANCE.priorityVeryLow());
        LiveSearchResults liveSearchResults = new LiveSearchResults(this.priorityItemList).sortByKey();
        this.liveSearchDropDown.setSelectorHint(UsersManagementWidgetsConstants.INSTANCE.selectPriorityHint());
        this.liveSearchDropDown.setSearchEnabled(false);
        this.liveSearchDropDown.setSearchService((pattern, maxResults, callback) -> callback.afterSearch(liveSearchResults));
    }

    public Widget asWidget() {
        return this.liveSearchDropDown.asWidget();
    }

    public String getPriorityName(int priority) {
        Priority p = this.resolvePriority(priority);
        int idx = p.getIndex();
        return this.priorityItemList.get(idx);
    }

    public int getSelectedPriority() {
        String selected = this.liveSearchDropDown.getSelectedKey();
        if (selected == null) {
            return -1;
        }
        int idx = this.priorityItemList.indexOf(selected);
        return Priority.get(idx).getOrdinal();
    }

    public void setSelectedPriority(int ordinal) {
        Priority priority = this.resolvePriority(ordinal);
        String item = this.priorityItemList.get(priority.getIndex());
        this.liveSearchDropDown.setSelectedItem(item, item);
    }

    public void setWidth(int minWidth) {
        this.liveSearchDropDown.setWidth(minWidth);
    }

    public void setOnChange(Command onChange) {
        this.liveSearchDropDown.setOnChange(onChange);
    }

    public void clear() {
        this.liveSearchDropDown.clear();
    }

    public Priority resolvePriority(int priority) {
        if (priority < -5) {
            return Priority.VERY_LOW;
        }
        if (priority < 0) {
            return Priority.LOW;
        }
        if (priority == 0) {
            return Priority.NORMAL;
        }
        if (priority <= 5) {
            return Priority.HIGH;
        }
        return Priority.VERY_HIGH;
    }

    private static enum Priority {
        VERY_HIGH(10),
        HIGH(5),
        NORMAL(0),
        LOW(-5),
        VERY_LOW(-10);

        private static Priority[] _typeArray;
        int ordinal = 0;

        private Priority(int ordinal) {
            this.ordinal = ordinal;
        }

        public static Priority get(int idx) {
            return _typeArray[idx];
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public int getIndex() {
            for (int i = 0; i < _typeArray.length; ++i) {
                Priority item = _typeArray[i];
                if (!this.equals((Object)item)) continue;
                return i;
            }
            return -1;
        }

        static {
            _typeArray = Priority.values();
        }
    }
}

