/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user.workflow;

import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.ext.security.management.api.exception.InvalidEntityIdentifierException;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.api.exception.UserAlreadyExistsException;
import org.uberfire.ext.security.management.api.exception.UserNotFoundException;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.editor.user.UserEditorDriver;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.ChangePassword;
import org.uberfire.ext.security.management.client.widgets.management.CreateEntity;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.workflow.BaseUserEditorWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.editor.workflow.EntityWorkflowView;
import org.uberfire.ext.security.management.client.widgets.management.events.CreateUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.CreateUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnChangePasswordEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnDeleteEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnEditEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnRemoveUserGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnRemoveUserRoleEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnUpdateUserGroupsEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnUpdateUserRolesEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.UpdateUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class UserCreationWorkflow
extends BaseUserEditorWorkflow {
    CreateEntity createEntity;
    Event<CreateUserEvent> createUserEvent;

    @Inject
    public UserCreationWorkflow(ClientUserSystemManager userSystemManager, Event<OnErrorEvent> errorEvent, Event<NotificationEvent> workbenchNotification, Event<DeleteUserEvent> deleteUserEvent, Event<SaveUserEvent> saveUserEvent, Event<CreateUserEvent> createUserEvent, ConfirmBox confirmBox, CreateEntity createEntity, UserEditor userEditor, UserEditorDriver userEditorDriver, ChangePassword changePassword, LoadingBox loadingBox, EntityWorkflowView view) {
        super(userSystemManager, errorEvent, workbenchNotification, deleteUserEvent, saveUserEvent, confirmBox, userEditor, userEditorDriver, changePassword, loadingBox, view);
        this.createUserEvent = createUserEvent;
        this.createEntity = createEntity;
    }

    @PostConstruct
    public void init() {
    }

    public void create() {
        this.checkClear();
        this.getUserEditor().setPermissionsVisible(false);
        this.createEntity.show(UsersManagementWidgetsConstants.INSTANCE.inputUserName(), UsersManagementWidgetsConstants.INSTANCE.username() + "...");
        this.view.setWidget((IsWidget)this.createEntity.asWidget()).setCancelButtonVisible(false).setSaveButtonVisible(true).setSaveButtonEnabled(true).setSaveButtonText(UsersManagementWidgetsConstants.INSTANCE.next()).setCallback(new EntityWorkflowView.Callback(){

            @Override
            public void onSave() {
                UserCreationWorkflow.this.onCreateEntityClick();
            }

            @Override
            public void onCancel() {
            }
        });
    }

    void onCreateEntityClick() {
        final String identifier = this.createEntity.getEntityIdentifier();
        if (identifier != null) {
            this.checkCreate(identifier, new CheckCreateCallback(){

                @Override
                public void valid() {
                    UserCreationWorkflow.this.createEntity.clear();
                    UserCreationWorkflow.this.user = UserCreationWorkflow.this.userEditorDriver.createNewUser(identifier);
                    UserCreationWorkflow.this.doEdit();
                }

                @Override
                public void invalid(SecurityManagementException exception) {
                    UserCreationWorkflow.this.showError((Throwable)exception);
                    UserCreationWorkflow.this.createEntity.setErrorState();
                }

                @Override
                public void error(Throwable error) {
                    UserCreationWorkflow.this.showError(error);
                }
            });
        }
    }

    protected void doEdit() {
        this.doShowEditorView();
        this.edit();
        this.view.setSaveButtonText(UsersManagementWidgetsConstants.INSTANCE.create()).setSaveButtonEnabled(true).setSaveButtonVisible(true).setCancelButtonVisible(true);
        this.getUserEditor().setEditButtonVisible(false).setChangePasswordButtonVisible(false).setDeleteButtonVisible(false);
    }

    @Override
    protected void doSaveRemoteServiceCall(RemoteCallback<User> callback) {
        this.userSystemManager.users(callback, this.errorCallback).create((Object)this.user);
    }

    @Override
    protected void afterSave(String id) {
        this.confirmBox.show(UsersManagementWidgetsConstants.INSTANCE.confirmAction(), UsersManagementWidgetsConstants.INSTANCE.doSetPasswordNow(), new Command(){

            public void execute() {
                UserCreationWorkflow.this.showPasswordPopup(new ChangePassword.ChangePasswordCallback(){

                    @Override
                    public void onPasswordUpdated() {
                        UserCreationWorkflow.this.doAfterSave(UserCreationWorkflow.this.user.getIdentifier());
                    }

                    @Override
                    public void onError(Throwable throwable) {
                        UserCreationWorkflow.this.showError(throwable);
                        UserCreationWorkflow.this.onCancel();
                    }
                });
            }
        }, new Command(){

            public void execute() {
                UserCreationWorkflow.this.doAfterSave(UserCreationWorkflow.this.user.getIdentifier());
            }
        });
    }

    private void doAfterSave(String id) {
        this.workbenchNotification.fire((Object)new NotificationEvent(UsersManagementWidgetsConstants.INSTANCE.userCreated(id), NotificationEvent.NotificationType.SUCCESS));
        this.createUserEvent.fire((Object)new CreateUserEvent(id));
        this.create();
    }

    @Override
    protected String getSaveButtonText() {
        return UsersManagementWidgetsConstants.INSTANCE.saveChanges();
    }

    @Override
    protected void onCancel() {
        this.create();
    }

    private void checkCreate(final String identifier, final CheckCreateCallback callback) {
        this.showLoadingBox();
        this.userSystemManager.users((RemoteCallback)new RemoteCallback<User>(){

            public void callback(User o) {
                UserCreationWorkflow.this.hideLoadingBox();
                callback.invalid((SecurityManagementException)new UserAlreadyExistsException(identifier));
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message o, Throwable throwable) {
                UserCreationWorkflow.this.hideLoadingBox();
                if (throwable instanceof UserNotFoundException) {
                    callback.valid();
                } else if (throwable instanceof InvalidEntityIdentifierException) {
                    callback.invalid(new SecurityManagementException(UserCreationWorkflow.this.getUserNameNotValidMessage((InvalidEntityIdentifierException)throwable), throwable));
                } else {
                    callback.error(throwable);
                }
                return false;
            }
        }).get(identifier);
    }

    private String getUserNameNotValidMessage(InvalidEntityIdentifierException e) {
        return UsersManagementWidgetsConstants.INSTANCE.invalidUserName() + " [" + e.getIdentifier() + "]. " + UsersManagementWidgetsConstants.INSTANCE.patternAlphanumericSymbols() + " [" + e.getSymbolsAccepted() + "]";
    }

    @Override
    public void clear() {
        super.clear();
        this.createEntity.clear();
    }

    void onEditUserEvent(@Observes OnEditEvent onEditEvent) {
        if (this.checkEventContext(onEditEvent, this.getUserEditor())) {
            this.edit();
        }
    }

    void onDeleteUserEvent(@Observes OnDeleteEvent onDeleteEvent) {
        if (this.checkEventContext(onDeleteEvent, this.getUserEditor())) {
            this.doDelete();
        }
    }

    void onChangeUserPasswordEvent(@Observes OnChangePasswordEvent onChangePasswordEvent) {
        if (this.checkEventContext(onChangePasswordEvent, this.getUserEditor())) {
            this.doChangePassword();
        }
    }

    void onAttributeCreated(@Observes CreateUserAttributeEvent createUserAttributeEvent) {
        if (this.checkEventContext(createUserAttributeEvent, this.getUserEditor().attributesEditor())) {
            this.setDirty(true);
        }
    }

    void onAttributeDeleted(@Observes DeleteUserAttributeEvent deleteUserAttributeEvent) {
        if (this.checkEventContext(deleteUserAttributeEvent, this.getUserEditor().attributesEditor())) {
            this.setDirty(true);
        }
    }

    void onAttributeUpdated(@Observes UpdateUserAttributeEvent updateUserAttributeEvent) {
        if (this.checkEventContext(updateUserAttributeEvent, this.getUserEditor().attributesEditor())) {
            this.setDirty(true);
        }
    }

    void onOnRemoveUserGroupEvent(@Observes OnRemoveUserGroupEvent onRemoveUserGroupEvent) {
        if (this.checkEventContext(onRemoveUserGroupEvent, this.getUserEditor().groupsExplorer())) {
            this.setDirty(true);
        }
    }

    void onOnUserGroupsUpdatedEvent(@Observes OnUpdateUserGroupsEvent onUpdateUserGroupsEvent) {
        if (this.checkEventContext(onUpdateUserGroupsEvent, this.getUserEditor().groupsEditor())) {
            this.setDirty(true);
        }
    }

    void onOnRemoveUserRoleEvent(@Observes OnRemoveUserRoleEvent onRemoveUserRoleEvent) {
        if (this.checkEventContext(onRemoveUserRoleEvent, this.getUserEditor().rolesExplorer())) {
            this.setDirty(true);
        }
    }

    void onOnUserRolesUpdatedEvent(@Observes OnUpdateUserRolesEvent onUpdateUserRolesEvent) {
        if (this.checkEventContext(onUpdateUserRolesEvent, this.getUserEditor().rolesEditor())) {
            this.setDirty(true);
        }
    }

    private static interface CheckCreateCallback {
        public void valid();

        public void invalid(SecurityManagementException var1);

        public void error(Throwable var1);
    }
}

