/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user.workflow;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashSet;
import javax.enterprise.event.Event;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.service.UserManagerService;
import org.uberfire.ext.security.management.client.editor.user.UserEditorDriver;
import org.uberfire.ext.security.management.client.widgets.management.AbstractSecurityManagementTest;
import org.uberfire.ext.security.management.client.widgets.management.ChangePassword;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLViewer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedGroupsEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedGroupsExplorer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedRolesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAttributesEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.workflow.UserEditorWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.editor.workflow.EntityWorkflowView;
import org.uberfire.ext.security.management.client.widgets.management.events.CreateUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnChangePasswordEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnDeleteEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnEditEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnRemoveUserGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnUpdateUserGroupsEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.UpdateUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class UserEditorWorkflowTest
extends AbstractSecurityManagementTest {
    @Mock
    EventSourceMock<OnErrorEvent> errorEvent;
    @Mock
    EventSourceMock<DeleteUserEvent> deleteUserEvent;
    @Mock
    EventSourceMock<SaveUserEvent> saveUserEvent;
    @Mock
    ConfirmBox confirmBox;
    @Mock
    UserEditor userEditor;
    @Mock
    ACLViewer aclViewer;
    @Mock
    UserEditorDriver userEditorDriver;
    @Mock
    ChangePassword changePassword;
    @Mock
    LoadingBox loadingBox;
    @Mock
    EntityWorkflowView view;
    @Mock
    UserAttributesEditor userAttributesEditor;
    @Mock
    UserAssignedGroupsExplorer userAssignedGroupsExplorer;
    @Mock
    UserAssignedGroupsEditor userAssignedGroupsEditor;
    @Mock
    UserAssignedRolesExplorer userAssignedRolesExplorer;
    @Mock
    User user;
    private UserEditorWorkflow tested;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.userEditor.attributesEditor()).thenReturn((Object)this.userAttributesEditor);
        Mockito.when((Object)this.userEditor.groupsExplorer()).thenReturn((Object)this.userAssignedGroupsExplorer);
        Mockito.when((Object)this.userEditor.groupsEditor()).thenReturn((Object)this.userAssignedGroupsEditor);
        Mockito.when((Object)this.userEditor.rolesExplorer()).thenReturn((Object)this.userAssignedRolesExplorer);
        Mockito.when((Object)this.userEditor.getACLViewer()).thenReturn((Object)this.aclViewer);
        HashSet<Group> groups = new HashSet<Group>();
        Group group1 = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)group1.getName()).thenReturn((Object)"group1");
        groups.add(group1);
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"user1");
        Mockito.when((Object)this.user.getGroups()).thenReturn(groups);
        this.tested = new UserEditorWorkflow(this.userSystemManager, this.errorEvent, (Event)this.workbenchNotification, this.deleteUserEvent, this.saveUserEvent, this.confirmBox, this.userEditor, this.userEditorDriver, this.changePassword, this.loadingBox, this.view);
    }

    @Test
    public void testOnEditUserEvent() {
        OnEditEvent onEditEvent = (OnEditEvent)Mockito.mock(OnEditEvent.class);
        Mockito.when((Object)onEditEvent.getContext()).thenReturn((Object)this.userEditor);
        this.tested.user = this.user;
        this.tested.onEditUserEvent(onEditEvent);
        ((UserEditorDriver)Mockito.verify((Object)this.userEditorDriver, (VerificationMode)Mockito.times((int)1))).edit(this.user, (org.uberfire.ext.security.management.client.editor.user.UserEditor)this.userEditor);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCancelButtonVisible(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCallback((EntityWorkflowView.Callback)Mockito.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonText(Mockito.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Mockito.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonVisible(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setSaveButtonEnabled(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showNotification(Mockito.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearNotifications();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)0))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)0))).hide();
    }

    @Test
    public void testOnDeleteUserEvent() {
        OnDeleteEvent onDeleteEvent = (OnDeleteEvent)Mockito.mock(OnDeleteEvent.class);
        Mockito.when((Object)onDeleteEvent.getContext()).thenReturn((Object)this.userEditor);
        this.tested.user = this.user;
        ((ConfirmBox)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                Command callback = (Command)invocationOnMock.getArguments()[2];
                callback.execute();
                return null;
            }
        }).when((Object)this.confirmBox)).show(Mockito.anyString(), Mockito.anyString(), (Command)Mockito.any(), (Command)Mockito.any());
        this.tested.onDeleteUserEvent(onDeleteEvent);
        ((ConfirmBox)Mockito.verify((Object)this.confirmBox, (VerificationMode)Mockito.times((int)1))).show(Mockito.anyString(), Mockito.anyString(), (Command)Mockito.any(), (Command)Mockito.any());
        ((UserManagerService)Mockito.verify((Object)this.userManagerService, (VerificationMode)Mockito.times((int)1))).delete(new String[]{Mockito.anyString()});
    }

    @Test
    public void testOnChangeUserPasswordEvent() {
        OnChangePasswordEvent onChangePasswordEvent = (OnChangePasswordEvent)Mockito.mock(OnChangePasswordEvent.class);
        Mockito.when((Object)onChangePasswordEvent.getContext()).thenReturn((Object)this.userEditor);
        this.tested.user = this.user;
        this.tested.onChangeUserPasswordEvent(onChangePasswordEvent);
        ((ChangePassword)Mockito.verify((Object)this.changePassword, (VerificationMode)Mockito.times((int)1))).show(Mockito.anyString(), (ChangePassword.ChangePasswordCallback)Mockito.any(ChangePassword.ChangePasswordCallback.class));
    }

    @Test
    public void testOnAttributeCreated() {
        CreateUserAttributeEvent createUserAttributeEvent = (CreateUserAttributeEvent)Mockito.mock(CreateUserAttributeEvent.class);
        Mockito.when((Object)createUserAttributeEvent.getContext()).thenReturn((Object)this.userAttributesEditor);
        this.tested.user = this.user;
        this.tested.onAttributeCreated(createUserAttributeEvent);
        this.assertSetDirty();
    }

    @Test
    public void testOnAttributeDeleted() {
        DeleteUserAttributeEvent deleteUserAttributeEvent = (DeleteUserAttributeEvent)Mockito.mock(DeleteUserAttributeEvent.class);
        Mockito.when((Object)deleteUserAttributeEvent.getContext()).thenReturn((Object)this.userAttributesEditor);
        this.tested.user = this.user;
        this.tested.onAttributeDeleted(deleteUserAttributeEvent);
        this.assertSetDirty();
    }

    @Test
    public void testOnAttributeUpdated() {
        UpdateUserAttributeEvent updateUserAttributeEvent = (UpdateUserAttributeEvent)Mockito.mock(UpdateUserAttributeEvent.class);
        Mockito.when((Object)updateUserAttributeEvent.getContext()).thenReturn((Object)this.userAttributesEditor);
        this.tested.user = this.user;
        this.tested.onAttributeUpdated(updateUserAttributeEvent);
        this.assertSetDirty();
    }

    @Test
    public void testOnRemoveUserGroupEvent() {
        OnRemoveUserGroupEvent onRemoveUserGroupEvent = (OnRemoveUserGroupEvent)Mockito.mock(OnRemoveUserGroupEvent.class);
        Mockito.when((Object)onRemoveUserGroupEvent.getContext()).thenReturn((Object)this.userAssignedGroupsExplorer);
        this.tested.user = this.user;
        this.tested.onOnRemoveUserGroupEvent(onRemoveUserGroupEvent);
        this.assertSetDirty();
    }

    @Test
    public void testOnUserGroupsUpdatedEvent() {
        OnUpdateUserGroupsEvent onUpdateUserGroupsEvent = (OnUpdateUserGroupsEvent)Mockito.mock(OnUpdateUserGroupsEvent.class);
        Mockito.when((Object)onUpdateUserGroupsEvent.getContext()).thenReturn((Object)this.userAssignedGroupsEditor);
        this.tested.user = this.user;
        this.tested.onOnUserGroupsUpdatedEvent(onUpdateUserGroupsEvent);
        this.assertSetDirty();
    }

    private void assertSetDirty() {
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonEnabled(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).showNotification(Mockito.anyString());
    }
}

