/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.event.Event;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.authz.PerspectiveTreeProvider;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLSettings;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.PriorityDropDown;
import org.uberfire.ext.security.management.client.widgets.management.events.HomePerspectiveChangedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.PriorityChangedEvent;
import org.uberfire.ext.widgets.common.client.dropdown.PerspectiveDropDown;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.authz.PermissionTypeRegistry;
import org.uberfire.security.impl.authz.DefaultPermissionManager;
import org.uberfire.security.impl.authz.DefaultPermissionTypeRegistry;

@RunWith(value=MockitoJUnitRunner.class)
public class ACLSettingsTest {
    @Mock
    ACLSettings.View view;
    @Mock
    PerspectiveDropDown homePerspectiveDropDown;
    @Mock
    PerspectiveTreeProvider perspectiveTreeProvider;
    @Mock
    PriorityDropDown priorityDropDown;
    @Mock
    Event<HomePerspectiveChangedEvent> homePerspectiveChangedEvent;
    @Mock
    Event<PriorityChangedEvent> priorityChangedEvent;
    @Mock
    PerspectiveActivity defaultPerspective;
    ACLSettings presenter;
    PermissionManager permissionManager;

    @Before
    public void setup() {
        this.permissionManager = (PermissionManager)Mockito.spy((Object)new DefaultPermissionManager((PermissionTypeRegistry)new DefaultPermissionTypeRegistry()));
        this.permissionManager.setAuthorizationPolicy(this.permissionManager.newAuthorizationPolicy().role("admin").home("HomeAdmin").priority(10).group("group1").home("HomeGroup1").priority(-100).build());
        this.presenter = new ACLSettings(this.view, this.permissionManager, this.homePerspectiveDropDown, this.perspectiveTreeProvider, this.priorityDropDown, this.homePerspectiveChangedEvent, this.priorityChangedEvent);
        Mockito.when((Object)this.defaultPerspective.getIdentifier()).thenReturn((Object)"DefaultPerspective");
        Mockito.when((Object)this.homePerspectiveDropDown.getDefaultPerspective()).thenReturn((Object)this.defaultPerspective);
        Mockito.when((Object)this.homePerspectiveDropDown.getItemName("DefaultPerspective")).thenReturn((Object)"DefaultPerspective");
        Mockito.when((Object)this.homePerspectiveDropDown.getItemName("HomeAdmin")).thenReturn((Object)"HomeAdmin");
        Mockito.when((Object)this.homePerspectiveDropDown.getItemName("HomeGroup1")).thenReturn((Object)"HomeGroup1");
        Mockito.when((Object)this.priorityDropDown.getPriorityName(10)).thenReturn((Object)"High");
        Mockito.when((Object)this.priorityDropDown.getPriorityName(-100)).thenReturn((Object)"Very Low");
    }

    @Test
    public void testShowRole() {
        this.presenter.show((Role)new RoleImpl("admin"));
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setHomePerspectiveSelectorEnabled(false);
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setPrioritySelectorEnabled(false);
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setHomePerspectiveSelector((IsWidget)Mockito.any());
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setPrioritySelector((IsWidget)Mockito.any());
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setHomePerspectiveName("HomeAdmin");
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setHomePerspectiveTitle("HomeAdmin");
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setPriorityName("High");
    }

    @Test
    public void testEditRole() {
        this.presenter.edit((Role)new RoleImpl("admin"));
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setHomePerspectiveSelectorEnabled(true);
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setPrioritySelectorEnabled(true);
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setHomePerspectiveSelector((IsWidget)Mockito.any());
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setPrioritySelector((IsWidget)Mockito.any());
        ((PerspectiveDropDown)Mockito.verify((Object)this.homePerspectiveDropDown)).setSelectedPerspective("HomeAdmin");
        ((PriorityDropDown)Mockito.verify((Object)this.priorityDropDown)).setSelectedPriority(10);
    }

    @Test
    public void testShowGroup() {
        this.presenter.show((Group)new GroupImpl("group1"));
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setHomePerspectiveSelectorEnabled(false);
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setPrioritySelectorEnabled(false);
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setHomePerspectiveSelector((IsWidget)Mockito.any());
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setPrioritySelector((IsWidget)Mockito.any());
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setHomePerspectiveName("HomeGroup1");
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setHomePerspectiveTitle("HomeGroup1");
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setPriorityName("Very Low");
    }

    @Test
    public void testEditGroup() {
        this.presenter.edit((Group)new GroupImpl("group1"));
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setHomePerspectiveSelectorEnabled(true);
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setPrioritySelectorEnabled(true);
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setHomePerspectiveSelector((IsWidget)Mockito.any());
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setPrioritySelector((IsWidget)Mockito.any());
        ((PerspectiveDropDown)Mockito.verify((Object)this.homePerspectiveDropDown)).setSelectedPerspective("HomeGroup1");
        ((PriorityDropDown)Mockito.verify((Object)this.priorityDropDown)).setSelectedPriority(-100);
    }

    @Test
    public void testDefaultValues() {
        Mockito.reset((Object[])new ACLSettings.View[]{this.view});
        this.permissionManager.setAuthorizationPolicy(this.permissionManager.newAuthorizationPolicy().build());
        this.presenter = new ACLSettings(this.view, this.permissionManager, this.homePerspectiveDropDown, this.perspectiveTreeProvider, this.priorityDropDown, this.homePerspectiveChangedEvent, this.priorityChangedEvent);
        this.presenter.show((Role)new RoleImpl("admin"));
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setHomePerspectiveSelectorEnabled(false);
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setPrioritySelectorEnabled(false);
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setHomePerspectiveSelector((IsWidget)Mockito.any());
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setPrioritySelector((IsWidget)Mockito.any());
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setHomePerspectiveName("DefaultPerspective");
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setHomePerspectiveTitle("DefaultPerspective");
        ((ACLSettings.View)Mockito.verify((Object)this.view)).setPriorityName("Very Low");
    }

    @Test
    public void testOnHomePerspectiveChange() {
        this.presenter.onHomePerspectiveSelected();
        ((Event)Mockito.verify(this.homePerspectiveChangedEvent)).fire(Mockito.any());
    }

    @Test
    public void testOnPrioritySelected() {
        this.presenter.onPrioritySelected();
        ((Event)Mockito.verify(this.priorityChangedEvent)).fire(Mockito.any());
    }
}

