/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.group.workflow;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.security.shared.api.Group;
import org.uberfire.backend.authz.AuthorizationService;
import org.uberfire.client.authz.PerspectiveAction;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.editor.group.GroupEditorDriver;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.editor.group.GroupEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.workflow.EntityWorkflowView;
import org.uberfire.ext.security.management.client.widgets.management.events.ContextualEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.HomePerspectiveChangedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnDeleteEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnEditEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionChangedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionNodeAddedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionNodeRemovedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.PriorityChangedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveGroupEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.mvp.Command;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class GroupEditorWorkflow
implements IsWidget {
    public EntityWorkflowView view;
    ClientUserSystemManager userSystemManager;
    Caller<AuthorizationService> authorizationService;
    PermissionManager permissionManager;
    Event<OnErrorEvent> errorEvent;
    protected final ErrorCallback<Message> errorCallback = (message, throwable) -> {
        this.showError(throwable);
        return false;
    };
    Event<NotificationEvent> workbenchNotification;
    Event<SaveGroupEvent> saveGroupEvent;
    Event<DeleteGroupEvent> deleteGroupEvent;
    ConfirmBox confirmBox;
    LoadingBox loadingBox;
    GroupEditor groupEditor;
    GroupEditorDriver groupEditorDriver;
    Group group;
    boolean isDirty;
    PerspectiveActivity selectedHomePerspective = null;

    @Inject
    public GroupEditorWorkflow(ClientUserSystemManager userSystemManager, Caller<AuthorizationService> authorizationService, PermissionManager permissionManager, Event<OnErrorEvent> errorEvent, ConfirmBox confirmBox, LoadingBox loadingBox, Event<NotificationEvent> workbenchNotification, Event<SaveGroupEvent> saveGroupEvent, Event<DeleteGroupEvent> deleteGroupEvent, GroupEditor groupEditor, GroupEditorDriver groupEditorDriver, EntityWorkflowView view) {
        this.userSystemManager = userSystemManager;
        this.authorizationService = authorizationService;
        this.permissionManager = permissionManager;
        this.errorEvent = errorEvent;
        this.confirmBox = confirmBox;
        this.workbenchNotification = workbenchNotification;
        this.saveGroupEvent = saveGroupEvent;
        this.deleteGroupEvent = deleteGroupEvent;
        this.groupEditor = groupEditor;
        this.view = view;
        this.groupEditorDriver = groupEditorDriver;
        this.loadingBox = loadingBox;
        this.isDirty = false;
    }

    @PostConstruct
    public void setup() {
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public GroupEditor getGroupEditor() {
        return this.groupEditor;
    }

    public void show(String name) {
        this.doShow(name);
    }

    protected String getSaveButtonText() {
        return UsersManagementWidgetsConstants.INSTANCE.saveChanges();
    }

    protected void onSave() {
        this.doSave();
    }

    protected void onCancel() {
        this.doShow(this.group.getName());
    }

    public void clear() {
        this.groupEditor.clear();
        this.view.clearNotifications();
        this.group = null;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    void delete() {
        String name = this.group.getName();
        this.userSystemManager.groups(v -> {
            this.deleteGroupEvent.fire((Object)new DeleteGroupEvent(name));
            this.workbenchNotification.fire((Object)new NotificationEvent(UsersManagementWidgetsConstants.INSTANCE.groupRemoved(name), NotificationEvent.NotificationType.INFO));
            this.clear();
        }, this.errorCallback).delete(new String[]{name});
    }

    protected void doShow(String groupName) {
        assert (groupName != null);
        this.doInitView();
        this.checkDirty(() -> this.doLoad(groupName));
    }

    protected void doInitView() {
        this.view.setWidget((IsWidget)this.groupEditor.asWidget()).setCancelButtonVisible(true).setSaveButtonVisible(true).setSaveButtonEnabled(this.isDirty).setSaveButtonText(this.getSaveButtonText()).setCallback(new EntityWorkflowView.Callback(){

            @Override
            public void onSave() {
                GroupEditorWorkflow.this.onSave();
            }

            @Override
            public void onCancel() {
                GroupEditorWorkflow.this.onCancel();
            }
        });
    }

    protected void doLoad(String name) {
        this.clear();
        this.showLoadingBox();
        this.userSystemManager.groups(o -> {
            this.hideLoadingBox();
            this.group = o;
            assert (this.group != null);
            this.edit();
        }, this.errorCallback).get(name);
    }

    protected void doSave() {
        assert (this.group != null);
        boolean isValid = this.groupEditorDriver.flush();
        this.group = this.groupEditorDriver.getValue();
        PermissionCollection groupPermissions = this.groupEditorDriver.getPermissions();
        PerspectiveActivity homePerspective = this.groupEditorDriver.getHomePerspective();
        int groupPriority = this.groupEditorDriver.getGroupPriority();
        if (!isValid) {
            throw new RuntimeException("Group must be valid before updating it.");
        }
        this.showLoadingBox();
        AuthorizationPolicy authzPolicy = this.permissionManager.getAuthorizationPolicy();
        authzPolicy.setHomePerspective(this.group, homePerspective.getIdentifier());
        authzPolicy.setPriority(this.group, groupPriority);
        authzPolicy.setPermissions(this.group, groupPermissions);
        ((AuthorizationService)this.authorizationService.call(r -> {
            this.hideLoadingBox();
            this.isDirty = false;
            this.workbenchNotification.fire((Object)new NotificationEvent(UsersManagementWidgetsConstants.INSTANCE.groupSaved(this.group.getName()), NotificationEvent.NotificationType.SUCCESS));
            this.saveGroupEvent.fire((Object)new SaveGroupEvent(this.group.getName()));
            this.doShow(this.group.getName());
        }, this.errorCallback)).savePolicy(authzPolicy);
    }

    protected void showNotification(String message) {
        this.view.showNotification(message);
    }

    protected void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        this.view.setSaveButtonVisible(isDirty);
        this.view.setSaveButtonEnabled(isDirty);
        this.view.setCancelButtonVisible(true);
        if (isDirty) {
            this.view.showNotification(UsersManagementWidgetsConstants.INSTANCE.groupModified(this.group.getName()));
        } else {
            this.view.clearNotifications();
        }
    }

    protected void checkDirty(Command callback) {
        if (this.isDirty) {
            this.confirmBox.show(UsersManagementWidgetsConstants.INSTANCE.confirmAction(), UsersManagementWidgetsConstants.INSTANCE.groupIsDirty(), () -> {
                this.isDirty = false;
                callback.execute();
            }, () -> {});
        } else {
            callback.execute();
        }
    }

    protected void showLoadingBox() {
        this.loadingBox.show();
    }

    protected void hideLoadingBox() {
        this.loadingBox.hide();
    }

    void showError(Throwable throwable) {
        this.errorEvent.fire((Object)new OnErrorEvent(this, throwable));
    }

    protected void edit() {
        this.groupEditorDriver.edit(this.group, (org.uberfire.ext.security.management.client.editor.group.GroupEditor)this.groupEditor);
        this.view.setCancelButtonVisible(false);
        this.view.setSaveButtonVisible(false);
        this.selectedHomePerspective = this.groupEditor.getAclSettings().getHomePerspective();
        if (this.isPerspectiveReadDenied(this.selectedHomePerspective)) {
            this.showNotification(UsersManagementWidgetsConstants.INSTANCE.homePerspectiveReadDenied());
        }
    }

    void onEditGroupEvent(@Observes OnEditEvent onEditEvent) {
        if (this.checkEventContext(onEditEvent, this.groupEditor)) {
            this.edit();
        }
    }

    void onDeleteGroupEvent(@Observes OnDeleteEvent onDeleteEvent) {
        if (this.checkEventContext(onDeleteEvent, this.groupEditor)) {
            this.confirmBox.show(UsersManagementWidgetsConstants.INSTANCE.confirmAction(), UsersManagementWidgetsConstants.INSTANCE.ensureRemoveGroup(), this::delete, () -> {});
        }
    }

    void onHomePerspectiveChangedEvent(@Observes HomePerspectiveChangedEvent event) {
        if (this.checkEventContext(event, this.groupEditor.getAclSettings())) {
            this.selectedHomePerspective = event.getPerspective();
            this.checkStatus();
        }
    }

    void onPriorityChangedEvent(@Observes PriorityChangedEvent event) {
        if (this.checkEventContext(event, this.groupEditor.getAclSettings())) {
            this.checkStatus();
        }
    }

    void onPermissionChangedEvent(@Observes PermissionChangedEvent event) {
        if (this.checkEventContext(event, this.groupEditor.getAclEditor())) {
            this.checkStatus();
        }
    }

    void onPermissionAddedEvent(@Observes PermissionNodeAddedEvent event) {
        if (this.checkEventContext(event, this.groupEditor.getAclEditor())) {
            this.checkStatus();
        }
    }

    void onPermissionRemovedEvent(@Observes PermissionNodeRemovedEvent event) {
        if (this.checkEventContext(event, this.groupEditor.getAclEditor())) {
            this.checkStatus();
        }
    }

    protected boolean checkEventContext(ContextualEvent contextualEvent, Object context) {
        return contextualEvent != null && contextualEvent.getContext() != null && contextualEvent.getContext().equals(context);
    }

    protected void checkStatus() {
        boolean readDenied = this.isPerspectiveReadDenied(this.selectedHomePerspective);
        if (readDenied) {
            this.setDirty(false);
            this.showNotification(UsersManagementWidgetsConstants.INSTANCE.homePerspectiveReadDenied());
        } else {
            this.setDirty(true);
        }
    }

    protected boolean isPerspectiveReadDenied(PerspectiveActivity perspectiveActivity) {
        if (perspectiveActivity == null) {
            return false;
        }
        PermissionCollection permissionCollection = this.groupEditor.permissions();
        if (permissionCollection == null) {
            return false;
        }
        Permission p = this.permissionManager.createPermission((Resource)perspectiveActivity, PerspectiveAction.READ, false);
        Permission existing = permissionCollection.get(p.getName());
        if (existing != null) {
            return existing.getResult().equals((Object)AuthorizationResult.ACCESS_DENIED);
        }
        return permissionCollection.implies(p);
    }
}

