/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.widgets.management.editor.AssignedEntitiesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedGroupsExplorer;
import org.uberfire.ext.security.management.client.widgets.management.events.OnRemoveUserGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesList;
import org.uberfire.ext.security.management.client.widgets.management.list.GroupsList;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class UserAssignedGroupsExplorerTest {
    @Mock
    ClientUserSystemManager userSystemManager;
    @Mock
    EventSourceMock<OnRemoveUserGroupEvent> removeUserGroupEventEvent;
    @Mock
    ConfirmBox confirmBox;
    @Mock
    GroupsList groupList;
    @Mock
    AssignedEntitiesExplorer view;
    @Mock
    User user;
    private UserAssignedGroupsExplorer tested;

    @Before
    public void setup() {
        HashMap<String, String> userAttributes = new HashMap<String, String>(1);
        userAttributes.put("attr1", "value1");
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"user1");
        Mockito.when((Object)this.user.getProperties()).thenReturn(userAttributes);
        HashSet<GroupImpl> groups = new HashSet<GroupImpl>();
        groups.add(new GroupImpl("group1"));
        Mockito.when((Object)this.user.getGroups()).thenReturn(groups);
        ((ClientUserSystemManager)Mockito.doAnswer((Answer)new Answer<Group>(){

            public Group answer(InvocationOnMock invocationOnMock) throws Throwable {
                Group group = (Group)Mockito.mock(Group.class);
                return group;
            }
        }).when((Object)this.userSystemManager)).createGroup(Matchers.anyString());
        Mockito.when((Object)this.userSystemManager.isUserCapabilityEnabled((Capability)Matchers.any(Capability.class))).thenReturn((Object)true);
        this.tested = new UserAssignedGroupsExplorer(this.userSystemManager, this.confirmBox, this.groupList, this.view, this.removeUserGroupEventEvent);
    }

    @Test
    public void testInit() {
        this.tested.init();
        ((GroupsList)Mockito.verify((Object)this.groupList, (VerificationMode)Mockito.times((int)1))).setPageSize(Matchers.anyInt());
        ((GroupsList)Mockito.verify((Object)this.groupList, (VerificationMode)Mockito.times((int)1))).setEmptyEntitiesText(Matchers.anyString());
        ((AssignedEntitiesExplorer)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).configure(Matchers.anyString(), (EntitiesList.View)Matchers.any(EntitiesList.View.class));
        ((AssignedEntitiesExplorer)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }

    @Test
    public void testClear() {
        this.tested.clear();
        ((AssignedEntitiesExplorer)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).configure(Matchers.anyString(), (EntitiesList.View)Matchers.any(EntitiesList.View.class));
        ((AssignedEntitiesExplorer)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((GroupsList)Mockito.verify((Object)this.groupList, (VerificationMode)Mockito.times((int)1))).clear();
        Assert.assertTrue((boolean)this.tested.entities.isEmpty());
        Assert.assertFalse((boolean)this.tested.isEditMode);
    }

    @Test
    public void testShow() {
        this.tested.show(this.user);
        Assert.assertFalse((boolean)this.tested.isEditMode);
        Assert.assertTrue((this.tested.entities.size() == 1 ? 1 : 0) != 0);
        ((AssignedEntitiesExplorer)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).configure(Matchers.anyString(), (EntitiesList.View)Matchers.any(EntitiesList.View.class));
        ((AssignedEntitiesExplorer)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((GroupsList)Mockito.verify((Object)this.groupList, (VerificationMode)Mockito.times((int)1))).clear();
        ((GroupsList)Mockito.verify((Object)this.groupList, (VerificationMode)Mockito.times((int)1))).show((Collection)Mockito.anySet(), (EntitiesList.Callback)Matchers.any(EntitiesList.Callback.class));
    }

    @Test
    public void testRemoveGroup() {
        Group g = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)g.getName()).thenReturn((Object)"group1");
        this.tested.entities.add(g);
        this.tested.removeEntity("group1");
        Assert.assertFalse((boolean)this.tested.isEditMode);
        Assert.assertTrue((this.tested.entities.size() == 0 ? 1 : 0) != 0);
        ((GroupsList)Mockito.verify((Object)this.groupList, (VerificationMode)Mockito.times((int)1))).show((Collection)Mockito.anySet(), (EntitiesList.Callback)Matchers.any(EntitiesList.Callback.class));
        ((EventSourceMock)Mockito.verify(this.removeUserGroupEventEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(OnRemoveUserGroupEvent.class));
        ((AssignedEntitiesExplorer)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).configure(Matchers.anyString(), (EntitiesList.View)Matchers.any(EntitiesList.View.class));
        ((AssignedEntitiesExplorer)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
        ((GroupsList)Mockito.verify((Object)this.groupList, (VerificationMode)Mockito.times((int)0))).clear();
    }
}

