/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.group.workflow;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.Group;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.authz.AuthorizationService;
import org.uberfire.client.authz.PerspectiveAction;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.ext.security.management.client.editor.group.GroupEditorDriver;
import org.uberfire.ext.security.management.client.widgets.management.AbstractSecurityManagementTest;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLSettings;
import org.uberfire.ext.security.management.client.widgets.management.editor.group.GroupEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.group.workflow.GroupEditorWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.editor.workflow.EntityWorkflowView;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnDeleteEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveGroupEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.impl.authz.DefaultPermissionCollection;
import org.uberfire.security.impl.authz.DefaultPermissionManager;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.ActivityResourceType;

@RunWith(value=GwtMockitoTestRunner.class)
public class GroupEditorWorkflowTest
extends AbstractSecurityManagementTest {
    @Mock
    AuthorizationService authorizationService;
    Caller<AuthorizationService> authorizationServiceCaller;
    @Mock
    EventSourceMock<OnErrorEvent> errorEvent;
    @Mock
    ConfirmBox confirmBox;
    @Mock
    LoadingBox loadingBox;
    @Mock
    EventSourceMock<SaveGroupEvent> saveGroupEvent;
    @Mock
    EventSourceMock<DeleteGroupEvent> deleteGroupEvent;
    @Mock
    GroupEditor groupEditor;
    @Mock
    GroupEditorDriver groupEditorDriver;
    @Mock
    EntityWorkflowView view;
    @Mock
    ACLSettings aclSettings;
    @Mock
    PerspectiveActivity homePerspective;
    PermissionManager permissionManager;
    PermissionCollection permissionCollection;
    GroupEditorWorkflow tested;
    @Mock
    Group group;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.permissionCollection = new DefaultPermissionCollection();
        this.permissionManager = new DefaultPermissionManager();
        Mockito.when((Object)this.homePerspective.getIdentifier()).thenReturn((Object)"home");
        Mockito.when((Object)this.homePerspective.getResourceType()).thenReturn((Object)ActivityResourceType.PERSPECTIVE);
        Mockito.when((Object)this.groupEditor.permissions()).thenReturn((Object)this.permissionCollection);
        Mockito.when((Object)this.aclSettings.getHomePerspective()).thenReturn((Object)this.homePerspective);
        Mockito.when((Object)this.groupEditor.getAclSettings()).thenReturn((Object)this.aclSettings);
        Mockito.when((Object)this.group.getName()).thenReturn((Object)"group1");
        Mockito.when((Object)this.view.setWidget((IsWidget)Matchers.any(IsWidget.class))).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.clearNotifications()).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setCallback((EntityWorkflowView.Callback)Matchers.any(EntityWorkflowView.Callback.class))).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setCancelButtonVisible(Matchers.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonEnabled(Matchers.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonVisible(Matchers.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonText(Matchers.anyString())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.showNotification(Matchers.anyString())).thenReturn((Object)this.view);
        Mockito.when((Object)this.groupsManagerService.get(Matchers.anyString())).thenReturn((Object)this.group);
        this.authorizationServiceCaller = new CallerMock((Object)this.authorizationService);
        this.tested = (GroupEditorWorkflow)Mockito.spy((Object)new GroupEditorWorkflow(this.userSystemManager, this.authorizationServiceCaller, this.permissionManager, this.errorEvent, this.confirmBox, this.loadingBox, (Event)this.workbenchNotification, this.saveGroupEvent, this.deleteGroupEvent, this.groupEditor, this.groupEditorDriver, this.view));
    }

    @Test
    public void testClear() {
        this.tested.group = this.group;
        this.tested.clear();
        Assert.assertNull((Object)this.tested.group);
        ((GroupEditor)Mockito.verify((Object)this.groupEditor, (VerificationMode)Mockito.times((int)1))).clear();
        ((GroupEditor)Mockito.verify((Object)this.groupEditor, (VerificationMode)Mockito.times((int)0))).show((Group)Matchers.any(Group.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearNotifications();
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCancelButtonVisible(Matchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCallback((EntityWorkflowView.Callback)Matchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonText(Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Matchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonVisible(Matchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonEnabled(Matchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showNotification(Matchers.anyString());
    }

    @Test
    public void testShow() {
        String name = "group1";
        this.tested.show("group1");
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCancelButtonVisible(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCallback((EntityWorkflowView.Callback)Matchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonText(Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setWidget((IsWidget)Matchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonVisible(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonEnabled(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showNotification(Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearNotifications();
        ((GroupEditorDriver)Mockito.verify((Object)this.groupEditorDriver, (VerificationMode)Mockito.times((int)1))).edit(this.group, (org.uberfire.ext.security.management.client.editor.group.GroupEditor)this.groupEditor);
        ((GroupEditor)Mockito.verify((Object)this.groupEditor, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testOnDeleteGroupEvent() {
        OnDeleteEvent onDeleteEvent = (OnDeleteEvent)Mockito.mock(OnDeleteEvent.class);
        Mockito.when((Object)onDeleteEvent.getContext()).thenReturn((Object)this.groupEditor);
        ((ConfirmBox)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                Command callback = (Command)invocationOnMock.getArguments()[2];
                callback.execute();
                return null;
            }
        }).when((Object)this.confirmBox)).show(Matchers.anyString(), Matchers.anyString(), (Command)Matchers.any(), (Command)Matchers.any());
        this.tested.group = this.group;
        this.tested.onDeleteGroupEvent(onDeleteEvent);
        ((ConfirmBox)Mockito.verify((Object)this.confirmBox, (VerificationMode)Mockito.times((int)1))).show(Matchers.anyString(), Matchers.anyString(), (Command)Matchers.any(), (Command)Matchers.any());
        ((EventSourceMock)Mockito.verify(this.deleteGroupEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(DeleteGroupEvent.class));
        ((EventSourceMock)Mockito.verify((Object)this.workbenchNotification, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(NotificationEvent.class));
    }

    @Test
    public void testShowError() {
        Throwable error = (Throwable)Mockito.mock(Throwable.class);
        Mockito.when((Object)error.getMessage()).thenReturn((Object)"error1");
        this.tested.showError(error);
        ((EventSourceMock)Mockito.verify(this.errorEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(OnErrorEvent.class));
    }

    @Test
    public void testHomePerspectiveGranted() {
        this.permissionCollection.add(new Permission[]{this.permissionManager.createPermission((Resource)this.homePerspective, PerspectiveAction.READ, true)});
        this.tested.edit();
        ((GroupEditorWorkflow)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.never())).showNotification(Matchers.anyString());
    }

    @Test
    public void testHomePerspectiveDenied() {
        this.permissionCollection.add(new Permission[]{this.permissionManager.createPermission((Resource)this.homePerspective, PerspectiveAction.READ, false)});
        this.tested.edit();
        ((GroupEditorWorkflow)Mockito.verify((Object)this.tested)).showNotification(Matchers.anyString());
    }

    private void assertNoViewCalls() {
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCancelButtonVisible(Matchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCallback((EntityWorkflowView.Callback)Matchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonText(Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Matchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonVisible(Matchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonEnabled(Matchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showNotification(Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearNotifications();
    }
}

