/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user.workflow;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.editor.user.UserEditorDriver;
import org.uberfire.ext.security.management.client.widgets.management.ChangePassword;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.workflow.BaseUserEditorWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.editor.workflow.EntityWorkflowView;
import org.uberfire.ext.security.management.client.widgets.management.events.CreateUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnChangePasswordEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnDeleteEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnEditEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnRemoveUserGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnRemoveUserRoleEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnUpdateUserGroupsEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnUpdateUserRolesEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveRoleEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.UpdateUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class UserEditorWorkflow
extends BaseUserEditorWorkflow {
    @Inject
    public UserEditorWorkflow(ClientUserSystemManager userSystemManager, Event<OnErrorEvent> errorEvent, Event<NotificationEvent> workbenchNotification, Event<DeleteUserEvent> deleteUserEvent, Event<SaveUserEvent> saveUserEvent, ConfirmBox confirmBox, UserEditor userEditor, UserEditorDriver userEditorDriver, ChangePassword changePassword, LoadingBox loadingBox, EntityWorkflowView view) {
        super(userSystemManager, errorEvent, workbenchNotification, deleteUserEvent, saveUserEvent, confirmBox, userEditor, userEditorDriver, changePassword, loadingBox, view);
    }

    @PostConstruct
    public void init() {
    }

    public void show(String userId) {
        this.doShow(userId);
    }

    void onEditUserEvent(@Observes OnEditEvent onEditEvent) {
        if (this.checkEventContext(onEditEvent, this.userEditor)) {
            this.edit();
        }
    }

    void onDeleteUserEvent(@Observes OnDeleteEvent onDeleteEvent) {
        if (this.checkEventContext(onDeleteEvent, this.userEditor)) {
            this.doDelete();
        }
    }

    void onChangeUserPasswordEvent(@Observes OnChangePasswordEvent onChangePasswordEvent) {
        if (this.checkEventContext(onChangePasswordEvent, this.userEditor)) {
            this.doChangePassword();
        }
    }

    void onAttributeCreated(@Observes CreateUserAttributeEvent createUserAttributeEvent) {
        if (this.checkEventContext(createUserAttributeEvent, this.getUserEditor().attributesEditor())) {
            this.setDirty(true);
        }
    }

    void onAttributeDeleted(@Observes DeleteUserAttributeEvent deleteUserAttributeEvent) {
        if (this.checkEventContext(deleteUserAttributeEvent, this.getUserEditor().attributesEditor())) {
            this.setDirty(true);
        }
    }

    void onAttributeUpdated(@Observes UpdateUserAttributeEvent updateUserAttributeEvent) {
        if (this.checkEventContext(updateUserAttributeEvent, this.getUserEditor().attributesEditor())) {
            this.setDirty(true);
        }
    }

    void onOnRemoveUserGroupEvent(@Observes OnRemoveUserGroupEvent onRemoveUserGroupEvent) {
        if (this.checkEventContext(onRemoveUserGroupEvent, this.getUserEditor().groupsExplorer())) {
            this.setDirty(true);
        }
    }

    void onOnUserGroupsUpdatedEvent(@Observes OnUpdateUserGroupsEvent onUpdateUserGroupsEvent) {
        if (this.checkEventContext(onUpdateUserGroupsEvent, this.getUserEditor().groupsEditor())) {
            this.setDirty(true);
            this.refreshPermissions(true);
        }
    }

    void onOnRemoveUserRoleEvent(@Observes OnRemoveUserRoleEvent onRemoveUserRoleEvent) {
        if (this.checkEventContext(onRemoveUserRoleEvent, this.getUserEditor().rolesExplorer())) {
            this.setDirty(true);
            this.refreshPermissions(true);
        }
    }

    void onOnUserRolesUpdatedEvent(@Observes OnUpdateUserRolesEvent onUpdateUserRolesEvent) {
        if (this.checkEventContext(onUpdateUserRolesEvent, this.getUserEditor().rolesEditor())) {
            this.setDirty(true);
            this.refreshPermissions(true);
        }
    }

    void onRoleSavedEvent(@Observes SaveRoleEvent event) {
        this.refreshPermissions(false);
    }

    void onGroupSavedEvent(@Observes SaveGroupEvent event) {
        this.refreshPermissions(false);
    }

    void refreshPermissions(boolean flush) {
        if (flush) {
            this.userEditorDriver.flush();
            User user = this.userEditorDriver.getValue();
            this.userEditor.getACLViewer().show(user);
        } else {
            this.userEditor.getACLViewer().show(this.user);
        }
    }
}

