/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.explorer;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.Role;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.ReadRoleEvent;
import org.uberfire.ext.security.management.client.widgets.management.explorer.AbstractEntityExplorer;
import org.uberfire.ext.security.management.client.widgets.management.explorer.EntitiesExplorerView;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesList;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.ext.security.management.impl.SearchRequestImpl;

@Dependent
public class RolesExplorer
extends AbstractEntityExplorer<Role> {
    private Event<ReadRoleEvent> readRoleEvent;

    @Inject
    public RolesExplorer(ClientUserSystemManager userSystemManager, Event<OnErrorEvent> errorEvent, LoadingBox loadingBox, EntitiesList<Role> entitiesList, EntitiesExplorerView view, Event<ReadRoleEvent> readRoleEvent) {
        super(userSystemManager, errorEvent, loadingBox, entitiesList, view);
        this.readRoleEvent = readRoleEvent;
    }

    @Override
    protected String getEmptyText() {
        return UsersManagementWidgetsConstants.INSTANCE.noRoles();
    }

    @Override
    protected String getEntityType() {
        return UsersManagementWidgetsConstants.INSTANCE.roles();
    }

    @Override
    protected String getTitle() {
        return UsersManagementWidgetsConstants.INSTANCE.role();
    }

    @Override
    protected String getEntityId(Role entity) {
        return entity.getName();
    }

    @Override
    protected String getEntityName(Role entity) {
        return entity.getName();
    }

    @Override
    protected boolean canSearch() {
        return true;
    }

    @Override
    protected boolean canCreate() {
        return false;
    }

    @Override
    protected boolean canRead() {
        return true;
    }

    @Override
    protected void fireReadEvent(String identifier) {
        this.readRoleEvent.fire((Object)new ReadRoleEvent(identifier));
    }

    @Override
    protected void showCreate() {
        throw new RuntimeException("Role creation not supported");
    }

    @Override
    protected void showSearch() {
        this.showLoadingView();
        this.userSystemManager.roles((RemoteCallback)new RemoteCallback<AbstractEntityManager.SearchResponse<Role>>(){

            public void callback(AbstractEntityManager.SearchResponse<Role> response) {
                if (response != null) {
                    EntitiesList.Callback callback = RolesExplorer.this.createCallback();
                    RolesExplorer.this.entitiesList.show(response, callback);
                    RolesExplorer.this.view.show(RolesExplorer.this.context, RolesExplorer.this.viewCallback);
                    RolesExplorer.this.hideLoadingView();
                }
            }
        }, this.errorCallback).search((AbstractEntityManager.SearchRequest)new SearchRequestImpl(this.searchPattern, this.currentPage, this.pageSize, this.context != null ? this.context.getConstrainedEntities() : null));
    }
}

