/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management;

import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.client.widgets.management.AbstractSecurityManagementTest;
import org.uberfire.ext.security.management.client.widgets.management.CreateEntity;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class CreateEntityTest
extends AbstractSecurityManagementTest {
    @Mock
    CreateEntity.View view;
    private CreateEntity presenter;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.presenter = new CreateEntity(this.userSystemManager, this.view);
        junit.framework.Assert.assertEquals((Object)this.view.asWidget(), (Object)this.presenter.asWidget());
    }

    @Test
    public void testClear() throws Exception {
        this.presenter.clear();
        ((CreateEntity.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((CreateEntity.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setValidationState(ValidationState.NONE);
        ((CreateEntity.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).show(Mockito.anyString(), Mockito.anyString());
        Assert.assertNull((Object)this.presenter.identifier);
    }

    @Test
    public void testSetErrorState() throws Exception {
        this.presenter.setErrorState();
        ((CreateEntity.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setValidationState(ValidationState.ERROR);
        ((CreateEntity.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
        ((CreateEntity.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).show(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void testShow() throws Exception {
        String legend = "legend";
        String ph = "placeHolder";
        this.presenter.show("legend", "placeHolder");
        ((CreateEntity.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((CreateEntity.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setValidationState(ValidationState.NONE);
        ((CreateEntity.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).show("legend", "placeHolder");
        Assert.assertNull((Object)this.presenter.identifier);
    }

    @Test
    public void testGetEntityIdentifierValid() throws Exception {
        this.presenter.identifier = "id1";
        String id = this.presenter.getEntityIdentifier();
        ((CreateEntity.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setValidationState(ValidationState.NONE);
        ((CreateEntity.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
        ((CreateEntity.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).show(Mockito.anyString(), Mockito.anyString());
        Assert.assertEquals((Object)"id1", (Object)id);
    }

    @Test
    public void testGetEntityIdentifierInvalid() throws Exception {
        this.presenter.identifier = null;
        String id = this.presenter.getEntityIdentifier();
        ((CreateEntity.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setValidationState(ValidationState.ERROR);
        ((CreateEntity.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
        ((CreateEntity.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).show(Mockito.anyString(), Mockito.anyString());
        Assert.assertEquals(null, (Object)id);
    }
}

