/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user.workflow;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.HashSet;
import javax.enterprise.event.Event;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.service.UserManagerService;
import org.uberfire.ext.security.management.client.editor.user.UserEditorDriver;
import org.uberfire.ext.security.management.client.widgets.management.AbstractSecurityManagementTest;
import org.uberfire.ext.security.management.client.widgets.management.ChangePassword;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedGroupsExplorer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedRolesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.workflow.BaseUserEditorWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.editor.workflow.EntityWorkflowView;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveUserEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class BaseUserEditorWorkflowTest
extends AbstractSecurityManagementTest {
    @Mock
    EventSourceMock<OnErrorEvent> errorEvent;
    @Mock
    EventSourceMock<DeleteUserEvent> deleteUserEvent;
    @Mock
    EventSourceMock<SaveUserEvent> saveUserEvent;
    @Mock
    ConfirmBox confirmBox;
    @Mock
    UserEditor userEditor;
    @Mock
    UserEditorDriver userEditorDriver;
    @Mock
    UserAssignedGroupsExplorer userAssignedGroupsExplorer;
    @Mock
    UserAssignedRolesExplorer userAssignedRolesExplorer;
    @Mock
    ChangePassword changePassword;
    @Mock
    LoadingBox loadingBox;
    @Mock
    EntityWorkflowView view;
    @Mock
    User user;
    private BaseUserEditorWorkflow tested;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.view.setWidget((IsWidget)ArgumentMatchers.any())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.clearNotifications()).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setCallback((EntityWorkflowView.Callback)ArgumentMatchers.any())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setCancelButtonVisible(ArgumentMatchers.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonEnabled(ArgumentMatchers.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonVisible(ArgumentMatchers.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonText((String)ArgumentMatchers.any())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.showNotification((String)ArgumentMatchers.any())).thenReturn((Object)this.view);
        HashSet<Group> groups = new HashSet<Group>();
        Group group1 = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)group1.getName()).thenReturn((Object)"group1");
        groups.add(group1);
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"user1");
        Mockito.when((Object)this.user.getGroups()).thenReturn(groups);
        Mockito.when((Object)this.userEditor.groupsExplorer()).thenReturn((Object)this.userAssignedGroupsExplorer);
        Mockito.when((Object)this.userAssignedGroupsExplorer.getValue()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.userEditor.rolesExplorer()).thenReturn((Object)this.userAssignedRolesExplorer);
        Mockito.when((Object)this.userAssignedRolesExplorer.getValue()).thenReturn(Collections.emptySet());
        ((UserManagerService)Mockito.doAnswer((Answer)new Answer<User>(){

            public User answer(InvocationOnMock invocationOnMock) throws Throwable {
                return BaseUserEditorWorkflowTest.this.user;
            }
        }).when((Object)this.userManagerService)).get(ArgumentMatchers.anyString());
        ((UserManagerService)Mockito.doAnswer((Answer)new Answer<User>(){

            public User answer(InvocationOnMock invocationOnMock) throws Throwable {
                return BaseUserEditorWorkflowTest.this.user;
            }
        }).when((Object)this.userManagerService)).update((Object)((User)ArgumentMatchers.any(User.class)));
        this.tested = new BaseUserEditorWorkflow(this.userSystemManager, (Event)this.errorEvent, (Event)this.workbenchNotification, (Event)this.deleteUserEvent, (Event)this.saveUserEvent, this.confirmBox, this.userEditor, this.userEditorDriver, this.changePassword, this.loadingBox, this.view){};
    }

    @Test
    public void testDoShow() {
        String userId = "user1";
        this.tested.isDirty = false;
        this.tested.doShow("user1");
        ((UserManagerService)Mockito.verify((Object)this.userManagerService, (VerificationMode)Mockito.times((int)1))).get(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCancelButtonVisible(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCallback((EntityWorkflowView.Callback)ArgumentMatchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonText(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setWidget((IsWidget)ArgumentMatchers.any());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonVisible(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setSaveButtonEnabled(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearNotifications();
        ((UserEditor)Mockito.verify((Object)this.userEditor, (VerificationMode)Mockito.times((int)1))).clear();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
        ((UserEditorDriver)Mockito.verify((Object)this.userEditorDriver, (VerificationMode)Mockito.times((int)1))).show(this.user, (org.uberfire.ext.security.management.client.editor.user.UserEditor)this.userEditor);
        ((UserEditorDriver)Mockito.verify((Object)this.userEditorDriver, (VerificationMode)Mockito.times((int)0))).edit(this.user, (org.uberfire.ext.security.management.client.editor.user.UserEditor)this.userEditor);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCancelButtonVisible(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonVisible(false);
    }

    @Test
    public void testCheckDirtyFalse() {
        Command command = (Command)Mockito.mock(Command.class);
        this.tested.isDirty = false;
        this.tested.checkDirty(command);
        ((Command)Mockito.verify((Object)command, (VerificationMode)Mockito.times((int)1))).execute();
        this.assertNoViewCalls();
    }

    @Test
    public void testCheckDirtyTrue() {
        Command command = (Command)Mockito.mock(Command.class);
        this.tested.isDirty = true;
        this.tested.checkDirty(command);
        ((ConfirmBox)Mockito.verify((Object)this.confirmBox, (VerificationMode)Mockito.times((int)1))).show(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(), (Command)ArgumentMatchers.any());
        ((Command)Mockito.verify((Object)command, (VerificationMode)Mockito.times((int)0))).execute();
        this.assertNoViewCalls();
    }

    @Test
    public void testSetDirtyTrue() {
        this.tested.user = this.user;
        this.tested.setDirty(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCancelButtonVisible(ArgumentMatchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCallback((EntityWorkflowView.Callback)ArgumentMatchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonText(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonVisible(ArgumentMatchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonEnabled(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).showNotification(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearNotifications();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)0))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)0))).hide();
    }

    @Test
    public void testSetDirtyFalse() {
        this.tested.setDirty(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCancelButtonVisible(ArgumentMatchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCallback((EntityWorkflowView.Callback)ArgumentMatchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonText(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonVisible(ArgumentMatchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonEnabled(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showNotification(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearNotifications();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)0))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)0))).hide();
    }

    @Test
    public void testNotifyEmptyAssignments() {
        Mockito.when((Object)this.userAssignedGroupsExplorer.getValue()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.userAssignedRolesExplorer.getValue()).thenReturn(Collections.emptySet());
        this.tested.user = this.user;
        this.tested.setDirty(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCancelButtonVisible(ArgumentMatchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCallback((EntityWorkflowView.Callback)ArgumentMatchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonText(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonVisible(ArgumentMatchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonEnabled(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showNotification(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearNotifications();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)0))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)0))).hide();
    }

    @Test
    public void testNoNeedToNotifyAssignmentsFound() {
        Mockito.when((Object)this.userAssignedGroupsExplorer.getValue()).thenReturn(Collections.singleton(new GroupImpl("g1")));
        Mockito.when((Object)this.userAssignedRolesExplorer.getValue()).thenReturn(Collections.emptySet());
        this.tested.user = this.user;
        this.tested.setDirty(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCancelButtonVisible(ArgumentMatchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCallback((EntityWorkflowView.Callback)ArgumentMatchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonText(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonVisible(ArgumentMatchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonEnabled(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showNotification(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearNotifications();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)0))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)0))).hide();
    }

    @Test
    public void testEdit() {
        this.tested.user = this.user;
        this.tested.edit();
        ((UserEditorDriver)Mockito.verify((Object)this.userEditorDriver, (VerificationMode)Mockito.times((int)1))).edit(this.user, (org.uberfire.ext.security.management.client.editor.user.UserEditor)this.userEditor);
        ((UserEditorDriver)Mockito.verify((Object)this.userEditorDriver, (VerificationMode)Mockito.times((int)0))).show(this.user, (org.uberfire.ext.security.management.client.editor.user.UserEditor)this.userEditor);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCancelButtonVisible(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCallback((EntityWorkflowView.Callback)ArgumentMatchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonText(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonVisible(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setSaveButtonEnabled(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showNotification(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearNotifications();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)0))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)0))).hide();
    }

    @Test
    public void testDoSaveWithoutGroupAssignment() {
        Mockito.when((Object)this.userEditorDriver.flush()).thenReturn((Object)true);
        Mockito.when((Object)this.userEditorDriver.getValue()).thenReturn((Object)this.user);
        Mockito.when((Object)this.userEditor.getValue()).thenReturn((Object)this.user);
        Mockito.when((Object)this.userEditor.canAssignGroups()).thenReturn((Object)false);
        Mockito.when((Object)this.userEditor.canAssignRoles()).thenReturn((Object)false);
        this.tested.user = this.user;
        this.tested.doSave();
        ((UserManagerService)Mockito.verify((Object)this.userManagerService, (VerificationMode)Mockito.times((int)1))).update((Object)((User)ArgumentMatchers.any(User.class)));
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)2))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)2))).hide();
    }

    @Test
    public void testDoShowChangePassword() {
        this.tested.user = this.user;
        this.tested.doChangePassword();
        ((ChangePassword)Mockito.verify((Object)this.changePassword, (VerificationMode)Mockito.times((int)1))).show(ArgumentMatchers.anyString(), (ChangePassword.ChangePasswordCallback)ArgumentMatchers.any());
        this.assertNoViewCalls();
    }

    @Test
    public void testDoDelete() {
        this.tested.user = this.user;
        ((ConfirmBox)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                Command callback = (Command)invocationOnMock.getArguments()[2];
                callback.execute();
                return null;
            }
        }).when((Object)this.confirmBox)).show(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(), (Command)ArgumentMatchers.any());
        this.tested.doDelete();
        ((ConfirmBox)Mockito.verify((Object)this.confirmBox, (VerificationMode)Mockito.times((int)1))).show(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(), (Command)ArgumentMatchers.any());
        ((UserManagerService)Mockito.verify((Object)this.userManagerService, (VerificationMode)Mockito.times((int)1))).delete(new String[]{ArgumentMatchers.anyString()});
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
        ((EventSourceMock)Mockito.verify(this.deleteUserEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((DeleteUserEvent)ArgumentMatchers.any(DeleteUserEvent.class)));
        ((EventSourceMock)Mockito.verify((Object)this.workbenchNotification, (VerificationMode)Mockito.times((int)1))).fire((Object)((NotificationEvent)ArgumentMatchers.any(NotificationEvent.class)));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCancelButtonVisible(ArgumentMatchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCallback((EntityWorkflowView.Callback)ArgumentMatchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonText(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonVisible(ArgumentMatchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonEnabled(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showNotification(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearNotifications();
    }

    private void assertNoViewCalls() {
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCancelButtonVisible(ArgumentMatchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCallback((EntityWorkflowView.Callback)ArgumentMatchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonText(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonVisible(ArgumentMatchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonEnabled(ArgumentMatchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showNotification(ArgumentMatchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearNotifications();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)0))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)0))).hide();
    }
}

