/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bayesian.network.client.factory;

import com.emitrom.lienzo.client.core.shape.Rectangle;
import com.emitrom.lienzo.client.core.shape.Text;
import com.emitrom.lienzo.shared.core.types.Color;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.uberfire.ext.wires.bayesian.network.client.factory.BaseFactory;
import org.uberfire.ext.wires.bayesian.network.client.shapes.EditableBayesianProbability;
import org.uberfire.ext.wires.bayesian.network.client.utils.BayesianUtils;
import org.uberfire.ext.wires.bayesian.network.parser.client.model.BayesVariable;

public class ProbabilityFactory
extends BaseFactory {
    private int positionXPorc;

    public EditableBayesianProbability init(BayesVariable node) {
        int positionX = 350;
        int positionY = 80;
        int width = 65;
        int height = 100;
        EditableBayesianProbability bayesianProbabilityGrid = new EditableBayesianProbability(1200.0, 300.0, 0.0, 0.0);
        this.drawNodeSelected(node, positionX, positionY, width, height, bayesianProbabilityGrid);
        int positionXOptions = positionX + width;
        int heightOptions = height / node.getOutcomes().size();
        int widthOptions = width - 10;
        this.drawPorcentualOptions(node, positionXOptions, positionY, widthOptions, heightOptions, bayesianProbabilityGrid);
        int positionXValues = positionXOptions + widthOptions;
        int positionYValues = positionY;
        int heightPorcentualValue = height / node.getOutcomes().size();
        int widthPorcentualValue = widthOptions - 5;
        this.drawPorcentualValues(node, positionXValues, positionYValues, widthPorcentualValue, heightPorcentualValue, positionYValues, bayesianProbabilityGrid);
        int widthIncoming = width + widthOptions;
        int heightIncoming = 25;
        int positionYIncoming = positionY - heightIncoming;
        this.drawIncomingNodes(node, positionX, positionYIncoming, widthIncoming, heightIncoming, widthPorcentualValue, widthOptions, heightOptions, bayesianProbabilityGrid);
        bayesianProbabilityGrid.buildGrid();
        return bayesianProbabilityGrid;
    }

    private void drawNodeSelected(BayesVariable node, int positionX, int positionY, int width, int height, EditableBayesianProbability bayesianProbabilityGrid) {
        HashMap parentNode = Maps.newHashMap();
        Rectangle nodeSelected = super.drawComponent(Color.rgbToBrowserHexColor((int)183, (int)198, (int)201), positionX, positionY, width, height, Color.rgbToBrowserHexColor((int)183, (int)198, (int)201), 2.0);
        Text label = super.drawText(node.getName(), BayesianUtils.FONT_SIZE_TEXT_LABEL, positionX + 7, positionY + 54);
        parentNode.put(label, nodeSelected);
        bayesianProbabilityGrid.setParentNode(parentNode);
    }

    private void drawPorcentualOptions(BayesVariable node, int positionXOptions, int positionYOptions, int widthOptions, int heightOptions, EditableBayesianProbability bayesianProbabilityGrid) {
        int _positionYOptions = positionYOptions;
        HashMap porcentualOptions = Maps.newHashMap();
        for (String outcome : node.getOutcomes()) {
            Rectangle porcentualOption = super.drawComponent(Color.rgbToBrowserHexColor((int)200, (int)216, (int)203), positionXOptions, _positionYOptions, widthOptions, heightOptions, Color.rgbToBrowserHexColor((int)200, (int)216, (int)203), 0.0);
            Text porcentualLabel = super.drawText(outcome, BayesianUtils.FONT_SIZE_TEXT_LABEL, positionXOptions + 7, _positionYOptions + 20 / node.getOutcomes().size() + 19);
            _positionYOptions += heightOptions;
            porcentualOptions.put(porcentualLabel, porcentualOption);
        }
        bayesianProbabilityGrid.setPorcentualOptions(porcentualOptions);
    }

    private void drawPorcentualValues(BayesVariable node, int positionXValues, int positionYValues, int widthPorcentualValue, int heightPorcentualValue, int positionY, EditableBayesianProbability bayesianProbabilityGrid) {
        int _positionXValues = positionXValues;
        int _positionYValues = positionYValues;
        double[][] probabilities = node.getGiven() != null && node.getGiven().size() > 1 ? BayesianUtils.orderListValues(node, node.getOutcomes().size()) : node.getProbabilities();
        HashMap porcentualValues = Maps.newHashMap();
        for (int i = 0; i < probabilities.length / node.getOutcomes().size(); ++i) {
            for (int j = 0; j < node.getOutcomes().size(); ++j) {
                Rectangle porcentual = super.drawComponent(Color.rgbToBrowserHexColor((int)255, (int)255, (int)255), _positionXValues, _positionYValues, widthPorcentualValue, heightPorcentualValue, Color.rgbToBrowserHexColor((int)183, (int)198, (int)201), 0.0);
                Text porcentualLabel = super.drawText(String.valueOf(probabilities[i][j]), BayesianUtils.FONT_SIZE_TEXT_LABEL, _positionXValues + 7, _positionYValues + 20 / node.getOutcomes().size() + 19);
                _positionYValues += heightPorcentualValue;
                porcentualValues.put(porcentualLabel, porcentual);
            }
            _positionYValues = positionY;
            _positionXValues += widthPorcentualValue;
        }
        bayesianProbabilityGrid.setPorcentualValues(porcentualValues);
    }

    private void drawIncomingNodes(BayesVariable node, int positionXIncoming, int positionYIncoming, int widthIncoming, int heightIncoming, int widthPorcentualValue, int widthOptions, int heightOptions, EditableBayesianProbability bayesianProbabilityGrid) {
        int _positionYIncoming = positionYIncoming;
        String color = Color.rgbToBrowserHexColor((int)182, (int)199, (int)191);
        int incomingPosition = 0;
        HashMap porcentualIncoming = Maps.newHashMap();
        int acountIterations = 0;
        int widthNode = 0;
        if (node.getIncomingNodes() != null && !node.getIncomingNodes().isEmpty()) {
            for (BayesVariable nod : node.getIncomingNodes()) {
                HashMap incomingNodes = Maps.newHashMap();
                HashMap porcentualValues = Maps.newHashMap();
                Rectangle incomingNode = super.drawComponent(color, positionXIncoming, _positionYIncoming, widthIncoming, heightIncoming, color, 0.0);
                Text incomingLabel = super.drawText(nod.getName(), BayesianUtils.FONT_SIZE_TEXT_LABEL, positionXIncoming + 10, _positionYIncoming + 19);
                incomingNodes.put(incomingLabel, incomingNode);
                this.positionXPorc = positionXIncoming + widthIncoming;
                if (incomingPosition == 0) {
                    for (int i = 0; i < node.getProbabilities().length / node.getOutcomes().size() / nod.getOutcomes().size(); ++i) {
                        this.drawPorcentualIncoming(nod, _positionYIncoming, heightIncoming, widthPorcentualValue, heightOptions, bayesianProbabilityGrid, porcentualValues);
                        ++acountIterations;
                    }
                } else {
                    int sizeOutcomesPrevIncomingNode = ((BayesVariable)node.getIncomingNodes().get(incomingPosition - 1)).getOutcomes().size();
                    int iter = acountIterations / nod.getOutcomes().size();
                    acountIterations = 0;
                    widthNode = widthNode == 0 ? widthPorcentualValue * sizeOutcomesPrevIncomingNode : widthNode * sizeOutcomesPrevIncomingNode;
                    for (int i = 0; i < iter; ++i) {
                        this.drawPorcentualIncoming(nod, _positionYIncoming, heightIncoming, widthNode, heightOptions, bayesianProbabilityGrid, porcentualValues);
                        ++acountIterations;
                    }
                }
                ++incomingPosition;
                _positionYIncoming -= heightIncoming;
                color = Color.rgbToBrowserHexColor((int)210, (int)204, (int)229);
                porcentualIncoming.put(incomingNodes, porcentualValues);
            }
            bayesianProbabilityGrid.setIncomingNodes(porcentualIncoming);
        }
    }

    private void drawPorcentualIncoming(BayesVariable nod, int positionYIncoming, int heightIncoming, int widthPorcentualValue, int heightOptions, EditableBayesianProbability bayesianProbabilityGrid, Map<Text, Rectangle> porcentualValues) {
        for (String out : nod.getOutcomes()) {
            Rectangle porcentual = super.drawComponent(Color.rgbToBrowserHexColor((int)200, (int)216, (int)203), this.positionXPorc, positionYIncoming, widthPorcentualValue, heightIncoming, Color.rgbToBrowserHexColor((int)200, (int)216, (int)203), 0.0);
            Text porcentualLabel = super.drawText(out, BayesianUtils.FONT_SIZE_TEXT_LABEL, this.positionXPorc + 7, positionYIncoming + 19);
            this.positionXPorc += widthPorcentualValue;
            porcentualValues.put(porcentualLabel, porcentual);
        }
    }
}

