/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bayesian.network.client.templates;

import com.emitrom.lienzo.client.core.event.NodeMouseClickEvent;
import com.emitrom.lienzo.client.core.event.NodeMouseClickHandler;
import com.emitrom.lienzo.client.core.shape.IPrimitive;
import com.emitrom.lienzo.client.core.shape.Layer;
import com.emitrom.lienzo.client.widget.LienzoPanel;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.uberfire.ext.wires.bayesian.network.client.events.BayesianTemplateSelectedEvent;
import org.uberfire.ext.wires.bayesian.network.client.templates.StencilTemplateBuilder;
import org.uberfire.ext.wires.bayesian.network.client.templates.TemplateShape;

@Dependent
public class TemplatesGroup
extends Composite {
    private Layer layer;
    private LienzoPanel panel;
    private final ImmutableSet<String> templateNames = ImmutableSet.of((Object)"dog-problem.xml03", (Object)"cancer.xml03", (Object)"asia.xml03", (Object)"car-starts.xml03", (Object)"elimbel2.xml03", (Object)"john-mary-call.xml03", (Object[])new String[0]);
    @Inject
    private Event<BayesianTemplateSelectedEvent> bayesianEvent;
    @Inject
    private StencilTemplateBuilder stencilBuilder;

    @PostConstruct
    public void init() {
        this.panel = new LienzoPanel(405, 300);
        this.layer = new Layer();
        this.panel.getScene().add(this.layer);
        this.initWidget((Widget)this.panel);
        this.drawTemplates();
    }

    private void drawTemplates() {
        ArrayList<TemplateShape> shapes = new ArrayList<TemplateShape>();
        for (String templateName : this.templateNames) {
            shapes.add(this.stencilBuilder.build(templateName, this.getTemplateClickHandler(templateName)));
        }
        int shapeCount = 0;
        for (TemplateShape shape : shapes) {
            shape.setX(0.0);
            shape.setY(shapeCount * 35);
            this.layer.add((IPrimitive)shape);
            ++shapeCount;
        }
        this.layer.draw();
    }

    private NodeMouseClickHandler getTemplateClickHandler(final String templateName) {
        return new NodeMouseClickHandler(){

            public void onNodeMouseClick(NodeMouseClickEvent event) {
                TemplatesGroup.this.bayesianEvent.fire((Object)new BayesianTemplateSelectedEvent(templateName));
            }
        };
    }
}

