/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bayesian.network.client.utils;

import com.emitrom.lienzo.shared.core.types.Color;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.uberfire.ext.wires.bayesian.network.parser.client.model.BayesVariable;

public class BayesianUtils {
    public static int WIDTH_NODE = 135;
    public static int HEIGHT_NODE = 83;
    public static int HEIGHT_HEADER = 25;
    public static int FONT_SIZE_HEADER_NODE = 10;
    public static int LABEL_POSITION_X_DEFAULT = 8;
    public static int LABEL_POSITION_Y_DEFAULT = 15;
    public static final String DEFAULT_PORCENTUAL_FILL_COLOR = "#F2F2F2";
    public static final String DEFAULT_PORCENTUAL_BORDER_COLOR = "#999999";
    public static final int HEIGHT_PORCENTUAL_BAR = 8;
    public static final int FONT_SIZE_PORCENTUAL_BAR = 9;
    public static final int WIDTH_PORCENTUAL_BAR = WIDTH_NODE - 75;
    public static final int POSITION_X_PORCENTUAL_BAR = 64;
    public static int POSITION_X_BASE = 0;
    public static int POSITION_Y_BASE = 25;
    public static int SUBSTRATE_HEIGHT = 34;
    public static String SUBSTRATE_COLOR = "#666";
    public static String FONT_FAMILY_PROGRESS_BAR = "Lucida Console";
    public static int FONT_SIZE_PROGRESS_BAR = 12;
    public static String XML3_RESOURCE_PATH = "xml03/";
    public static String BG_COLOR_CONTAINER = Color.rgbToBrowserHexColor((int)236, (int)236, (int)236);
    public static String BORDER_CONTAINER = Color.rgbToBrowserHexColor((int)236, (int)236, (int)236);
    public static int POSITION_X_CONTAINER = 0;
    public static int POSITION_Y_CONTAINER = -4;
    public static int WIDTH_CONTAINER = 250;
    public static int HEIGHT_CONTAINER = 23;
    public static int FONT_SIZE_TEXT_LABEL = 9;
    public static String COLOR_TEXT_LABEL = Color.rgbToBrowserHexColor((int)141, (int)147, (int)144);
    public static int POSITION_X_TEXT_LABEL = 40;
    public static int POSITION_Y_TEXT_LABEL = 0;
    public static int WIDTH_TEXT_LABEL = 150;
    public static int HEIGHT_TEXT_LABEL = 18;
    private static ImmutableMap<Double, String[][]> nodeColors = ImmutableMap.builder().put((Object)0.1, (Object)new String[][]{{Color.rgbToBrowserHexColor((int)102, (int)183, (int)176), Color.rgbToBrowserHexColor((int)197, (int)216, (int)214)}}).put((Object)0.2, (Object)new String[][]{{Color.rgbToBrowserHexColor((int)179, (int)99, (int)150), Color.rgbToBrowserHexColor((int)213, (int)186, (int)216)}}).put((Object)0.3, (Object)new String[][]{{Color.rgbToBrowserHexColor((int)120, (int)101, (int)186), Color.rgbToBrowserHexColor((int)210, (int)204, (int)229)}}).put((Object)0.4, (Object)new String[][]{{Color.rgbToBrowserHexColor((int)169, (int)181, (int)99), Color.rgbToBrowserHexColor((int)221, (int)224, (int)205)}}).put((Object)0.5, (Object)new String[][]{{Color.rgbToBrowserHexColor((int)89, (int)177, (int)140), Color.rgbToBrowserHexColor((int)182, (int)199, (int)191)}}).put((Object)0.6, (Object)new String[][]{{Color.rgbToBrowserHexColor((int)186, (int)183, (int)102), Color.rgbToBrowserHexColor((int)222, (int)219, (int)202)}}).put((Object)0.7, (Object)new String[][]{{Color.rgbToBrowserHexColor((int)191, (int)102, (int)104), Color.rgbToBrowserHexColor((int)230, (int)210, (int)211)}}).put((Object)0.8, (Object)new String[][]{{Color.rgbToBrowserHexColor((int)108, (int)156, (int)218), Color.rgbToBrowserHexColor((int)187, (int)194, (int)204)}}).put((Object)0.9, (Object)new String[][]{{Color.rgbToBrowserHexColor((int)108, (int)156, (int)218), Color.rgbToBrowserHexColor((int)187, (int)194, (int)204)}}).put((Object)1.0, (Object)new String[][]{{Color.rgbToBrowserHexColor((int)108, (int)156, (int)218), Color.rgbToBrowserHexColor((int)187, (int)194, (int)204)}}).build();

    public static String[][] getNodeColors() {
        double rand = Math.random();
        String[][] colors = new String[2][2];
        for (Map.Entry entry : nodeColors.entrySet()) {
            if (!(rand < (Double)entry.getKey()) || !(rand > (Double)entry.getKey() - 0.1)) continue;
            colors[0][0] = ((String[][])entry.getValue())[0][1];
            colors[0][1] = ((String[][])entry.getValue())[0][0];
        }
        return colors;
    }

    public static double[][] orderListValues(BayesVariable node, int outcomesSize) {
        double[][] probabilities = node.getProbabilities();
        double[][] valuesSorted = new double[probabilities.length][probabilities.length];
        int middle = probabilities.length / outcomesSize;
        int sizeFirstIncoming = ((BayesVariable)node.getIncomingNodes().get(0)).getOutcomes().size();
        int secondPart = middle / sizeFirstIncoming;
        int k = 0;
        for (int i = 0; i < middle / 2; ++i) {
            for (int j = 0; j < outcomesSize; ++j) {
                BayesianUtils.orderValues(valuesSorted, secondPart, k, j, sizeFirstIncoming, probabilities);
            }
            k += sizeFirstIncoming;
        }
        return valuesSorted;
    }

    private static void orderValues(double[][] valuesSorted, int secondPart, int k, int j, int sizeFirstIncoming, double[][] probabilities) {
        for (int i = 0; i < sizeFirstIncoming; ++i) {
            valuesSorted[k + i][j] = probabilities[secondPart * i + i][j];
        }
    }
}

