/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bayesian.network.client.factory;

import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.shared.core.types.Color;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.ext.wires.bayesian.network.client.events.RenderBayesianNetworkEvent;
import org.uberfire.ext.wires.bayesian.network.client.factory.BaseFactory;
import org.uberfire.ext.wires.bayesian.network.client.shapes.EditableBayesianNode;
import org.uberfire.ext.wires.bayesian.network.client.utils.BayesianUtils;
import org.uberfire.ext.wires.bayesian.network.parser.client.model.BayesNetwork;
import org.uberfire.ext.wires.bayesian.network.parser.client.model.BayesVariable;
import org.uberfire.ext.wires.bayesian.network.parser.client.service.BayesianService;
import org.uberfire.ext.wires.core.client.progressbar.ProgressBar;

@ApplicationScoped
public class BayesianFactory
extends BaseFactory {
    @Inject
    private Caller<BayesianService> bayesianService;
    @Inject
    private Event<RenderBayesianNetworkEvent> readyEvent;
    private String[][] colors;
    private List<EditableBayesianNode> bayesianNodes = new ArrayList<EditableBayesianNode>();

    public void init(final String xml03File) {
        ((BayesianService)this.bayesianService.call((RemoteCallback)new RemoteCallback<BayesNetwork>(){

            public void callback(BayesNetwork response) {
                BayesianFactory.this.bayesianNodes.clear();
                for (BayesVariable bay : response.getNodos()) {
                    BayesianFactory.this.drawBayesianNode(bay);
                }
                BayesianFactory.this.readyEvent.fire((Object)new RenderBayesianNetworkEvent(BayesianFactory.this.bayesianNodes));
            }
        }, (ErrorCallback)new ErrorCallback<Object>(){

            public boolean error(Object message, Throwable throwable) {
                Window.alert((String)("Sorry.. the " + xml03File + " could not be read.."));
                ProgressBar.setInfinite((boolean)false);
                return false;
            }
        })).buildXml03(BayesianUtils.XML3_RESOURCE_PATH + xml03File);
    }

    private void drawBayesianNode(BayesVariable node) {
        this.colors = BayesianUtils.getNodeColors();
        double[][] position = node.getPosition();
        int positionX = (int)((long)BayesianUtils.POSITION_X_BASE + Math.round(position[0][0]));
        int positionY = (int)((long)BayesianUtils.POSITION_Y_BASE + Math.round(position[0][1]));
        String fillNodeColor = this.colors[0][0];
        EditableBayesianNode bayesianNode = new EditableBayesianNode(BayesianUtils.WIDTH_NODE, BayesianUtils.HEIGHT_NODE, positionX, positionY, fillNodeColor, node);
        this.setHeader(node, bayesianNode);
        this.setPorcentualBar(node, bayesianNode);
        bayesianNode.buildNode();
        this.bayesianNodes.add(bayesianNode);
    }

    private void setHeader(BayesVariable node, EditableBayesianNode bayesianNode) {
        bayesianNode.setHeader(new Rectangle(bayesianNode.getWidth(), (double)BayesianUtils.HEIGHT_HEADER));
        bayesianNode.getHeader().setFillColor(this.colors[0][1]);
        bayesianNode.getHeader().setX(bayesianNode.getHeader().getX());
        bayesianNode.setTextHeader(this.drawText(node.getName(), BayesianUtils.FONT_SIZE_HEADER_NODE, BayesianUtils.LABEL_POSITION_X_DEFAULT, BayesianUtils.LABEL_POSITION_Y_DEFAULT));
    }

    private void setPorcentualBar(BayesVariable node, EditableBayesianNode bayesianNode) {
        String fillColor = this.colors[0][1];
        int positionY = 18;
        positionY = node.getOutcomes().size() > 3 ? positionY - 10 : positionY;
        String borderColor = fillColor;
        ArrayList componentsProgressBar = Lists.newArrayList();
        HashMap porcentualsBar = Maps.newHashMap();
        for (int i = 0; i < node.getOutcomes().size(); ++i) {
            Text labelPorcentual = this.drawText((String)node.getOutcomes().get(i), 9, BayesianUtils.LABEL_POSITION_X_DEFAULT, (positionY += 14) + 7);
            componentsProgressBar.add(this.drawComponent(Color.rgbToBrowserHexColor((int)255, (int)255, (int)255), 64, positionY, BayesianUtils.WIDTH_PORCENTUAL_BAR, 8, borderColor, 3.0));
            int widthFill = this.calculatePorcentage(node.getProbabilities(), BayesianUtils.WIDTH_PORCENTUAL_BAR, i);
            componentsProgressBar.add(this.drawComponent(fillColor, 64, positionY, widthFill, 8, borderColor, 0.0));
            bayesianNode.getPorcentualsBar().put(labelPorcentual, componentsProgressBar);
            porcentualsBar.put(labelPorcentual, componentsProgressBar);
        }
        bayesianNode.setPorcentualBars(porcentualsBar);
    }

    private int calculatePorcentage(double[][] probabilities, int maxWidthFill, int position) {
        double porcentual = 0.0;
        if (position == 0) {
            porcentual = probabilities[0][0];
        } else if (position == 1) {
            porcentual = probabilities[0][1];
        }
        return (int)((porcentual *= 100.0) * (double)maxWidthFill / 100.0);
    }
}

