/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.uberfire.commons.util.Preconditions;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.java.nio.fs.base.AttrHolder;
import org.uberfire.java.nio.fs.base.FlexibleFileAttributeView;
import org.uberfire.java.nio.fs.base.NotImplementedException;
import org.uberfire.java.nio.fs.jgit.JGitFileAttributes;

public class JGitFileAttributeView<T extends JGitFileAttributes>
implements BasicFileAttributeView,
FlexibleFileAttributeView {
    static final String IS_REGULAR_FILE = "isRegularFile";
    static final String IS_DIRECTORY = "isDirectory";
    static final String IS_SYMBOLIC_LINK = "isSymbolicLink";
    static final String IS_OTHER = "isOther";
    static final String SIZE = "size";
    static final String FILE_KEY = "fileKey";
    static final String LAST_MODIFIED_TIME = "lastModifiedTime";
    static final String LAST_ACCESS_TIME = "lastAccessTime";
    static final String CREATION_TIME = "creationTime";
    static final Set<String> PROPERTIES = new HashSet<String>(){
        {
            this.add(JGitFileAttributeView.IS_REGULAR_FILE);
            this.add(JGitFileAttributeView.IS_DIRECTORY);
            this.add(JGitFileAttributeView.IS_SYMBOLIC_LINK);
            this.add(JGitFileAttributeView.IS_OTHER);
            this.add(JGitFileAttributeView.SIZE);
            this.add(JGitFileAttributeView.FILE_KEY);
            this.add(JGitFileAttributeView.LAST_MODIFIED_TIME);
            this.add(JGitFileAttributeView.LAST_ACCESS_TIME);
            this.add(JGitFileAttributeView.CREATION_TIME);
        }
    };
    private final AttrHolder<T> holder;

    public JGitFileAttributeView(AttrHolder<T> holder) {
        this.holder = (AttrHolder)Preconditions.checkNotNull((String)"holder", holder);
    }

    public String name() {
        return "basic";
    }

    public T readAttributes() throws IOException {
        return (T)((JGitFileAttributes)this.holder.getAttrs());
    }

    public Map<String, Object> readAttributes(String ... attributes) throws IOException {
        Preconditions.checkNotNull((String)"attributes", (Object)attributes);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String attribute : attributes) {
            Preconditions.checkNotEmpty((String)"attribute", (String)attribute);
            if (attribute.equals("*")) {
                result.put(IS_REGULAR_FILE, ((JGitFileAttributes)this.holder.getAttrs()).isRegularFile());
                result.put(IS_DIRECTORY, ((JGitFileAttributes)this.holder.getAttrs()).isDirectory());
                result.put(IS_SYMBOLIC_LINK, ((JGitFileAttributes)this.holder.getAttrs()).isSymbolicLink());
                result.put(IS_OTHER, ((JGitFileAttributes)this.holder.getAttrs()).isOther());
                result.put(SIZE, new Long(((JGitFileAttributes)this.holder.getAttrs()).size()));
                result.put(FILE_KEY, ((JGitFileAttributes)this.holder.getAttrs()).fileKey());
                result.put(LAST_MODIFIED_TIME, null);
                result.put(LAST_ACCESS_TIME, null);
                result.put(CREATION_TIME, null);
                break;
            }
            if (attribute.equals(IS_REGULAR_FILE)) {
                result.put(IS_REGULAR_FILE, ((JGitFileAttributes)this.holder.getAttrs()).isRegularFile());
                continue;
            }
            if (attribute.equals(IS_DIRECTORY)) {
                result.put(IS_DIRECTORY, ((JGitFileAttributes)this.holder.getAttrs()).isDirectory());
                continue;
            }
            if (attribute.equals(IS_SYMBOLIC_LINK)) {
                result.put(IS_SYMBOLIC_LINK, ((JGitFileAttributes)this.holder.getAttrs()).isSymbolicLink());
                continue;
            }
            if (attribute.equals(IS_OTHER)) {
                result.put(IS_OTHER, ((JGitFileAttributes)this.holder.getAttrs()).isOther());
                continue;
            }
            if (attribute.equals(SIZE)) {
                result.put(SIZE, new Long(((JGitFileAttributes)this.holder.getAttrs()).size()));
                continue;
            }
            if (attribute.equals(FILE_KEY)) {
                result.put(FILE_KEY, ((JGitFileAttributes)this.holder.getAttrs()).fileKey());
                continue;
            }
            if (attribute.equals(LAST_MODIFIED_TIME)) {
                result.put(LAST_MODIFIED_TIME, null);
                continue;
            }
            if (attribute.equals(LAST_ACCESS_TIME)) {
                result.put(LAST_ACCESS_TIME, null);
                continue;
            }
            if (!attribute.equals(CREATION_TIME)) continue;
            result.put(CREATION_TIME, null);
        }
        return result;
    }

    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        throw new NotImplementedException();
    }

    public void setAttribute(String attribute, Object value) throws IOException {
        Preconditions.checkNotEmpty((String)"attribute", (String)attribute);
        Preconditions.checkCondition((String)"invalid attribute", (boolean)PROPERTIES.contains(attribute));
        throw new NotImplementedException();
    }
}

