/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.cellde;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.comparator.CrowdingDistanceComparator;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.neighborhood.Neighborhood;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.CrowdingDistance;
import org.uma.jmetal.util.solutionattribute.impl.DominanceRanking;
import org.uma.jmetal.util.solutionattribute.impl.LocationAttribute;

public class CellDE45
implements Algorithm<List<DoubleSolution>> {
    private Problem<DoubleSolution> problem;
    private List<DoubleSolution> population;
    private int populationSize;
    protected int evaluations;
    protected int maxEvaluations;
    private Neighborhood<DoubleSolution> neighborhood;
    private int currentIndividual;
    private List<DoubleSolution> currentNeighbors;
    private SelectionOperator<List<DoubleSolution>, DoubleSolution> selection;
    private DifferentialEvolutionCrossover crossover;
    private BoundedArchive<DoubleSolution> archive;
    private Comparator<DoubleSolution> dominanceComparator;
    private LocationAttribute<DoubleSolution> location;
    private SolutionListEvaluator<DoubleSolution> evaluator;
    private double feedback;
    private CrowdingDistanceComparator<DoubleSolution> comparator = new CrowdingDistanceComparator();
    private CrowdingDistance<DoubleSolution> distance = new CrowdingDistance();

    public CellDE45(Problem<DoubleSolution> problem, int maxEvaluations, int populationSize, BoundedArchive<DoubleSolution> archive, Neighborhood<DoubleSolution> neighborhood, SelectionOperator<List<DoubleSolution>, DoubleSolution> selection, DifferentialEvolutionCrossover crossover, double feedback, SolutionListEvaluator<DoubleSolution> evaluator) {
        this.problem = problem;
        this.populationSize = populationSize;
        this.maxEvaluations = maxEvaluations;
        this.archive = archive;
        this.neighborhood = neighborhood;
        this.selection = selection;
        this.crossover = crossover;
        this.dominanceComparator = new DominanceComparator();
        this.feedback = feedback;
        this.evaluator = evaluator;
    }

    public void run() {
        this.population = this.createInitialPopulation();
        this.population = this.evaluatePopulation(this.population);
        this.initProgress();
        while (!this.isStoppingConditionReached()) {
            int i;
            for (i = 0; i < this.populationSize; ++i) {
                DoubleSolution solution = (DoubleSolution)this.population.get(i).copy();
                this.currentNeighbors = this.neighborhood.getNeighbors(this.population, i);
                this.currentNeighbors.add(this.population.get(i));
                ArrayList<Object> parents = new ArrayList<Object>();
                parents.add(this.selection.execute(this.currentNeighbors));
                parents.add(this.selection.execute(this.currentNeighbors));
                parents.add(solution);
                this.crossover.setCurrentSolution(this.population.get(i));
                List children = this.crossover.execute(parents);
                DoubleSolution offspring = (DoubleSolution)children.get(0);
                this.problem.evaluate((Object)offspring);
                ++this.evaluations;
                int result = this.dominanceComparator.compare(this.population.get(i), offspring);
                if (result == 1) {
                    this.location.setAttribute((Solution)offspring, this.location.getAttribute((Solution)this.population.get(i)));
                    this.population.set(i, (DoubleSolution)offspring.copy());
                    this.archive.add((Object)((DoubleSolution)offspring.copy()));
                    continue;
                }
                if (result != 0) continue;
                Ranking<DoubleSolution> ranking = this.computeRanking(this.currentNeighbors);
                this.distance.computeDensityEstimator(ranking.getSubfront(0));
                boolean deleteMutant = true;
                int compareResult = this.comparator.compare((Solution)solution, (Solution)offspring);
                if (compareResult == 1) {
                    deleteMutant = false;
                }
                if (!deleteMutant) {
                    this.location.setAttribute((Solution)offspring, this.location.getAttribute((Solution)solution));
                    this.population.set((Integer)this.location.getAttribute((Solution)offspring), offspring);
                    this.archive.add((Object)((DoubleSolution)offspring.copy()));
                    continue;
                }
                this.archive.add((Object)((DoubleSolution)offspring.copy()));
            }
            i = 0;
            while ((double)i < this.feedback) {
                int random;
                if (this.archive.size() > i && (random = JMetalRandom.getInstance().nextInt(0, this.population.size() - 1)) < this.population.size()) {
                    DoubleSolution solution = (DoubleSolution)this.archive.get(i);
                    this.location.setAttribute((Solution)solution, (Object)random);
                    this.population.set(random, (DoubleSolution)solution.copy());
                }
                ++i;
            }
        }
    }

    protected List<DoubleSolution> createInitialPopulation() {
        ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(this.populationSize);
        for (int i = 0; i < this.populationSize; ++i) {
            DoubleSolution newIndividual = (DoubleSolution)this.problem.createSolution();
            population.add(newIndividual);
        }
        this.location = new LocationAttribute(population);
        return population;
    }

    protected List<DoubleSolution> evaluatePopulation(List<DoubleSolution> population) {
        return this.evaluator.evaluate(population, this.problem);
    }

    protected void initProgress() {
        this.evaluations = this.populationSize;
        this.currentIndividual = 0;
    }

    protected void updateProgress() {
        ++this.evaluations;
        this.currentIndividual = (this.currentIndividual + 1) % this.populationSize;
    }

    protected boolean isStoppingConditionReached() {
        return this.evaluations == this.maxEvaluations;
    }

    public String getName() {
        return "CellDE";
    }

    public String getDescription() {
        return "Multi-Objective Differential Evolution Cellular evolutionary algorithm";
    }

    public List<DoubleSolution> getResult() {
        return this.archive.getSolutionList();
    }

    protected Ranking<DoubleSolution> computeRanking(List<DoubleSolution> solutionList) {
        DominanceRanking ranking = new DominanceRanking();
        ranking.computeRanking(solutionList);
        return ranking;
    }
}

