/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.ibea;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.solutionattribute.impl.Fitness;

public class IBEA<S extends Solution<?>>
implements Algorithm<List<S>> {
    protected Problem<S> problem;
    public static final int TOURNAMENTS_ROUNDS = 1;
    protected List<List<Double>> indicatorValues;
    protected double maxIndicatorValue;
    protected int populationSize;
    protected int archiveSize;
    protected int maxEvaluations;
    protected List<S> archive;
    protected CrossoverOperator<S> crossoverOperator;
    protected MutationOperator<S> mutationOperator;
    protected SelectionOperator<List<S>, S> selectionOperator;
    protected Fitness<S> solutionFitness = new Fitness();

    public IBEA(Problem<S> problem, int populationSize, int archiveSize, int maxEvaluations, SelectionOperator<List<S>, S> selectionOperator, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator) {
        this.problem = problem;
        this.populationSize = populationSize;
        this.archiveSize = archiveSize;
        this.maxEvaluations = maxEvaluations;
        this.crossoverOperator = crossoverOperator;
        this.mutationOperator = mutationOperator;
        this.selectionOperator = selectionOperator;
    }

    public void run() {
        ArrayList<Solution> solutionSet = new ArrayList<Solution>(this.populationSize);
        this.archive = new ArrayList<S>(this.archiveSize);
        int evaluations = 0;
        for (int i = 0; i < this.populationSize; ++i) {
            Solution newSolution = (Solution)this.problem.createSolution();
            this.problem.evaluate((Object)newSolution);
            ++evaluations;
            solutionSet.add(newSolution);
        }
        while (evaluations < this.maxEvaluations) {
            ArrayList<S> union = new ArrayList<S>();
            union.addAll(solutionSet);
            union.addAll(this.archive);
            this.calculateFitness(union);
            this.archive = union;
            while (this.archive.size() > this.populationSize) {
                this.removeWorst(this.archive);
            }
            ArrayList offSpringSolutionSet = new ArrayList(this.populationSize);
            while (offSpringSolutionSet.size() < this.populationSize) {
                Solution parent2;
                Solution parent1;
                int j = 0;
                do {
                    parent1 = (Solution)this.selectionOperator.execute(this.archive);
                } while (++j < 1);
                int k = 0;
                do {
                    parent2 = (Solution)this.selectionOperator.execute(this.archive);
                } while (++k < 1);
                ArrayList<Solution> parents = new ArrayList<Solution>(2);
                parents.add(parent1);
                parents.add(parent2);
                List offspring = (List)this.crossoverOperator.execute(parents);
                this.mutationOperator.execute(offspring.get(0));
                this.problem.evaluate(offspring.get(0));
                offSpringSolutionSet.add(offspring.get(0));
                ++evaluations;
            }
            solutionSet = offSpringSolutionSet;
        }
    }

    public List<S> getResult() {
        return SolutionListUtils.getNondominatedSolutions(this.archive);
    }

    double calculateHypervolumeIndicator(Solution<?> solutionA, Solution<?> solutionB, int d, double[] maximumValues, double[] minimumValues) {
        double volume;
        double rho = 2.0;
        double r = rho * (maximumValues[d - 1] - minimumValues[d - 1]);
        double max = minimumValues[d - 1] + r;
        double a = solutionA.getObjective(d - 1);
        double b = solutionB == null ? max : solutionB.getObjective(d - 1);
        if (d == 1) {
            volume = a < b ? (b - a) / r : 0.0;
        } else if (a < b) {
            volume = this.calculateHypervolumeIndicator(solutionA, null, d - 1, maximumValues, minimumValues) * (b - a) / r;
            volume += this.calculateHypervolumeIndicator(solutionA, solutionB, d - 1, maximumValues, minimumValues) * (max - b) / r;
        } else {
            volume = this.calculateHypervolumeIndicator(solutionA, solutionB, d - 1, maximumValues, minimumValues) * (max - a) / r;
        }
        return volume;
    }

    public void computeIndicatorValuesHD(List<S> solutionSet, double[] maximumValues, double[] minimumValues) {
        this.indicatorValues = new ArrayList<List<Double>>();
        this.maxIndicatorValue = -1.7976931348623157E308;
        for (int j = 0; j < solutionSet.size(); ++j) {
            ArrayList<S> A = new ArrayList<S>(1);
            A.add(solutionSet.get(j));
            ArrayList<Double> aux = new ArrayList<Double>();
            for (Solution solution : solutionSet) {
                ArrayList<Solution> B = new ArrayList<Solution>(1);
                B.add(solution);
                int flag = new DominanceComparator().compare((Solution)A.get(0), (Solution)B.get(0));
                double value = flag == -1 ? -this.calculateHypervolumeIndicator((Solution)A.get(0), (Solution)B.get(0), this.problem.getNumberOfObjectives(), maximumValues, minimumValues) : this.calculateHypervolumeIndicator((Solution)B.get(0), (Solution)A.get(0), this.problem.getNumberOfObjectives(), maximumValues, minimumValues);
                if (Math.abs(value) > this.maxIndicatorValue) {
                    this.maxIndicatorValue = Math.abs(value);
                }
                aux.add(value);
            }
            this.indicatorValues.add(aux);
        }
    }

    public void fitness(List<S> solutionSet, int pos) {
        double fitness = 0.0;
        double kappa = 0.05;
        for (int i = 0; i < solutionSet.size(); ++i) {
            if (i == pos) continue;
            fitness += Math.exp(-1.0 * this.indicatorValues.get(i).get(pos) / this.maxIndicatorValue / kappa);
        }
        this.solutionFitness.setAttribute((Solution)solutionSet.get(pos), (Object)fitness);
    }

    public void calculateFitness(List<S> solutionSet) {
        double[] maximumValues = new double[this.problem.getNumberOfObjectives()];
        double[] minimumValues = new double[this.problem.getNumberOfObjectives()];
        for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            maximumValues[i] = -1.7976931348623157E308;
            minimumValues[i] = Double.MAX_VALUE;
        }
        for (Solution solution : solutionSet) {
            for (int obj = 0; obj < this.problem.getNumberOfObjectives(); ++obj) {
                double value = solution.getObjective(obj);
                if (value > maximumValues[obj]) {
                    maximumValues[obj] = value;
                }
                if (!(value < minimumValues[obj])) continue;
                minimumValues[obj] = value;
            }
        }
        this.computeIndicatorValuesHD(solutionSet, maximumValues, minimumValues);
        for (int pos = 0; pos < solutionSet.size(); ++pos) {
            this.fitness(solutionSet, pos);
        }
    }

    public void removeWorst(List<S> solutionSet) {
        int i;
        double worst = (Double)this.solutionFitness.getAttribute((Solution)solutionSet.get(0));
        int worstIndex = 0;
        double kappa = 0.05;
        for (i = 1; i < solutionSet.size(); ++i) {
            if (!((Double)this.solutionFitness.getAttribute((Solution)solutionSet.get(i)) > worst)) continue;
            worst = (Double)this.solutionFitness.getAttribute((Solution)solutionSet.get(i));
            worstIndex = i;
        }
        for (i = 0; i < solutionSet.size(); ++i) {
            if (i == worstIndex) continue;
            double fitness = (Double)this.solutionFitness.getAttribute((Solution)solutionSet.get(i));
            this.solutionFitness.setAttribute((Solution)solutionSet.get(i), (Object)(fitness -= Math.exp(-this.indicatorValues.get(worstIndex).get(i).doubleValue() / this.maxIndicatorValue / kappa)));
        }
        this.indicatorValues.remove(worstIndex);
        for (List<Double> anIndicatorValues_ : this.indicatorValues) {
            anIndicatorValues_.remove(worstIndex);
        }
        solutionSet.remove(worstIndex);
    }

    public String getName() {
        return "IBEA";
    }

    public String getDescription() {
        return "Indicator based Evolutionary Algorithm";
    }
}

