/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.ibea;

import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.ibea.IBEA;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.AlgorithmBuilder;

public class IBEABuilder
implements AlgorithmBuilder<IBEA<DoubleSolution>> {
    private Problem<DoubleSolution> problem;
    private int populationSize;
    private int archiveSize;
    private int maxEvaluations;
    private CrossoverOperator<DoubleSolution> crossover;
    private MutationOperator<DoubleSolution> mutation;
    private SelectionOperator<List<DoubleSolution>, DoubleSolution> selection;

    public IBEABuilder(Problem<DoubleSolution> problem) {
        this.problem = problem;
        this.populationSize = 100;
        this.archiveSize = 100;
        this.maxEvaluations = 25000;
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 20.0;
        this.crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        this.mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        this.selection = new BinaryTournamentSelection();
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public int getArchiveSize() {
        return this.archiveSize;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public CrossoverOperator<DoubleSolution> getCrossover() {
        return this.crossover;
    }

    public MutationOperator<DoubleSolution> getMutation() {
        return this.mutation;
    }

    public SelectionOperator<List<DoubleSolution>, DoubleSolution> getSelection() {
        return this.selection;
    }

    public IBEABuilder setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
        return this;
    }

    public IBEABuilder setArchiveSize(int archiveSize) {
        this.archiveSize = archiveSize;
        return this;
    }

    public IBEABuilder setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
        return this;
    }

    public IBEABuilder setCrossover(CrossoverOperator<DoubleSolution> crossover) {
        this.crossover = crossover;
        return this;
    }

    public IBEABuilder setMutation(MutationOperator<DoubleSolution> mutation) {
        this.mutation = mutation;
        return this;
    }

    public IBEABuilder setSelection(SelectionOperator<List<DoubleSolution>, DoubleSolution> selection) {
        this.selection = selection;
        return this;
    }

    public IBEA<DoubleSolution> build() {
        return new IBEA<DoubleSolution>(this.problem, this.populationSize, this.archiveSize, this.maxEvaluations, this.selection, this.crossover, this.mutation);
    }
}

