/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.moead;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.moead.util.MOEADUtils;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public abstract class AbstractMOEAD<S extends Solution<?>>
implements Algorithm<List<S>> {
    protected Problem<S> problem;
    protected double[] idealPoint;
    protected double[] nadirPoint;
    protected double[][] lambda;
    protected int neighborSize;
    protected int[][] neighborhood;
    protected double neighborhoodSelectionProbability;
    protected int maximumNumberOfReplacedSolutions;
    protected Solution<?>[] indArray;
    protected FunctionType functionType;
    protected String dataDirectory;
    protected List<S> population;
    protected List<S> offspringPopulation;
    protected List<S> jointPopulation;
    protected int populationSize;
    protected int resultPopulationSize;
    protected int evaluations;
    protected int maxEvaluations;
    protected JMetalRandom randomGenerator;
    protected CrossoverOperator<S> crossoverOperator;
    protected MutationOperator<S> mutationOperator;

    public AbstractMOEAD(Problem<S> problem, int populationSize, int resultPopulationSize, int maxEvaluations, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutation, FunctionType functionType, String dataDirectory, double neighborhoodSelectionProbability, int maximumNumberOfReplacedSolutions, int neighborSize) {
        this.problem = problem;
        this.populationSize = populationSize;
        this.resultPopulationSize = resultPopulationSize;
        this.maxEvaluations = maxEvaluations;
        this.mutationOperator = mutation;
        this.crossoverOperator = crossoverOperator;
        this.functionType = functionType;
        this.dataDirectory = dataDirectory;
        this.neighborhoodSelectionProbability = neighborhoodSelectionProbability;
        this.maximumNumberOfReplacedSolutions = maximumNumberOfReplacedSolutions;
        this.neighborSize = neighborSize;
        this.randomGenerator = JMetalRandom.getInstance();
        this.population = new ArrayList<S>(populationSize);
        this.indArray = new Solution[problem.getNumberOfObjectives()];
        this.neighborhood = new int[populationSize][neighborSize];
        this.idealPoint = new double[problem.getNumberOfObjectives()];
        this.nadirPoint = new double[problem.getNumberOfObjectives()];
        this.lambda = new double[populationSize][problem.getNumberOfObjectives()];
    }

    protected void initializeUniformWeight() {
        if (this.problem.getNumberOfObjectives() == 2 && this.populationSize <= 300) {
            for (int n = 0; n < this.populationSize; ++n) {
                double a;
                this.lambda[n][0] = a = 1.0 * (double)n / (double)(this.populationSize - 1);
                this.lambda[n][1] = 1.0 - a;
            }
        } else {
            String dataFileName = "W" + this.problem.getNumberOfObjectives() + "D_" + this.populationSize + ".dat";
            try {
                InputStream in = this.getClass().getResourceAsStream("/" + this.dataDirectory + "/" + dataFileName);
                InputStreamReader isr = new InputStreamReader(in);
                BufferedReader br = new BufferedReader(isr);
                int i = 0;
                int j = 0;
                String aux = br.readLine();
                while (aux != null) {
                    StringTokenizer st = new StringTokenizer(aux);
                    j = 0;
                    while (st.hasMoreTokens()) {
                        double value;
                        this.lambda[i][j] = value = new Double(st.nextToken()).doubleValue();
                        ++j;
                    }
                    aux = br.readLine();
                    ++i;
                }
                br.close();
            }
            catch (Exception e) {
                throw new JMetalException("initializeUniformWeight: failed when reading for file: " + this.dataDirectory + "/" + dataFileName, e);
            }
        }
    }

    protected void initializeNeighborhood() {
        double[] x = new double[this.populationSize];
        int[] idx = new int[this.populationSize];
        for (int i = 0; i < this.populationSize; ++i) {
            for (int j = 0; j < this.populationSize; ++j) {
                x[j] = MOEADUtils.distVector(this.lambda[i], this.lambda[j]);
                idx[j] = j;
            }
            MOEADUtils.minFastSort(x, idx, this.populationSize, this.neighborSize);
            System.arraycopy(idx, 0, this.neighborhood[i], 0, this.neighborSize);
        }
    }

    protected void initializeIdealPoint() {
        int i;
        for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            this.idealPoint[i] = 1.0E30;
        }
        for (i = 0; i < this.populationSize; ++i) {
            this.updateIdealPoint((Solution)this.population.get(i));
        }
    }

    protected void initializeNadirPoint() {
        int i;
        for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            this.nadirPoint[i] = -1.0E30;
        }
        for (i = 0; i < this.populationSize; ++i) {
            this.updateNadirPoint((Solution)this.population.get(i));
        }
    }

    protected void updateNadirPoint(S individual) {
        for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            if (!(individual.getObjective(i) > this.nadirPoint[i])) continue;
            this.nadirPoint[i] = individual.getObjective(i);
        }
    }

    protected void updateIdealPoint(S individual) {
        for (int n = 0; n < this.problem.getNumberOfObjectives(); ++n) {
            if (!(individual.getObjective(n) < this.idealPoint[n])) continue;
            this.idealPoint[n] = individual.getObjective(n);
        }
    }

    protected NeighborType chooseNeighborType() {
        double rnd = this.randomGenerator.nextDouble();
        NeighborType neighborType = rnd < this.neighborhoodSelectionProbability ? NeighborType.NEIGHBOR : NeighborType.POPULATION;
        return neighborType;
    }

    protected List<S> parentSelection(int subProblemId, NeighborType neighborType) {
        List<Integer> matingPool = this.matingSelection(subProblemId, 2, neighborType);
        ArrayList<S> parents = new ArrayList<S>(3);
        parents.add(this.population.get(matingPool.get(0)));
        parents.add(this.population.get(matingPool.get(1)));
        parents.add(this.population.get(subProblemId));
        return parents;
    }

    protected List<Integer> matingSelection(int subproblemId, int numberOfSolutionsToSelect, NeighborType neighbourType) {
        ArrayList<Integer> listOfSolutions = new ArrayList<Integer>(numberOfSolutionsToSelect);
        int neighbourSize = this.neighborhood[subproblemId].length;
        while (listOfSolutions.size() < numberOfSolutionsToSelect) {
            int selectedSolution;
            if (neighbourType == NeighborType.NEIGHBOR) {
                int random = this.randomGenerator.nextInt(0, neighbourSize - 1);
                selectedSolution = this.neighborhood[subproblemId][random];
            } else {
                selectedSolution = this.randomGenerator.nextInt(0, this.populationSize - 1);
            }
            boolean flag = true;
            for (Integer individualId : listOfSolutions) {
                if (individualId != selectedSolution) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            listOfSolutions.add(selectedSolution);
        }
        return listOfSolutions;
    }

    protected void updateNeighborhood(S individual, int subProblemId, NeighborType neighborType) throws JMetalException {
        int time = 0;
        int size = neighborType == NeighborType.NEIGHBOR ? this.neighborhood[subProblemId].length : this.population.size();
        int[] perm = new int[size];
        MOEADUtils.randomPermutation(perm, size);
        for (int i = 0; i < size; ++i) {
            int k = neighborType == NeighborType.NEIGHBOR ? this.neighborhood[subProblemId][perm[i]] : perm[i];
            double f1 = this.fitnessFunction((Solution)this.population.get(k), this.lambda[k]);
            double f2 = this.fitnessFunction(individual, this.lambda[k]);
            if (f2 < f1) {
                this.population.set(k, individual.copy());
                ++time;
            }
            if (time < this.maximumNumberOfReplacedSolutions) continue;
            return;
        }
    }

    double fitnessFunction(S individual, double[] lambda) throws JMetalException {
        double fitness;
        if (FunctionType.TCHE.equals((Object)this.functionType)) {
            double maxFun = -1.0E30;
            for (int n = 0; n < this.problem.getNumberOfObjectives(); ++n) {
                double diff = Math.abs(individual.getObjective(n) - this.idealPoint[n]);
                double feval = lambda[n] == 0.0 ? 1.0E-4 * diff : diff * lambda[n];
                if (!(feval > maxFun)) continue;
                maxFun = feval;
            }
            fitness = maxFun;
        } else if (FunctionType.AGG.equals((Object)this.functionType)) {
            double sum = 0.0;
            for (int n = 0; n < this.problem.getNumberOfObjectives(); ++n) {
                sum += lambda[n] * individual.getObjective(n);
            }
            fitness = sum;
        } else if (FunctionType.PBI.equals((Object)this.functionType)) {
            int i;
            double theta = 5.0;
            double nl = 0.0;
            double d2 = 0.0;
            double d1 = 0.0;
            for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
                d1 += (individual.getObjective(i) - this.idealPoint[i]) * lambda[i];
                nl += Math.pow(lambda[i], 2.0);
            }
            nl = Math.sqrt(nl);
            d1 = Math.abs(d1) / nl;
            for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
                d2 += Math.pow(individual.getObjective(i) - this.idealPoint[i] - d1 * (lambda[i] / nl), 2.0);
            }
            d2 = Math.sqrt(d2);
            fitness = d1 + theta * d2;
        } else {
            throw new JMetalException(" MOEAD.fitnessFunction: unknown type " + (Object)((Object)this.functionType));
        }
        return fitness;
    }

    public List<S> getResult() {
        return this.population;
    }

    public static enum FunctionType {
        TCHE,
        PBI,
        AGG;

    }

    protected static enum NeighborType {
        NEIGHBOR,
        POPULATION;

    }
}

