/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.moead;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.moead.AbstractMOEAD;
import org.uma.jmetal.algorithm.multiobjective.moead.util.MOEADUtils;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.DoubleSolution;

public class MOEAD
extends AbstractMOEAD<DoubleSolution> {
    protected DifferentialEvolutionCrossover differentialEvolutionCrossover;

    public MOEAD(Problem<DoubleSolution> problem, int populationSize, int resultPopulationSize, int maxEvaluations, MutationOperator<DoubleSolution> mutation, CrossoverOperator<DoubleSolution> crossover, AbstractMOEAD.FunctionType functionType, String dataDirectory, double neighborhoodSelectionProbability, int maximumNumberOfReplacedSolutions, int neighborSize) {
        super(problem, populationSize, resultPopulationSize, maxEvaluations, crossover, mutation, functionType, dataDirectory, neighborhoodSelectionProbability, maximumNumberOfReplacedSolutions, neighborSize);
        this.differentialEvolutionCrossover = (DifferentialEvolutionCrossover)this.crossoverOperator;
    }

    public void run() {
        this.initializePopulation();
        this.initializeUniformWeight();
        this.initializeNeighborhood();
        this.initializeIdealPoint();
        this.evaluations = this.populationSize;
        do {
            int[] permutation = new int[this.populationSize];
            MOEADUtils.randomPermutation(permutation, this.populationSize);
            for (int i = 0; i < this.populationSize; ++i) {
                int subProblemId = permutation[i];
                AbstractMOEAD.NeighborType neighborType = this.chooseNeighborType();
                List parents = this.parentSelection(subProblemId, neighborType);
                this.differentialEvolutionCrossover.setCurrentSolution((DoubleSolution)this.population.get(subProblemId));
                List children = this.differentialEvolutionCrossover.execute(parents);
                DoubleSolution child = (DoubleSolution)children.get(0);
                this.mutationOperator.execute((Object)child);
                this.problem.evaluate((Object)child);
                ++this.evaluations;
                this.updateIdealPoint(child);
                this.updateNeighborhood(child, subProblemId, neighborType);
            }
        } while (this.evaluations < this.maxEvaluations);
    }

    protected void initializePopulation() {
        this.population = new ArrayList(this.populationSize);
        for (int i = 0; i < this.populationSize; ++i) {
            DoubleSolution newSolution = (DoubleSolution)this.problem.createSolution();
            this.problem.evaluate((Object)newSolution);
            this.population.add(newSolution);
        }
    }

    public String getName() {
        return "MOEAD";
    }

    public String getDescription() {
        return "Multi-Objective Evolutionary Algorithm based on Decomposition";
    }
}

