/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.moead;

import org.uma.jmetal.algorithm.multiobjective.moead.AbstractMOEAD;
import org.uma.jmetal.algorithm.multiobjective.moead.ConstraintMOEAD;
import org.uma.jmetal.algorithm.multiobjective.moead.MOEAD;
import org.uma.jmetal.algorithm.multiobjective.moead.MOEADDRA;
import org.uma.jmetal.algorithm.multiobjective.moead.MOEADSTM;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.AlgorithmBuilder;

public class MOEADBuilder
implements AlgorithmBuilder<AbstractMOEAD<DoubleSolution>> {
    protected Problem<DoubleSolution> problem;
    protected int neighborSize;
    protected double neighborhoodSelectionProbability;
    protected int maximumNumberOfReplacedSolutions;
    protected AbstractMOEAD.FunctionType functionType;
    protected CrossoverOperator<DoubleSolution> crossover;
    protected MutationOperator<DoubleSolution> mutation;
    protected String dataDirectory;
    protected int populationSize;
    protected int resultPopulationSize;
    protected int maxEvaluations;
    protected int numberOfThreads;
    protected Variant moeadVariant;

    public MOEADBuilder(Problem<DoubleSolution> problem, Variant variant) {
        this.problem = problem;
        this.populationSize = 300;
        this.resultPopulationSize = 300;
        this.maxEvaluations = 150000;
        this.crossover = new DifferentialEvolutionCrossover();
        this.mutation = new PolynomialMutation(1.0 / (double)problem.getNumberOfVariables(), 20.0);
        this.functionType = AbstractMOEAD.FunctionType.TCHE;
        this.neighborhoodSelectionProbability = 0.1;
        this.maximumNumberOfReplacedSolutions = 2;
        this.dataDirectory = "";
        this.neighborSize = 20;
        this.numberOfThreads = 1;
        this.moeadVariant = variant;
    }

    public int getNeighborSize() {
        return this.neighborSize;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public int getResultPopulationSize() {
        return this.resultPopulationSize;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public MutationOperator<DoubleSolution> getMutation() {
        return this.mutation;
    }

    public CrossoverOperator<DoubleSolution> getCrossover() {
        return this.crossover;
    }

    public AbstractMOEAD.FunctionType getFunctionType() {
        return this.functionType;
    }

    public int getMaximumNumberOfReplacedSolutions() {
        return this.maximumNumberOfReplacedSolutions;
    }

    public double getNeighborhoodSelectionProbability() {
        return this.neighborhoodSelectionProbability;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public MOEADBuilder setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
        return this;
    }

    public MOEADBuilder setResultPopulationSize(int resultPopulationSize) {
        this.resultPopulationSize = resultPopulationSize;
        return this;
    }

    public MOEADBuilder setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
        return this;
    }

    public MOEADBuilder setNeighborSize(int neighborSize) {
        this.neighborSize = neighborSize;
        return this;
    }

    public MOEADBuilder setNeighborhoodSelectionProbability(double neighborhoodSelectionProbability) {
        this.neighborhoodSelectionProbability = neighborhoodSelectionProbability;
        return this;
    }

    public MOEADBuilder setFunctionType(AbstractMOEAD.FunctionType functionType) {
        this.functionType = functionType;
        return this;
    }

    public MOEADBuilder setMaximumNumberOfReplacedSolutions(int maximumNumberOfReplacedSolutions) {
        this.maximumNumberOfReplacedSolutions = maximumNumberOfReplacedSolutions;
        return this;
    }

    public MOEADBuilder setCrossover(CrossoverOperator<DoubleSolution> crossover) {
        this.crossover = crossover;
        return this;
    }

    public MOEADBuilder setMutation(MutationOperator<DoubleSolution> mutation) {
        this.mutation = mutation;
        return this;
    }

    public MOEADBuilder setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
        return this;
    }

    public MOEADBuilder setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
        return this;
    }

    public AbstractMOEAD<DoubleSolution> build() {
        AbstractMOEAD algorithm = null;
        if (this.moeadVariant.equals((Object)Variant.MOEAD)) {
            algorithm = new MOEAD(this.problem, this.populationSize, this.resultPopulationSize, this.maxEvaluations, this.mutation, this.crossover, this.functionType, this.dataDirectory, this.neighborhoodSelectionProbability, this.maximumNumberOfReplacedSolutions, this.neighborSize);
        } else if (this.moeadVariant.equals((Object)Variant.ConstraintMOEAD)) {
            algorithm = new ConstraintMOEAD(this.problem, this.populationSize, this.resultPopulationSize, this.maxEvaluations, this.mutation, this.crossover, this.functionType, this.dataDirectory, this.neighborhoodSelectionProbability, this.maximumNumberOfReplacedSolutions, this.neighborSize);
        } else if (this.moeadVariant.equals((Object)Variant.MOEADDRA)) {
            algorithm = new MOEADDRA(this.problem, this.populationSize, this.resultPopulationSize, this.maxEvaluations, this.mutation, this.crossover, this.functionType, this.dataDirectory, this.neighborhoodSelectionProbability, this.maximumNumberOfReplacedSolutions, this.neighborSize);
        } else if (this.moeadVariant.equals((Object)Variant.MOEADSTM)) {
            algorithm = new MOEADSTM(this.problem, this.populationSize, this.resultPopulationSize, this.maxEvaluations, this.mutation, this.crossover, this.functionType, this.dataDirectory, this.neighborhoodSelectionProbability, this.maximumNumberOfReplacedSolutions, this.neighborSize);
        }
        return algorithm;
    }

    public static enum Variant {
        MOEAD,
        ConstraintMOEAD,
        MOEADDRA,
        MOEADSTM;

    }
}

