/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.nsgaii;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.comparator.CrowdingDistanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.CrowdingDistance;
import org.uma.jmetal.util.solutionattribute.impl.DominanceRanking;

public class NSGAII45<S extends Solution<?>>
implements Algorithm<List<S>> {
    protected List<S> population;
    protected final int maxEvaluations;
    protected final int populationSize;
    protected final Problem<S> problem;
    protected final SolutionListEvaluator<S> evaluator;
    protected int evaluations;
    protected SelectionOperator<List<S>, S> selectionOperator;
    protected CrossoverOperator<S> crossoverOperator;
    protected MutationOperator<S> mutationOperator;

    public NSGAII45(Problem<S> problem, int maxEvaluations, int populationSize, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, SolutionListEvaluator<S> evaluator) {
        this.problem = problem;
        this.maxEvaluations = maxEvaluations;
        this.populationSize = populationSize;
        this.crossoverOperator = crossoverOperator;
        this.mutationOperator = mutationOperator;
        this.selectionOperator = selectionOperator;
        this.evaluator = evaluator;
    }

    public void run() {
        this.population = this.createInitialPopulation();
        this.evaluatePopulation(this.population);
        this.evaluations = this.populationSize;
        while (this.evaluations < this.maxEvaluations) {
            ArrayList offspringPopulation = new ArrayList(this.populationSize);
            for (int i = 0; i < this.populationSize; i += 2) {
                ArrayList<Object> parents = new ArrayList<Object>(2);
                parents.add(this.selectionOperator.execute(this.population));
                parents.add(this.selectionOperator.execute(this.population));
                List offspring = (List)this.crossoverOperator.execute(parents);
                this.mutationOperator.execute(offspring.get(0));
                this.mutationOperator.execute(offspring.get(1));
                offspringPopulation.add(offspring.get(0));
                offspringPopulation.add(offspring.get(1));
            }
            this.evaluatePopulation(offspringPopulation);
            ArrayList<Object> jointPopulation = new ArrayList<Object>();
            jointPopulation.addAll(this.population);
            jointPopulation.addAll(offspringPopulation);
            Ranking ranking = this.computeRanking(jointPopulation);
            this.population = this.crowdingDistanceSelection(ranking);
            this.evaluations += this.populationSize;
        }
    }

    public List<S> getResult() {
        return this.getNonDominatedSolutions(this.population);
    }

    protected List<S> createInitialPopulation() {
        ArrayList<Solution> population = new ArrayList<Solution>(this.populationSize);
        for (int i = 0; i < this.populationSize; ++i) {
            Solution newIndividual = (Solution)this.problem.createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    protected List<S> evaluatePopulation(List<S> population) {
        population = this.evaluator.evaluate(population, this.problem);
        return population;
    }

    protected Ranking<S> computeRanking(List<S> solutionList) {
        DominanceRanking ranking = new DominanceRanking();
        ranking.computeRanking(solutionList);
        return ranking;
    }

    protected List<S> crowdingDistanceSelection(Ranking<S> ranking) {
        CrowdingDistance crowdingDistance = new CrowdingDistance();
        ArrayList population = new ArrayList(this.populationSize);
        int rankingIndex = 0;
        while (this.populationIsNotFull(population)) {
            if (this.subfrontFillsIntoThePopulation(ranking, rankingIndex, population)) {
                this.addRankedSolutionsToPopulation(ranking, rankingIndex, population);
                ++rankingIndex;
                continue;
            }
            crowdingDistance.computeDensityEstimator(ranking.getSubfront(rankingIndex));
            this.addLastRankedSolutionsToPopulation(ranking, rankingIndex, population);
        }
        return population;
    }

    protected boolean populationIsNotFull(List<S> population) {
        return population.size() < this.populationSize;
    }

    protected boolean subfrontFillsIntoThePopulation(Ranking<S> ranking, int rank, List<S> population) {
        return ranking.getSubfront(rank).size() < this.populationSize - population.size();
    }

    protected void addRankedSolutionsToPopulation(Ranking<S> ranking, int rank, List<S> population) {
        List front = ranking.getSubfront(rank);
        for (Solution solution : front) {
            population.add(solution);
        }
    }

    protected void addLastRankedSolutionsToPopulation(Ranking<S> ranking, int rank, List<S> population) {
        List currentRankedFront = ranking.getSubfront(rank);
        Collections.sort(currentRankedFront, new CrowdingDistanceComparator());
        int i = 0;
        while (population.size() < this.populationSize) {
            population.add(currentRankedFront.get(i));
            ++i;
        }
    }

    protected List<S> getNonDominatedSolutions(List<S> solutionList) {
        return SolutionListUtils.getNondominatedSolutions(solutionList);
    }

    public String getName() {
        return "NSGAII45";
    }

    public String getDescription() {
        return "Nondominated Sorting Genetic Algorithm version II. Version not using the AbstractGeneticAlgorithm template";
    }
}

