/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.nsgaii;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIMeasures;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.SteadyStateNSGAII;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.AlgorithmBuilder;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class NSGAIIBuilder<S extends Solution<?>>
implements AlgorithmBuilder<NSGAII<S>> {
    private final Problem<S> problem;
    private int maxEvaluations;
    private int populationSize;
    private CrossoverOperator<S> crossoverOperator;
    private MutationOperator<S> mutationOperator;
    private SelectionOperator<List<S>, S> selectionOperator;
    private SolutionListEvaluator<S> evaluator;
    private NSGAIIVariant variant;

    public NSGAIIBuilder(Problem<S> problem, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator) {
        this.problem = problem;
        this.maxEvaluations = 25000;
        this.populationSize = 100;
        this.crossoverOperator = crossoverOperator;
        this.mutationOperator = mutationOperator;
        this.selectionOperator = new BinaryTournamentSelection((Comparator)new RankingAndCrowdingDistanceComparator());
        this.evaluator = new SequentialSolutionListEvaluator();
        this.variant = NSGAIIVariant.NSGAII;
    }

    public NSGAIIBuilder<S> setMaxEvaluations(int maxEvaluations) {
        if (maxEvaluations < 0) {
            throw new JMetalException("maxEvaluations is negative: " + maxEvaluations);
        }
        this.maxEvaluations = maxEvaluations;
        return this;
    }

    public NSGAIIBuilder<S> setPopulationSize(int populationSize) {
        if (populationSize < 0) {
            throw new JMetalException("Population size is negative: " + populationSize);
        }
        this.populationSize = populationSize;
        return this;
    }

    public NSGAIIBuilder<S> setSelectionOperator(SelectionOperator<List<S>, S> selectionOperator) {
        if (selectionOperator == null) {
            throw new JMetalException("selectionOperator is null");
        }
        this.selectionOperator = selectionOperator;
        return this;
    }

    public NSGAIIBuilder<S> setSolutionListEvaluator(SolutionListEvaluator<S> evaluator) {
        if (evaluator == null) {
            throw new JMetalException("evaluator is null");
        }
        this.evaluator = evaluator;
        return this;
    }

    public NSGAIIBuilder<S> setVariant(NSGAIIVariant variant) {
        this.variant = variant;
        return this;
    }

    public NSGAII<S> build() {
        NSGAII<S> algorithm = null;
        if (this.variant.equals((Object)NSGAIIVariant.NSGAII)) {
            algorithm = new NSGAII<S>(this.problem, this.maxEvaluations, this.populationSize, this.crossoverOperator, this.mutationOperator, this.selectionOperator, this.evaluator);
        } else if (this.variant.equals((Object)NSGAIIVariant.SteadyStateNSGAII)) {
            algorithm = new SteadyStateNSGAII<S>(this.problem, this.maxEvaluations, this.populationSize, this.crossoverOperator, this.mutationOperator, this.selectionOperator, this.evaluator);
        } else if (this.variant.equals((Object)NSGAIIVariant.Measures)) {
            algorithm = new NSGAIIMeasures<S>(this.problem, this.maxEvaluations, this.populationSize, this.crossoverOperator, this.mutationOperator, this.selectionOperator, this.evaluator);
        }
        return algorithm;
    }

    public Problem<S> getProblem() {
        return this.problem;
    }

    public int getMaxIterations() {
        return this.maxEvaluations;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public CrossoverOperator<S> getCrossoverOperator() {
        return this.crossoverOperator;
    }

    public MutationOperator<S> getMutationOperator() {
        return this.mutationOperator;
    }

    public SelectionOperator<List<S>, S> getSelectionOperator() {
        return this.selectionOperator;
    }

    public SolutionListEvaluator<S> getSolutionListEvaluator() {
        return this.evaluator;
    }

    public static enum NSGAIIVariant {
        NSGAII,
        SteadyStateNSGAII,
        Measures,
        NSGAII45;

    }
}

