/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.nsgaii;

import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.measure.Measurable;
import org.uma.jmetal.measure.MeasureManager;
import org.uma.jmetal.measure.PullMeasure;
import org.uma.jmetal.measure.PushMeasure;
import org.uma.jmetal.measure.impl.BasicMeasure;
import org.uma.jmetal.measure.impl.CountingMeasure;
import org.uma.jmetal.measure.impl.DurationMeasure;
import org.uma.jmetal.measure.impl.SimpleMeasureManager;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.qualityindicator.impl.hypervolume.PISAHypervolume;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.solutionattribute.impl.DominanceRanking;

public class NSGAIIMeasures<S extends Solution<?>>
extends NSGAII<S>
implements Measurable {
    protected CountingMeasure evaluations;
    protected DurationMeasure durationMeasure;
    protected SimpleMeasureManager measureManager;
    protected BasicMeasure<List<S>> solutionListMeasure;
    protected BasicMeasure<Integer> numberOfNonDominatedSolutionsInPopulation;
    protected BasicMeasure<Double> hypervolumeValue;
    protected Front referenceFront = new ArrayFront();

    public NSGAIIMeasures(Problem<S> problem, int maxIterations, int populationSize, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, SolutionListEvaluator<S> evaluator) {
        super(problem, maxIterations, populationSize, crossoverOperator, mutationOperator, selectionOperator, evaluator);
        this.initMeasures();
    }

    @Override
    protected void initProgress() {
        this.evaluations.reset((long)this.getMaxPopulationSize());
    }

    @Override
    protected void updateProgress() {
        this.evaluations.increment((long)this.getMaxPopulationSize());
        this.solutionListMeasure.push((Object)this.getPopulation());
        this.hypervolumeValue.push((Object)new PISAHypervolume(this.referenceFront).evaluate(this.getNonDominatedSolutions(this.getPopulation())));
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.evaluations.get() >= (long)this.maxEvaluations;
    }

    public void run() {
        this.durationMeasure.reset();
        this.durationMeasure.start();
        super.run();
        this.durationMeasure.stop();
    }

    private void initMeasures() {
        this.durationMeasure = new DurationMeasure();
        this.evaluations = new CountingMeasure(0L);
        this.numberOfNonDominatedSolutionsInPopulation = new BasicMeasure();
        this.solutionListMeasure = new BasicMeasure();
        this.hypervolumeValue = new BasicMeasure();
        this.measureManager = new SimpleMeasureManager();
        this.measureManager.setPullMeasure((Object)"currentExecutionTime", (PullMeasure)this.durationMeasure);
        this.measureManager.setPullMeasure((Object)"currentEvaluation", (PullMeasure)this.evaluations);
        this.measureManager.setPullMeasure((Object)"numberOfNonDominatedSolutionsInPopulation", this.numberOfNonDominatedSolutionsInPopulation);
        this.measureManager.setPushMeasure((Object)"currentPopulation", this.solutionListMeasure);
        this.measureManager.setPushMeasure((Object)"currentEvaluation", (PushMeasure)this.evaluations);
        this.measureManager.setPushMeasure((Object)"hypervolume", this.hypervolumeValue);
    }

    public MeasureManager getMeasureManager() {
        return this.measureManager;
    }

    @Override
    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        List<S> pop = super.replacement(population, offspringPopulation);
        DominanceRanking ranking = new DominanceRanking();
        ranking.computeRanking(population);
        this.numberOfNonDominatedSolutionsInPopulation.set((Object)ranking.getSubfront(0).size());
        return pop;
    }

    public CountingMeasure getEvaluations() {
        return this.evaluations;
    }

    @Override
    public String getName() {
        return "NSGAIIM";
    }

    @Override
    public String getDescription() {
        return "Nondominated Sorting Genetic Algorithm version II. Version using measures";
    }

    public void setReferenceFront(Front referenceFront) {
        this.referenceFront = referenceFront;
    }
}

