/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.paes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractEvolutionStrategy;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.archive.impl.AdaptiveGridArchive;
import org.uma.jmetal.util.comparator.DominanceComparator;

public class PAES<S extends Solution<?>>
extends AbstractEvolutionStrategy<S, List<S>> {
    protected int archiveSize;
    protected int maxEvaluations;
    protected int biSections;
    protected int evaluations;
    protected AdaptiveGridArchive<S> archive;
    protected Comparator<S> comparator;

    public PAES(Problem<S> problem, int archiveSize, int maxEvaluations, int biSections, MutationOperator<S> mutationOperator) {
        super(problem);
        this.setProblem(problem);
        this.archiveSize = archiveSize;
        this.maxEvaluations = maxEvaluations;
        this.biSections = biSections;
        this.mutationOperator = mutationOperator;
        this.archive = new AdaptiveGridArchive(archiveSize, biSections, problem.getNumberOfObjectives());
        this.comparator = new DominanceComparator();
    }

    public int getArchiveSize() {
        return this.archiveSize;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public int getBiSections() {
        return this.biSections;
    }

    public MutationOperator<S> getMutationOperator() {
        return this.mutationOperator;
    }

    protected void initProgress() {
        this.evaluations = 0;
    }

    protected void updateProgress() {
        ++this.evaluations;
    }

    protected boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    protected List<S> createInitialPopulation() {
        ArrayList<Object> solutionList = new ArrayList<Object>(1);
        solutionList.add(this.getProblem().createSolution());
        return solutionList;
    }

    protected List<S> evaluatePopulation(List<S> population) {
        this.getProblem().evaluate(population.get(0));
        return population;
    }

    protected List<S> selection(List<S> population) {
        return population;
    }

    protected List<S> reproduction(List<S> population) {
        Solution mutatedSolution = ((Solution)population.get(0)).copy();
        this.mutationOperator.execute((Object)mutatedSolution);
        ArrayList<Solution> mutationSolutionList = new ArrayList<Solution>(1);
        mutationSolutionList.add(mutatedSolution);
        return mutationSolutionList;
    }

    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        Solution mutatedSolution;
        Solution current = (Solution)population.get(0);
        int flag = this.comparator.compare(current, mutatedSolution = (Solution)offspringPopulation.get(0));
        if (flag == 1) {
            current = mutatedSolution.copy();
            this.archive.add(mutatedSolution);
        } else if (flag == 0 && this.archive.add(mutatedSolution)) {
            population.set(0, this.test(current, mutatedSolution, this.archive));
        }
        population.set(0, current);
        return population;
    }

    public List<S> getResult() {
        return this.archive.getSolutionList();
    }

    public S test(S solution, S mutatedSolution, AdaptiveGridArchive<S> archive) {
        int originalLocation = archive.getGrid().location(solution);
        int mutatedLocation = archive.getGrid().location(mutatedSolution);
        if (originalLocation == -1) {
            return (S)mutatedSolution.copy();
        }
        if (mutatedLocation == -1) {
            return (S)solution.copy();
        }
        if (archive.getGrid().getLocationDensity(mutatedLocation) < archive.getGrid().getLocationDensity(originalLocation)) {
            return (S)mutatedSolution.copy();
        }
        return (S)solution.copy();
    }

    public String getName() {
        return "PAES";
    }

    public String getDescription() {
        return "Pareto-Archived Evolution Strategy";
    }
}

