/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.smpso;

import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSO;
import org.uma.jmetal.measure.Measurable;
import org.uma.jmetal.measure.MeasureManager;
import org.uma.jmetal.measure.PullMeasure;
import org.uma.jmetal.measure.PushMeasure;
import org.uma.jmetal.measure.impl.BasicMeasure;
import org.uma.jmetal.measure.impl.CountingMeasure;
import org.uma.jmetal.measure.impl.DurationMeasure;
import org.uma.jmetal.measure.impl.SimpleMeasureManager;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;

public class SMPSOMeasures
extends SMPSO
implements Measurable {
    protected CountingMeasure iterations;
    protected DurationMeasure durationMeasure;
    protected SimpleMeasureManager measureManager;
    protected BasicMeasure<List<DoubleSolution>> solutionListMeasure;

    public SMPSOMeasures(DoubleProblem problem, int swarmSize, BoundedArchive<DoubleSolution> leaders, MutationOperator<DoubleSolution> mutationOperator, int maxIterations, double r1Min, double r1Max, double r2Min, double r2Max, double c1Min, double c1Max, double c2Min, double c2Max, double weightMin, double weightMax, double changeVelocity1, double changeVelocity2, SolutionListEvaluator<DoubleSolution> evaluator) {
        super(problem, swarmSize, leaders, mutationOperator, maxIterations, r1Min, r1Max, r2Min, r2Max, c1Min, c1Max, c2Min, c2Max, weightMin, weightMax, changeVelocity1, changeVelocity2, evaluator);
        this.initMeasures();
    }

    public void run() {
        this.durationMeasure.reset();
        this.durationMeasure.start();
        super.run();
        this.durationMeasure.stop();
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.iterations.get() >= (long)this.getMaxIterations();
    }

    @Override
    protected void initProgress() {
        this.iterations.reset(1L);
        this.updateLeadersDensityEstimator();
    }

    @Override
    protected void updateProgress() {
        this.iterations.increment(1L);
        this.updateLeadersDensityEstimator();
        this.solutionListMeasure.push(super.getResult());
    }

    public MeasureManager getMeasureManager() {
        return this.measureManager;
    }

    private void initMeasures() {
        this.durationMeasure = new DurationMeasure();
        this.iterations = new CountingMeasure(0L);
        this.solutionListMeasure = new BasicMeasure();
        this.measureManager = new SimpleMeasureManager();
        this.measureManager.setPullMeasure((Object)"currentExecutionTime", (PullMeasure)this.durationMeasure);
        this.measureManager.setPullMeasure((Object)"currentIteration", (PullMeasure)this.iterations);
        this.measureManager.setPushMeasure((Object)"currentPopulation", this.solutionListMeasure);
        this.measureManager.setPushMeasure((Object)"currentIteration", (PushMeasure)this.iterations);
    }

    @Override
    public String getName() {
        return "SMPSOMeasures";
    }

    @Override
    public String getDescription() {
        return "SMPSO. Version using measures";
    }
}

