/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.singleobjective.coralreefsoptimization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractCoralReefsOptimization;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.util.pseudorandom.impl.MersenneTwisterGenerator;

public class CoralReefsOptimization<S>
extends AbstractCoralReefsOptimization<S, List<S>> {
    private Problem<S> problem;
    private int maxEvaluations;
    private int evaluations;
    private MersenneTwisterGenerator random;
    private static final long serialVersionUID = 3013223456538143239L;

    public CoralReefsOptimization(Problem<S> problem, int maxEvaluations, Comparator<S> comparator, SelectionOperator<List<S>, S> selectionOperator, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, int n, int m, double rho, double fbs, double fa, double pd, int attemptsToSettle) {
        super(comparator, selectionOperator, crossoverOperator, mutationOperator, n, m, rho, fbs, fa, pd, attemptsToSettle);
        this.problem = problem;
        this.maxEvaluations = maxEvaluations;
        this.random = new MersenneTwisterGenerator();
    }

    protected void initProgress() {
        this.evaluations = 0;
    }

    protected void updateProgress() {
        ++this.evaluations;
    }

    protected boolean isStoppingConditionReached() {
        return this.evaluations == this.maxEvaluations;
    }

    protected List<S> createInitialPopulation() {
        ArrayList<Object> population = new ArrayList<Object>(this.getN() * this.getM());
        int quantity = (int)(this.getRho() * (double)this.getN() * (double)this.getM());
        for (int i = 0; i < quantity; ++i) {
            Object newIndividual = this.problem.createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    protected List<AbstractCoralReefsOptimization.Coordinate> generateCoordinates() {
        int popSize = this.getPopulationSize();
        MersenneTwisterGenerator random = new MersenneTwisterGenerator();
        ArrayList<AbstractCoralReefsOptimization.Coordinate> coordinates = new ArrayList<AbstractCoralReefsOptimization.Coordinate>(popSize);
        for (int i = 0; i < popSize; ++i) {
            coordinates.add(new AbstractCoralReefsOptimization.Coordinate(random.nextInt(0, this.getN() - 1), random.nextInt(0, this.getM() - 1)));
        }
        return coordinates;
    }

    protected List<S> evaluatePopulation(List<S> population) {
        for (int solution = 0; solution < population.size(); ++solution) {
            this.problem.evaluate(population.get(solution));
        }
        return population;
    }

    protected List<S> selectBroadcastSpawners(List<S> population) {
        int quantity = (int)(this.getFbs() * (double)population.size());
        if (quantity % 2 == 1) {
            --quantity;
        }
        ArrayList<Object> spawners = new ArrayList<Object>(quantity);
        for (int i = 0; i < quantity; ++i) {
            Object solution = this.selectionOperator.execute(population);
            spawners.add(solution);
        }
        return spawners;
    }

    protected List<S> sexualReproduction(List<S> broadcastSpawners) {
        ArrayList<Object> parents = new ArrayList<Object>(2);
        ArrayList larvae = new ArrayList(broadcastSpawners.size() / 2);
        while (broadcastSpawners.size() > 0) {
            parents.add(this.selectionOperator.execute(broadcastSpawners));
            parents.add(this.selectionOperator.execute(broadcastSpawners));
            broadcastSpawners.remove(parents.get(0));
            if (broadcastSpawners.contains(parents.get(1))) {
                broadcastSpawners.remove(parents.get(1));
            }
            larvae.add(((List)this.crossoverOperator.execute(parents)).get(0));
            parents.clear();
        }
        return larvae;
    }

    protected List<S> asexualReproduction(List<S> brooders) {
        int sz = brooders.size();
        ArrayList<Object> larvae = new ArrayList<Object>(sz);
        for (int i = 0; i < sz; ++i) {
            larvae.add(this.mutationOperator.execute(brooders.get(i)));
        }
        return larvae;
    }

    protected List<S> larvaeSettlementPhase(List<S> larvae, List<S> population, List<AbstractCoralReefsOptimization.Coordinate> coordinates) {
        int attempts = this.getAttemptsToSettle();
        block0: for (S larva : larvae) {
            for (int attempt = 0; attempt < attempts; ++attempt) {
                AbstractCoralReefsOptimization.Coordinate C = new AbstractCoralReefsOptimization.Coordinate(this.random.nextInt(0, this.getN() - 1), this.random.nextInt(0, this.getM() - 1));
                if (!coordinates.contains(C)) {
                    population.add(larva);
                    coordinates.add(C);
                    continue block0;
                }
                int index = coordinates.indexOf(C);
                if (this.comparator.compare(larva, population.get(index)) >= 0) continue;
                population.add(index, larva);
                population.remove(index + 1);
                continue block0;
            }
        }
        return population;
    }

    protected List<S> depredation(List<S> population, List<AbstractCoralReefsOptimization.Coordinate> coordinates) {
        int popSize = population.size();
        int quantity = (int)(this.getFd() * (double)popSize);
        quantity = popSize - quantity;
        for (int i = popSize - 1; i > quantity; --i) {
            double coin = this.random.nextDouble();
            if (!(coin < this.getPd())) continue;
            population.remove(population.size() - 1);
            coordinates.remove(population.size() - 1);
        }
        return population;
    }

    public List<S> getResult() {
        Collections.sort(this.getPopulation(), this.comparator);
        return this.getPopulation();
    }

    public String getName() {
        return "CRO";
    }

    public String getDescription() {
        return "Coral Reefs Optimizatoin";
    }
}

