/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.singleobjective.particleswarmoptimization;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractParticleSwarmOptimization;
import org.uma.jmetal.operator.Operator;
import org.uma.jmetal.operator.impl.selection.BestSolutionSelection;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.neighborhood.impl.AdaptiveRandomNeighborhood;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.solutionattribute.impl.GenericSolutionAttribute;

public class StandardPSO2007
extends AbstractParticleSwarmOptimization<DoubleSolution, DoubleSolution> {
    private DoubleProblem problem;
    private SolutionListEvaluator<DoubleSolution> evaluator;
    private Operator<List<DoubleSolution>, DoubleSolution> findBestSolution;
    private Comparator<DoubleSolution> fitnessComparator;
    private int swarmSize;
    private int maxIterations;
    private int iterations;
    private int numberOfParticlesToInform;
    private DoubleSolution[] localBest;
    private DoubleSolution[] neighborhoodBest;
    private double[][] speed;
    private AdaptiveRandomNeighborhood<DoubleSolution> neighborhood;
    private GenericSolutionAttribute<DoubleSolution, Integer> positionInSwarm;
    private double weight;
    private double c;
    private JMetalRandom randomGenerator = JMetalRandom.getInstance();
    private DoubleSolution bestFoundParticle;
    private int objectiveId;

    public StandardPSO2007(DoubleProblem problem, int objectiveId, int swarmSize, int maxIterations, int numberOfParticlesToInform, SolutionListEvaluator<DoubleSolution> evaluator) {
        this.problem = problem;
        this.swarmSize = swarmSize;
        this.maxIterations = maxIterations;
        this.numberOfParticlesToInform = numberOfParticlesToInform;
        this.evaluator = evaluator;
        this.objectiveId = objectiveId;
        this.weight = 1.0 / (2.0 * Math.log(2.0));
        this.c = 0.5 + Math.log(2.0);
        this.fitnessComparator = new ObjectiveComparator(objectiveId);
        this.findBestSolution = new BestSolutionSelection(this.fitnessComparator);
        this.localBest = new DoubleSolution[swarmSize];
        this.neighborhoodBest = new DoubleSolution[swarmSize];
        this.speed = new double[swarmSize][problem.getNumberOfVariables()];
        this.positionInSwarm = new GenericSolutionAttribute();
        this.bestFoundParticle = null;
        this.neighborhood = new AdaptiveRandomNeighborhood(swarmSize, this.numberOfParticlesToInform);
    }

    public StandardPSO2007(DoubleProblem problem, int swarmSize, int maxIterations, int numberOfParticlesToInform, SolutionListEvaluator<DoubleSolution> evaluator) {
        this(problem, 0, swarmSize, maxIterations, numberOfParticlesToInform, evaluator);
    }

    public void initProgress() {
        this.iterations = 1;
    }

    public void updateProgress() {
        ++this.iterations;
    }

    public boolean isStoppingConditionReached() {
        return this.iterations >= this.maxIterations;
    }

    public List<DoubleSolution> createInitialSwarm() {
        ArrayList<DoubleSolution> swarm = new ArrayList<DoubleSolution>(this.swarmSize);
        for (int i = 0; i < this.swarmSize; ++i) {
            DoubleSolution newSolution = (DoubleSolution)this.problem.createSolution();
            this.positionInSwarm.setAttribute((Solution)newSolution, (Object)i);
            swarm.add(newSolution);
        }
        return swarm;
    }

    public List<DoubleSolution> evaluateSwarm(List<DoubleSolution> swarm) {
        swarm = this.evaluator.evaluate(swarm, (Problem)this.problem);
        return swarm;
    }

    public void initializeLeader(List<DoubleSolution> swarm) {
        for (int i = 0; i < swarm.size(); ++i) {
            this.neighborhoodBest[i] = this.getNeighborBest(i);
        }
    }

    public void initializeParticlesMemory(List<DoubleSolution> swarm) {
        for (int i = 0; i < swarm.size(); ++i) {
            this.localBest[i] = (DoubleSolution)swarm.get(i).copy();
        }
    }

    public void initializeVelocity(List<DoubleSolution> swarm) {
        for (int i = 0; i < swarm.size(); ++i) {
            DoubleSolution particle = swarm.get(i);
            for (int j = 0; j < this.problem.getNumberOfVariables(); ++j) {
                this.speed[i][j] = (this.randomGenerator.nextDouble(particle.getLowerBound(j).doubleValue(), particle.getUpperBound(j).doubleValue()) - (Double)particle.getVariableValue(j)) / 2.0;
            }
        }
    }

    public void updateVelocity(List<DoubleSolution> swarm) {
        for (int i = 0; i < this.swarmSize; ++i) {
            int var;
            DoubleSolution particle = swarm.get(i);
            double r1 = this.randomGenerator.nextDouble(0.0, this.c);
            double r2 = this.randomGenerator.nextDouble(0.0, this.c);
            if (this.localBest[i] != this.neighborhoodBest[i]) {
                for (var = 0; var < particle.getNumberOfVariables(); ++var) {
                    this.speed[i][var] = this.weight * this.speed[i][var] + r1 * ((Double)this.localBest[i].getVariableValue(var) - (Double)particle.getVariableValue(var)) + r2 * ((Double)this.neighborhoodBest[i].getVariableValue(var) - (Double)particle.getVariableValue(var));
                }
                continue;
            }
            for (var = 0; var < particle.getNumberOfVariables(); ++var) {
                this.speed[i][var] = this.weight * this.speed[i][var] + r1 * ((Double)this.localBest[i].getVariableValue(var) - (Double)particle.getVariableValue(var));
            }
        }
    }

    public void updatePosition(List<DoubleSolution> swarm) {
        for (int i = 0; i < this.swarmSize; ++i) {
            DoubleSolution particle = swarm.get(i);
            for (int var = 0; var < particle.getNumberOfVariables(); ++var) {
                particle.setVariableValue(var, (Object)((Double)particle.getVariableValue(var) + this.speed[i][var]));
                if ((Double)particle.getVariableValue(var) < this.problem.getLowerBound(var)) {
                    particle.setVariableValue(var, (Object)this.problem.getLowerBound(var));
                    this.speed[i][var] = 0.0;
                }
                if (!((Double)particle.getVariableValue(var) > this.problem.getUpperBound(var))) continue;
                particle.setVariableValue(var, (Object)this.problem.getUpperBound(var));
                this.speed[i][var] = 0.0;
            }
        }
    }

    public void perturbation(List<DoubleSolution> swarm) {
    }

    public void updateLeaders(List<DoubleSolution> swarm) {
        for (int i = 0; i < swarm.size(); ++i) {
            this.neighborhoodBest[i] = this.getNeighborBest(i);
        }
        DoubleSolution bestSolution = (DoubleSolution)this.findBestSolution.execute(swarm);
        if (this.bestFoundParticle == null) {
            this.bestFoundParticle = bestSolution;
        } else {
            if (bestSolution.getObjective(this.objectiveId) == this.bestFoundParticle.getObjective(0)) {
                this.neighborhood.recompute();
            }
            if (bestSolution.getObjective(this.objectiveId) < this.bestFoundParticle.getObjective(0)) {
                this.bestFoundParticle = bestSolution;
            }
        }
    }

    public void updateParticlesMemory(List<DoubleSolution> swarm) {
        for (int i = 0; i < swarm.size(); ++i) {
            if (!(swarm.get(i).getObjective(this.objectiveId) < this.localBest[i].getObjective(0))) continue;
            this.localBest[i] = (DoubleSolution)swarm.get(i).copy();
        }
    }

    public DoubleSolution getResult() {
        return this.bestFoundParticle;
    }

    private DoubleSolution getNeighborBest(int i) {
        DoubleSolution bestLocalBestSolution = null;
        for (DoubleSolution solution : this.neighborhood.getNeighbors(this.getSwarm(), i)) {
            int solutionPositionInSwarm = (Integer)this.positionInSwarm.getAttribute((Solution)solution);
            if (bestLocalBestSolution != null && !(bestLocalBestSolution.getObjective(0) > this.localBest[solutionPositionInSwarm].getObjective(0))) continue;
            bestLocalBestSolution = this.localBest[solutionPositionInSwarm];
        }
        return bestLocalBestSolution;
    }

    public double[][] getSwarmSpeedMatrix() {
        return this.speed;
    }

    public DoubleSolution[] getLocalBest() {
        return this.localBest;
    }

    public String getName() {
        return "SPSO07";
    }

    public String getDescription() {
        return "Standard PSO 2007";
    }
}

