/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.experiment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.mocell.MOCellBuilder;
import org.uma.jmetal.algorithm.multiobjective.mochc.MOCHC;
import org.uma.jmetal.algorithm.multiobjective.mochc.MOCHCBuilder;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.spea2.SPEA2Builder;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.crossover.HUXCrossover;
import org.uma.jmetal.operator.impl.crossover.SinglePointCrossover;
import org.uma.jmetal.operator.impl.mutation.BitFlipMutation;
import org.uma.jmetal.operator.impl.selection.RandomSelection;
import org.uma.jmetal.operator.impl.selection.RankingAndCrowdingSelection;
import org.uma.jmetal.problem.BinaryProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.multiobjective.OneZeroMax;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT5;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.qualityindicator.impl.hypervolume.PISAHypervolume;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.ExperimentBuilder;
import org.uma.jmetal.util.experiment.component.ComputeQualityIndicators;
import org.uma.jmetal.util.experiment.component.ExecuteAlgorithms;
import org.uma.jmetal.util.experiment.component.GenerateBoxplotsWithR;
import org.uma.jmetal.util.experiment.component.GenerateFriedmanTestTables;
import org.uma.jmetal.util.experiment.component.GenerateLatexTablesWithStatistics;
import org.uma.jmetal.util.experiment.component.GenerateReferenceParetoFront;
import org.uma.jmetal.util.experiment.component.GenerateWilcoxonTestTablesWithR;
import org.uma.jmetal.util.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.util.experiment.util.ExperimentProblem;

public class BinaryProblemsStudy {
    private static final int INDEPENDENT_RUNS = 25;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new JMetalException("Needed arguments: experimentBaseDirectory");
        }
        String experimentBaseDirectory = args[0];
        ArrayList<ExperimentProblem<BinarySolution>> problemList = new ArrayList<ExperimentProblem<BinarySolution>>();
        problemList.add(new ExperimentProblem((Problem)new ZDT5()));
        problemList.add(new ExperimentProblem((Problem)new OneZeroMax(Integer.valueOf(512))));
        List<ExperimentAlgorithm<BinarySolution, List<BinarySolution>>> algorithmList = BinaryProblemsStudy.configureAlgorithmList(problemList);
        Experiment experiment = new ExperimentBuilder("BinaryProblemsStudy").setAlgorithmList(algorithmList).setProblemList(problemList).setExperimentBaseDirectory(experimentBaseDirectory).setOutputParetoFrontFileName("FUN").setOutputParetoSetFileName("VAR").setReferenceFrontDirectory(experimentBaseDirectory + "/BinaryProblemsStudy/referenceFronts").setIndicatorList(Arrays.asList(new Epsilon(), new Spread(), new GenerationalDistance(), new PISAHypervolume(), new InvertedGenerationalDistance(), new InvertedGenerationalDistancePlus())).setIndependentRuns(25).setNumberOfCores(8).build();
        new ExecuteAlgorithms(experiment).run();
        new GenerateReferenceParetoFront(experiment).run();
        new ComputeQualityIndicators(experiment).run();
        new GenerateLatexTablesWithStatistics(experiment).run();
        new GenerateWilcoxonTestTablesWithR(experiment).run();
        new GenerateFriedmanTestTables(experiment).run();
        new GenerateBoxplotsWithR(experiment).setRows(1).setColumns(2).setDisplayNotch().run();
    }

    static List<ExperimentAlgorithm<BinarySolution, List<BinarySolution>>> configureAlgorithmList(List<ExperimentProblem<BinarySolution>> problemList) {
        ArrayList<ExperimentAlgorithm<BinarySolution, List<BinarySolution>>> algorithms = new ArrayList<ExperimentAlgorithm<BinarySolution, List<BinarySolution>>>();
        for (int run = 0; run < 25; ++run) {
            NSGAII algorithm;
            int i;
            for (i = 0; i < problemList.size(); ++i) {
                algorithm = new NSGAIIBuilder(problemList.get(i).getProblem(), (CrossoverOperator)new SinglePointCrossover(1.0), (MutationOperator)new BitFlipMutation(1.0 / (double)((BinaryProblem)problemList.get(i).getProblem()).getNumberOfBits(0)), 100).setMaxEvaluations(25000).build();
                algorithms.add((ExperimentAlgorithm<BinarySolution, List<BinarySolution>>)new ExperimentAlgorithm((Algorithm)algorithm, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                algorithm = new SPEA2Builder(problemList.get(i).getProblem(), (CrossoverOperator)new SinglePointCrossover(1.0), (MutationOperator)new BitFlipMutation(1.0 / (double)((BinaryProblem)problemList.get(i).getProblem()).getNumberOfBits(0))).setMaxIterations(250).setPopulationSize(100).build();
                algorithms.add((ExperimentAlgorithm<BinarySolution, List<BinarySolution>>)new ExperimentAlgorithm((Algorithm)algorithm, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                algorithm = new MOCellBuilder(problemList.get(i).getProblem(), (CrossoverOperator)new SinglePointCrossover(1.0), (MutationOperator)new BitFlipMutation(1.0 / (double)((BinaryProblem)problemList.get(i).getProblem()).getNumberOfBits(0))).setMaxEvaluations(25000).setPopulationSize(100).build();
                algorithms.add((ExperimentAlgorithm<BinarySolution, List<BinarySolution>>)new ExperimentAlgorithm((Algorithm)algorithm, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                HUXCrossover crossoverOperator = new HUXCrossover(1.0);
                RandomSelection parentsSelection = new RandomSelection();
                RankingAndCrowdingSelection newGenerationSelection = new RankingAndCrowdingSelection(100);
                BitFlipMutation mutationOperator = new BitFlipMutation(0.35);
                MOCHC algorithm2 = new MOCHCBuilder((BinaryProblem)problemList.get(i).getProblem()).setInitialConvergenceCount(0.25).setConvergenceValue(3).setPreservedPopulation(0.05).setPopulationSize(100).setMaxEvaluations(25000).setCrossover((CrossoverOperator)crossoverOperator).setNewGenerationSelection((SelectionOperator)newGenerationSelection).setCataclysmicMutation((MutationOperator)mutationOperator).setParentSelection((SelectionOperator)parentsSelection).setEvaluator((SolutionListEvaluator)new SequentialSolutionListEvaluator()).build();
                algorithms.add((ExperimentAlgorithm<BinarySolution, List<BinarySolution>>)new ExperimentAlgorithm((Algorithm)algorithm2, problemList.get(i), run));
            }
        }
        return algorithms;
    }
}

