/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.experiment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.gde3.GDE3;
import org.uma.jmetal.algorithm.multiobjective.gde3.GDE3Builder;
import org.uma.jmetal.algorithm.multiobjective.mocell.MOCell;
import org.uma.jmetal.algorithm.multiobjective.mocell.MOCellBuilder;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSOBuilder;
import org.uma.jmetal.algorithm.multiobjective.spea2.SPEA2Builder;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.operator.impl.selection.DifferentialEvolutionSelection;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.multiobjective.Binh2;
import org.uma.jmetal.problem.multiobjective.ConstrEx;
import org.uma.jmetal.problem.multiobjective.Golinski;
import org.uma.jmetal.problem.multiobjective.Srinivas;
import org.uma.jmetal.problem.multiobjective.Tanaka;
import org.uma.jmetal.problem.multiobjective.Water;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.hypervolume.PISAHypervolume;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.ExperimentBuilder;
import org.uma.jmetal.util.experiment.component.ComputeQualityIndicators;
import org.uma.jmetal.util.experiment.component.ExecuteAlgorithms;
import org.uma.jmetal.util.experiment.component.GenerateBoxplotsWithR;
import org.uma.jmetal.util.experiment.component.GenerateFriedmanTestTables;
import org.uma.jmetal.util.experiment.component.GenerateLatexTablesWithStatistics;
import org.uma.jmetal.util.experiment.component.GenerateReferenceParetoSetAndFrontFromDoubleSolutions;
import org.uma.jmetal.util.experiment.component.GenerateWilcoxonTestTablesWithR;
import org.uma.jmetal.util.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.util.experiment.util.ExperimentProblem;

public class ConstraintProblemsStudy {
    private static final int INDEPENDENT_RUNS = 25;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new JMetalException("Needed arguments: experimentBaseDirectory");
        }
        String experimentBaseDirectory = args[0];
        ArrayList<ExperimentProblem<DoubleSolution>> problemList = new ArrayList<ExperimentProblem<DoubleSolution>>();
        problemList.add(new ExperimentProblem((Problem)new Binh2()));
        problemList.add(new ExperimentProblem((Problem)new ConstrEx()));
        problemList.add(new ExperimentProblem((Problem)new Golinski()));
        problemList.add(new ExperimentProblem((Problem)new Srinivas()));
        problemList.add(new ExperimentProblem((Problem)new Tanaka()));
        problemList.add(new ExperimentProblem((Problem)new Water()));
        List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithmList = ConstraintProblemsStudy.configureAlgorithmList(problemList);
        Experiment experiment = new ExperimentBuilder("ConstrainedProblemsStudy").setAlgorithmList(algorithmList).setProblemList(problemList).setExperimentBaseDirectory(experimentBaseDirectory).setOutputParetoFrontFileName("FUN").setOutputParetoSetFileName("VAR").setReferenceFrontDirectory(experimentBaseDirectory + "/ConstrainedProblemsStudy/referenceFronts").setIndicatorList(Arrays.asList(new Epsilon(), new PISAHypervolume(), new InvertedGenerationalDistancePlus())).setIndependentRuns(25).setNumberOfCores(8).build();
        new ExecuteAlgorithms(experiment).run();
        new GenerateReferenceParetoSetAndFrontFromDoubleSolutions(experiment).run();
        new ComputeQualityIndicators(experiment).run();
        new GenerateLatexTablesWithStatistics(experiment).run();
        new GenerateWilcoxonTestTablesWithR(experiment).run();
        new GenerateFriedmanTestTables(experiment).run();
        new GenerateBoxplotsWithR(experiment).setRows(3).setColumns(3).run();
    }

    static List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> configureAlgorithmList(List<ExperimentProblem<DoubleSolution>> problemList) {
        ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms = new ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>>();
        for (int run = 0; run < 25; ++run) {
            GDE3 algorithm;
            NSGAII algorithm2;
            int i;
            for (i = 0; i < problemList.size(); ++i) {
                algorithm2 = new NSGAIIBuilder(problemList.get(i).getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 20.0), (MutationOperator)new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables(), 20.0), 100).setMaxEvaluations(25000).build();
                algorithms.add((ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>)new ExperimentAlgorithm((Algorithm)algorithm2, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                algorithm2 = new SPEA2Builder(problemList.get(i).getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 10.0), (MutationOperator)new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables(), 20.0)).build();
                algorithms.add((ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>)new ExperimentAlgorithm((Algorithm)algorithm2, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                double mutationProbability = 1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables();
                double mutationDistributionIndex = 20.0;
                algorithm = new SMPSOBuilder((DoubleProblem)problemList.get(i).getProblem(), (BoundedArchive)new CrowdingDistanceArchive(100)).setMutation((MutationOperator)new PolynomialMutation(mutationProbability, mutationDistributionIndex)).setMaxIterations(250).setSwarmSize(100).setSolutionListEvaluator((SolutionListEvaluator)new SequentialSolutionListEvaluator()).build();
                algorithms.add((ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>)new ExperimentAlgorithm((Algorithm)algorithm, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                double cr = 0.5;
                double f = 0.5;
                algorithm = new GDE3Builder((DoubleProblem)problemList.get(i).getProblem()).setCrossover(new DifferentialEvolutionCrossover(cr, f, "rand/1/bin")).setSelection(new DifferentialEvolutionSelection()).setMaxEvaluations(25000).setPopulationSize(100).setSolutionSetEvaluator((SolutionListEvaluator)new SequentialSolutionListEvaluator()).build();
                algorithms.add((ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>)new ExperimentAlgorithm((Algorithm)algorithm, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                MOCell algorithm3 = new MOCellBuilder((Problem)((DoubleProblem)problemList.get(i).getProblem()), (CrossoverOperator)new SBXCrossover(1.0, 20.0), (MutationOperator)new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables(), 20.0)).setSelectionOperator((SelectionOperator)new BinaryTournamentSelection()).setMaxEvaluations(25000).setPopulationSize(100).setArchive((BoundedArchive)new CrowdingDistanceArchive(100)).build();
                algorithms.add((ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>)new ExperimentAlgorithm((Algorithm)algorithm3, problemList.get(i), run));
            }
        }
        return algorithms;
    }
}

