/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.experiment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSO;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSOBuilder;
import org.uma.jmetal.algorithm.multiobjective.spea2.SPEA2;
import org.uma.jmetal.algorithm.multiobjective.spea2.SPEA2Builder;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT1;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.qualityindicator.impl.hypervolume.PISAHypervolume;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.ExperimentBuilder;
import org.uma.jmetal.util.experiment.component.ComputeQualityIndicators;
import org.uma.jmetal.util.experiment.component.ExecuteAlgorithms;
import org.uma.jmetal.util.experiment.component.GenerateBoxplotsWithR;
import org.uma.jmetal.util.experiment.component.GenerateFriedmanTestTables;
import org.uma.jmetal.util.experiment.component.GenerateLatexTablesWithStatistics;
import org.uma.jmetal.util.experiment.component.GenerateWilcoxonTestTablesWithR;
import org.uma.jmetal.util.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.util.experiment.util.ExperimentProblem;

public class ZDTScalabilityIStudy {
    private static final int INDEPENDENT_RUNS = 25;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new JMetalException("Needed arguments: experimentBaseDirectory");
        }
        String experimentBaseDirectory = args[0];
        ArrayList<ExperimentProblem<DoubleSolution>> problemList = new ArrayList<ExperimentProblem<DoubleSolution>>();
        problemList.add(new ExperimentProblem((Problem)new ZDT1(Integer.valueOf(10)), "ZDT110"));
        problemList.add(new ExperimentProblem((Problem)new ZDT1(Integer.valueOf(20)), "ZDT120"));
        problemList.add(new ExperimentProblem((Problem)new ZDT1(Integer.valueOf(30)), "ZDT130"));
        problemList.add(new ExperimentProblem((Problem)new ZDT1(Integer.valueOf(40)), "ZDT140"));
        problemList.add(new ExperimentProblem((Problem)new ZDT1(Integer.valueOf(50)), "ZDT150"));
        List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithmList = ZDTScalabilityIStudy.configureAlgorithmList(problemList);
        Experiment experiment = new ExperimentBuilder("ZDTScalabilityStudy").setAlgorithmList(algorithmList).setProblemList(problemList).setExperimentBaseDirectory(experimentBaseDirectory).setOutputParetoFrontFileName("FUN").setOutputParetoSetFileName("VAR").setReferenceFrontDirectory("/pareto_fronts").setIndicatorList(Arrays.asList(new Epsilon(), new Spread(), new GenerationalDistance(), new PISAHypervolume(), new InvertedGenerationalDistance(), new InvertedGenerationalDistancePlus())).setIndependentRuns(25).setNumberOfCores(8).build();
        new ExecuteAlgorithms(experiment).run();
        new ComputeQualityIndicators(experiment).run();
        new GenerateLatexTablesWithStatistics(experiment).run();
        new GenerateWilcoxonTestTablesWithR(experiment).run();
        new GenerateFriedmanTestTables(experiment).run();
        new GenerateBoxplotsWithR(experiment).setRows(3).setColumns(3).run();
    }

    static List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> configureAlgorithmList(List<ExperimentProblem<DoubleSolution>> problemList) {
        ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms = new ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>>();
        for (int run = 0; run < 25; ++run) {
            int i;
            for (i = 0; i < problemList.size(); ++i) {
                double mutationProbability = 1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables();
                double mutationDistributionIndex = 20.0;
                SMPSO algorithm = new SMPSOBuilder((DoubleProblem)problemList.get(i).getProblem(), (BoundedArchive)new CrowdingDistanceArchive(100)).setMutation((MutationOperator)new PolynomialMutation(mutationProbability, mutationDistributionIndex)).setMaxIterations(250).setSwarmSize(100).setSolutionListEvaluator((SolutionListEvaluator)new SequentialSolutionListEvaluator()).build();
                algorithms.add((ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>)new ExperimentAlgorithm((Algorithm)algorithm, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                NSGAII algorithm = new NSGAIIBuilder(problemList.get(i).getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 20.0), (MutationOperator)new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables(), 20.0), 100).build();
                algorithms.add((ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>)new ExperimentAlgorithm((Algorithm)algorithm, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                SPEA2 algorithm = new SPEA2Builder(problemList.get(i).getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 10.0), (MutationOperator)new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables(), 20.0)).build();
                algorithms.add((ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>)new ExperimentAlgorithm((Algorithm)algorithm, problemList.get(i), run));
            }
        }
        return algorithms;
    }
}

