/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.experiment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.moead.AbstractMOEAD;
import org.uma.jmetal.algorithm.multiobjective.moead.MOEADBuilder;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSO;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSOBuilder;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT1;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT2;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT3;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT4;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT6;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.qualityindicator.impl.hypervolume.PISAHypervolume;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.ExperimentBuilder;
import org.uma.jmetal.util.experiment.component.ComputeQualityIndicators;
import org.uma.jmetal.util.experiment.component.ExecuteAlgorithms;
import org.uma.jmetal.util.experiment.component.GenerateBoxplotsWithR;
import org.uma.jmetal.util.experiment.component.GenerateFriedmanTestTables;
import org.uma.jmetal.util.experiment.component.GenerateLatexTablesWithStatistics;
import org.uma.jmetal.util.experiment.component.GenerateReferenceParetoSetAndFrontFromDoubleSolutions;
import org.uma.jmetal.util.experiment.component.GenerateWilcoxonTestTablesWithR;
import org.uma.jmetal.util.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.util.experiment.util.ExperimentProblem;

public class ZDTStudy2 {
    private static final int INDEPENDENT_RUNS = 25;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new JMetalException("Needed arguments: experimentBaseDirectory");
        }
        String experimentBaseDirectory = args[0];
        ArrayList<ExperimentProblem<DoubleSolution>> problemList = new ArrayList<ExperimentProblem<DoubleSolution>>();
        problemList.add(new ExperimentProblem((Problem)new ZDT1()));
        problemList.add(new ExperimentProblem((Problem)new ZDT2()));
        problemList.add(new ExperimentProblem((Problem)new ZDT3()));
        problemList.add(new ExperimentProblem((Problem)new ZDT4()));
        problemList.add(new ExperimentProblem((Problem)new ZDT6()));
        List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithmList = ZDTStudy2.configureAlgorithmList(problemList);
        ExperimentBuilder zdt2Study = new ExperimentBuilder("ZDTStudy2");
        zdt2Study.setAlgorithmList(algorithmList);
        zdt2Study.setProblemList(problemList);
        zdt2Study.setExperimentBaseDirectory(experimentBaseDirectory);
        zdt2Study.setOutputParetoFrontFileName("FUN");
        zdt2Study.setOutputParetoSetFileName("VAR");
        zdt2Study.setReferenceFrontDirectory(experimentBaseDirectory + "/ZDTStudy2/referenceFronts");
        zdt2Study.setIndicatorList(Arrays.asList(new Epsilon(), new Spread(), new GenerationalDistance(), new PISAHypervolume(), new InvertedGenerationalDistance(), new InvertedGenerationalDistancePlus()));
        zdt2Study.setIndependentRuns(25);
        zdt2Study.setNumberOfCores(8);
        Experiment experiment = zdt2Study.build();
        new ExecuteAlgorithms(experiment).run();
        new GenerateReferenceParetoSetAndFrontFromDoubleSolutions(experiment).run();
        new ComputeQualityIndicators(experiment).run();
        new GenerateLatexTablesWithStatistics(experiment).run();
        new GenerateWilcoxonTestTablesWithR(experiment).run();
        new GenerateFriedmanTestTables(experiment).run();
        new GenerateBoxplotsWithR(experiment).setRows(3).setColumns(3).setDisplayNotch().run();
    }

    static List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> configureAlgorithmList(List<ExperimentProblem<DoubleSolution>> problemList) {
        ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms = new ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>>();
        for (int run = 0; run < 25; ++run) {
            int i;
            for (i = 0; i < problemList.size(); ++i) {
                double mutationProbability = 1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables();
                double mutationDistributionIndex = 20.0;
                SMPSO algorithm = new SMPSOBuilder((DoubleProblem)problemList.get(i).getProblem(), (BoundedArchive)new CrowdingDistanceArchive(100)).setMutation((MutationOperator)new PolynomialMutation(mutationProbability, mutationDistributionIndex)).setMaxIterations(250).setSwarmSize(100).setSolutionListEvaluator((SolutionListEvaluator)new SequentialSolutionListEvaluator()).build();
                algorithms.add((ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>)new ExperimentAlgorithm((Algorithm)algorithm, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                NSGAII algorithm = new NSGAIIBuilder(problemList.get(i).getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 20.0), (MutationOperator)new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables(), 20.0), 100).build();
                algorithms.add((ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>)new ExperimentAlgorithm((Algorithm)algorithm, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                AbstractMOEAD algorithm = new MOEADBuilder(problemList.get(i).getProblem(), MOEADBuilder.Variant.MOEAD).setCrossover((CrossoverOperator)new DifferentialEvolutionCrossover(1.0, 0.5, "rand/1/bin")).setMutation((MutationOperator)new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables(), 20.0)).setMaxEvaluations(25000).setPopulationSize(100).setResultPopulationSize(100).setNeighborhoodSelectionProbability(0.9).setMaximumNumberOfReplacedSolutions(2).setNeighborSize(20).setFunctionType(AbstractMOEAD.FunctionType.TCHE).build();
                algorithms.add((ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>)new ExperimentAlgorithm((Algorithm)algorithm, problemList.get(i), run));
            }
        }
        return algorithms;
    }
}

