/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.cdg.AbstractCDG;
import org.uma.jmetal.algorithm.multiobjective.cdg.CDGBuilder;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.multiobjective.glt.GLT4;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;

public class CDGRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws FileNotFoundException, ClassNotFoundException {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "(none)";
        }
        System.out.println("Warning: the problem name is not used anymore and may be removed later.");
        System.out.println("Warning: current problem name: " + problemName);
        GLT4 problem = new GLT4(10);
        double cr = 1.0;
        double f = 0.5;
        DifferentialEvolutionCrossover crossover = new DifferentialEvolutionCrossover(cr, f, "rand/1/bin");
        AbstractCDG algorithm = new CDGBuilder((Problem)problem).setCrossover((CrossoverOperator)crossover).setMaxEvaluations(300000).setPopulationSize(300).setResultPopulationSize(300).setNeighborhoodSelectionProbability(0.9).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        CDGRunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            CDGRunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
    }
}

