/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.util.List;
import org.knowm.xchart.BitmapEncoder;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.dmopso.DMOPSO;
import org.uma.jmetal.algorithm.multiobjective.dmopso.DMOPSOMeasures;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.chartcontainer.ChartContainer;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.measure.MeasureListener;
import org.uma.jmetal.util.measure.MeasureManager;
import org.uma.jmetal.util.measure.impl.BasicMeasure;
import org.uma.jmetal.util.measure.impl.CountingMeasure;

public class DMOPSOMeasuresRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws Exception {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT4";
            referenceParetoFront = "jmetal-problem/src/test/resources/pareto_fronts/ZDT1.pf";
        }
        DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem((String)problemName);
        DMOPSOMeasures algorithm = new DMOPSOMeasures(problem, 100, 150, 0.0, 0.1, 0.0, 1.0, 1.5, 2.5, 1.5, 2.5, 0.1, 0.4, -1.0, -1.0, DMOPSO.FunctionType.TCHE, "MOEAD_Weights", 2);
        algorithm.setReferenceFront((Front)new ArrayFront(referenceParetoFront));
        MeasureManager measureManager = algorithm.getMeasureManager();
        BasicMeasure solutionListMeasure = (BasicMeasure)measureManager.getPushMeasure((Object)"currentPopulation");
        CountingMeasure iterationMeasure = (CountingMeasure)measureManager.getPushMeasure((Object)"currentEvaluation");
        BasicMeasure hypervolumeMeasure = (BasicMeasure)measureManager.getPushMeasure((Object)"hypervolume");
        BasicMeasure epsilonMeasure = (BasicMeasure)measureManager.getPushMeasure((Object)"epsilon");
        ChartContainer chart = new ChartContainer(algorithm.getName(), 200);
        chart.setFrontChart(0, 1, referenceParetoFront);
        chart.setVarChart(0, 1);
        chart.addIndicatorChart("Hypervolume");
        chart.addIndicatorChart("Epsilon");
        chart.initChart();
        solutionListMeasure.register((MeasureListener)new ChartListener(chart));
        iterationMeasure.register((MeasureListener)new IterationListener(chart));
        hypervolumeMeasure.register((MeasureListener)new IndicatorListener("Hypervolume", chart));
        epsilonMeasure.register((MeasureListener)new IndicatorListener("Epsilon", chart));
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm)algorithm).execute();
        chart.saveChart("./chart", BitmapEncoder.BitmapFormat.PNG);
        List population = algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        DMOPSOMeasuresRunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            DMOPSOMeasuresRunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
    }

    private static class IndicatorListener
    implements MeasureListener<Double> {
        ChartContainer chart;
        String indicator;

        public IndicatorListener(String indicator, ChartContainer chart) {
            this.chart = chart;
            this.indicator = indicator;
        }

        public synchronized void measureGenerated(Double value) {
            if (this.chart != null) {
                this.chart.updateIndicatorChart(this.indicator, value);
                this.chart.refreshCharts(0);
            }
        }
    }

    private static class IterationListener
    implements MeasureListener<Long> {
        ChartContainer chart;

        public IterationListener(ChartContainer chart) {
            this.chart = chart;
            this.chart.getFrontChart().setTitle("Iteration: 0");
        }

        public synchronized void measureGenerated(Long iteration) {
            if (this.chart != null) {
                this.chart.getFrontChart().setTitle("Iteration: " + iteration);
            }
        }
    }

    private static class ChartListener
    implements MeasureListener<List<DoubleSolution>> {
        private ChartContainer chart;
        private int iteration = 0;

        public ChartListener(ChartContainer chart) {
            this.chart = chart;
            this.chart.getFrontChart().setTitle("Iteration: " + this.iteration);
        }

        private void refreshChart(List<DoubleSolution> solutionList) {
            if (this.chart != null) {
                ++this.iteration;
                this.chart.getFrontChart().setTitle("Iteration: " + this.iteration);
                this.chart.updateFrontCharts(solutionList);
                this.chart.refreshCharts();
            }
        }

        public synchronized void measureGenerated(List<DoubleSolution> solutions) {
            this.refreshChart(solutions);
        }
    }
}

