/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.io.FileNotFoundException;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.DNSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.comparator.RankingAndDirScoreDistanceComparator;
import org.uma.jmetal.util.fileinput.VectorFileUtils;

public class DNSGAIIRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws FileNotFoundException {
        String referenceParetoFront = "jmetal-problem/src/test/resources/pareto_fronts/DTLZ2.3D.pf";
        String problemName = "org.uma.jmetal.problem.multiobjective.dtlz.DTLZ2";
        Problem problem = ProblemUtils.loadProblem((String)problemName);
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 30.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        BinaryTournamentSelection selection = new BinaryTournamentSelection((Comparator)new RankingAndDirScoreDistanceComparator());
        int populationSize = 300;
        NSGAII algorithm = new NSGAIIBuilder(problem, (CrossoverOperator)crossover, (MutationOperator)mutation, populationSize).setMaxEvaluations(300000).setVariant(NSGAIIBuilder.NSGAIIVariant.DNSGAII).setSelectionOperator((SelectionOperator)selection).build();
        double[][] referenceVectors = VectorFileUtils.readVectors((String)("MOEAD_Weights/W" + problem.getNumberOfObjectives() + "D_" + populationSize + ".dat"));
        ((DNSGAII)algorithm).setReferenceVectors(referenceVectors);
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        DNSGAIIRunner.printFinalSolutionSet((List)population);
        DNSGAIIRunner.printQualityIndicators((List)population, (String)referenceParetoFront);
    }
}

