/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.mochc.MOCHC;
import org.uma.jmetal.algorithm.multiobjective.mochc.MOCHCBuilder;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.crossover.HUXCrossover;
import org.uma.jmetal.operator.impl.mutation.BitFlipMutation;
import org.uma.jmetal.operator.impl.selection.RandomSelection;
import org.uma.jmetal.operator.impl.selection.RankingAndCrowdingSelection;
import org.uma.jmetal.problem.BinaryProblem;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class MOCHCRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws Exception {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT5";
            referenceParetoFront = "";
        }
        BinaryProblem problem = (BinaryProblem)ProblemUtils.loadProblem((String)problemName);
        HUXCrossover crossoverOperator = new HUXCrossover(1.0);
        RandomSelection parentsSelection = new RandomSelection();
        RankingAndCrowdingSelection newGenerationSelection = new RankingAndCrowdingSelection(100);
        BitFlipMutation mutationOperator = new BitFlipMutation(0.35);
        MOCHC algorithm = new MOCHCBuilder(problem).setInitialConvergenceCount(0.25).setConvergenceValue(3).setPreservedPopulation(0.05).setPopulationSize(100).setMaxEvaluations(25000).setCrossover((CrossoverOperator)crossoverOperator).setNewGenerationSelection((SelectionOperator)newGenerationSelection).setCataclysmicMutation((MutationOperator)mutationOperator).setParentSelection((SelectionOperator)parentsSelection).setEvaluator((SolutionListEvaluator)new SequentialSolutionListEvaluator()).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        MOCHCRunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            MOCHCRunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
    }
}

