/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.wasfga.WASFGA;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.crossover.PMXCrossover;
import org.uma.jmetal.operator.impl.mutation.PermutationSwapMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.multiobjective.MultiobjectiveTSP;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class WASFGARunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, IOException {
        MultiobjectiveTSP problem = new MultiobjectiveTSP("/tspInstances/kroA100.tsp", "/tspInstances/kroB100.tsp");
        PMXCrossover crossover = new PMXCrossover(0.9);
        double mutationProbability = 0.2;
        PermutationSwapMutation mutation = new PermutationSwapMutation(mutationProbability);
        BinaryTournamentSelection selection = new BinaryTournamentSelection((Comparator)new RankingAndCrowdingDistanceComparator());
        String referenceParetoFront = "";
        ArrayList<Double> referencePoint = null;
        problem = new MultiobjectiveTSP("/tspInstances/kroA100.tsp", "/tspInstances/kroB100.tsp");
        referencePoint = new ArrayList<Double>();
        referencePoint.add(0.0);
        referencePoint.add(0.0);
        double epsilon = 0.01;
        WASFGA algorithm = new WASFGA((Problem)problem, 100, 250, (CrossoverOperator)crossover, (MutationOperator)mutation, (SelectionOperator)selection, (SolutionListEvaluator)new SequentialSolutionListEvaluator(), epsilon, referencePoint);
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        WASFGARunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            WASFGARunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
    }
}

