/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.singleobjective;

import java.util.ArrayList;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.singleobjective.geneticalgorithm.GeneticAlgorithmBuilder;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.crossover.SinglePointCrossover;
import org.uma.jmetal.operator.impl.mutation.BitFlipMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.singleobjective.OneMax;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.MultithreadedSolutionListEvaluator;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class ParallelGenerationalGeneticAlgorithmRunner {
    private static final int DEFAULT_NUMBER_OF_CORES = 0;

    public static void main(String[] args) throws Exception {
        OneMax problem = new OneMax(Integer.valueOf(512));
        int numberOfCores = args.length == 1 ? Integer.valueOf(args[0]) : 0;
        SinglePointCrossover crossoverOperator = new SinglePointCrossover(0.9);
        BitFlipMutation mutationOperator = new BitFlipMutation(1.0 / (double)problem.getNumberOfBits(0));
        BinaryTournamentSelection selectionOperator = new BinaryTournamentSelection();
        GeneticAlgorithmBuilder builder = new GeneticAlgorithmBuilder((Problem)problem, (CrossoverOperator)crossoverOperator, (MutationOperator)mutationOperator).setPopulationSize(100).setMaxEvaluations(25000).setSelectionOperator((SelectionOperator)selectionOperator).setSolutionListEvaluator((SolutionListEvaluator)new MultithreadedSolutionListEvaluator(numberOfCores, (Problem)problem));
        Algorithm algorithm = builder.build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        builder.getEvaluator().shutdown();
        BinarySolution solution = (BinarySolution)algorithm.getResult();
        ArrayList<BinarySolution> population = new ArrayList<BinarySolution>(1);
        population.add(solution);
        long computingTime = algorithmRunner.getComputingTime();
        new SolutionListOutput(population).setSeparator("\t").setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
    }
}

