/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.utility;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.StoredSolutionsUtils;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class ExtractParetoDominatingSolutionsFromFile {
    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            throw new JMetalException("Wrong number of arguments: " + args.length + "\nThis program should be called with three arguments:\nThe first argument is the name of the file containing the input solutions.\nThe second argument is the name of the file containing the computed output.\nThe third argument is the number of objectives of the problem whose front is to be extracted.");
        }
        String inputFileName = args[0];
        String outputFileName = args[1];
        Integer numberOfObjectives = Integer.parseInt(args[2]);
        NonDominatedSolutionListArchive archive = new NonDominatedSolutionListArchive();
        if (!Files.isRegularFile(Paths.get(inputFileName, new String[0]), new LinkOption[0])) {
            throw new JMetalException("Error opening file " + inputFileName);
        }
        archive.addAll(StoredSolutionsUtils.readSolutionsFromFile((String)inputFileName, (int)numberOfObjectives));
        StoredSolutionsUtils.writeToOutput((NonDominatedSolutionListArchive)archive, (FileOutputContext)new DefaultFileOutputContext(outputFileName));
    }
}

