/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.workingTest;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.problem.singleobjective.Sphere;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;

public class PolynomialMutationWorkingTest {
    public static void main(String[] args) throws FileNotFoundException {
        if (args.length != 4) {
            throw new JMetalException("Usage: numberOfSolutions granularity distributionIndex outputFile");
        }
        int numberOfPoints = Integer.valueOf(args[0]);
        int granularity = Integer.valueOf(args[1]);
        double distributionIndex = Double.valueOf(args[2]);
        String outputFileName = args[3];
        Sphere problem = new Sphere(Integer.valueOf(1));
        PolynomialMutation mutation = new PolynomialMutation(1.0, distributionIndex);
        DoubleSolution solution = (DoubleSolution)problem.createSolution();
        solution.setVariableValue(0, (Object)0.0);
        ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(numberOfPoints);
        for (int i = 0; i < numberOfPoints; ++i) {
            DoubleSolution newSolution = (DoubleSolution)solution.copy();
            mutation.execute((Object)newSolution);
            population.add(newSolution);
        }
        Collections.sort(population, new VariableComparator());
        double[][] classifier = PolynomialMutationWorkingTest.classify(population, (DoubleProblem)problem, granularity);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outputFileName)));
        try {
            for (int i = 0; i < classifier.length; ++i) {
                bufferedWriter.write(classifier[i][0] + "\t" + classifier[i][1]);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException e) {
            throw new JMetalException("Error reading data ", (Exception)e);
        }
    }

    private static double[][] classify(List<DoubleSolution> solutions, DoubleProblem problem, int granularity) {
        double grain = ((Double)problem.getUpperBound(0) - (Double)problem.getLowerBound(0)) / (double)granularity;
        double[][] classifier = new double[granularity][];
        for (int i = 0; i < granularity; ++i) {
            classifier[i] = new double[2];
            classifier[i][0] = (Double)problem.getLowerBound(0) + (double)i * grain;
            classifier[i][1] = 0.0;
        }
        for (DoubleSolution solution : solutions) {
            boolean found = false;
            int index = 0;
            while (!found) {
                if ((Double)solution.getVariableValue(0) <= classifier[index][0]) {
                    double[] dArray = classifier[index];
                    dArray[1] = dArray[1] + 1.0;
                    found = true;
                    continue;
                }
                if (index == granularity - 1) {
                    double[] dArray = classifier[index];
                    dArray[1] = dArray[1] + 1.0;
                    found = true;
                    continue;
                }
                ++index;
            }
        }
        return classifier;
    }

    public static class VariableComparator
    implements Comparator<DoubleSolution> {
        @Override
        public int compare(DoubleSolution solution1, DoubleSolution solution2) {
            if (solution1 == null) {
                return 1;
            }
            if (solution2 == null) {
                return -1;
            }
            if ((Double)solution1.getVariableValue(0) < (Double)solution2.getVariableValue(0)) {
                return -1;
            }
            if ((Double)solution1.getVariableValue(0) > (Double)solution2.getVariableValue(0)) {
                return 1;
            }
            return 0;
        }
    }
}

