/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.mssqlserver;

import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.umlg.sqlg.mssqlserver.SQLServerBaseCacheBulkRecord;
import org.umlg.sqlg.structure.MetaEdge;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.RecordId;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgEdge;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.SqlgVertex;
import org.umlg.sqlg.structure.topology.EdgeLabel;
import org.umlg.sqlg.structure.topology.PropertyColumn;
import org.umlg.sqlg.structure.topology.Schema;
import org.umlg.sqlg.structure.topology.VertexLabel;

class SQLServerEdgeCacheBulkRecord
extends SQLServerBaseCacheBulkRecord
implements ISQLServerBulkRecord {
    private final Iterator<Map.Entry<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>> rowIter;
    private Triple<SqlgVertex, SqlgVertex, Map<String, Object>> currentRow;
    private final VertexLabel outVertexLabel;
    private final VertexLabel inVertexLabel;

    SQLServerEdgeCacheBulkRecord(SQLServerBulkCopy bulkCopy, SqlgGraph sqlgGraph, MetaEdge metaEdge, SchemaTable schemaTable, Pair<SortedSet<String>, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>> triples) throws SQLServerException {
        PropertyType propertyType;
        this.rowIter = ((Map)triples.getRight()).entrySet().iterator();
        SchemaTable outSchemaTable = SchemaTable.from((SqlgGraph)sqlgGraph, (String)metaEdge.getOutLabel());
        SchemaTable inSchemaTable = SchemaTable.from((SqlgGraph)sqlgGraph, (String)metaEdge.getInLabel());
        this.outVertexLabel = (VertexLabel)sqlgGraph.getTopology().getVertexLabel(outSchemaTable.getSchema(), outSchemaTable.getTable()).orElseThrow(() -> new IllegalStateException(String.format("VertexLabel not found for %s.%s", outSchemaTable.getSchema(), outSchemaTable.getTable())));
        this.inVertexLabel = (VertexLabel)sqlgGraph.getTopology().getVertexLabel(inSchemaTable.getSchema(), inSchemaTable.getTable()).orElseThrow(() -> new IllegalStateException(String.format("VertexLabel not found for %s.%s", inSchemaTable.getSchema(), inSchemaTable.getTable())));
        this.propertyColumns = ((EdgeLabel)((Schema)sqlgGraph.getTopology().getSchema(schemaTable.getSchema()).orElseThrow(() -> new IllegalStateException(String.format("Schema '%s' not found", schemaTable.getSchema())))).getEdgeLabel(schemaTable.getTable()).orElseThrow(() -> new IllegalStateException(String.format("EdgeLabel '%s' not found", schemaTable.getTable())))).getProperties();
        this.columns = (SortedSet)triples.getLeft();
        int i = this.addMetaData(bulkCopy, sqlgGraph);
        if (this.inVertexLabel.hasIDPrimaryKey()) {
            bulkCopy.addColumnMapping(i, metaEdge.getInLabel() + "__I");
            this.columnMetadata.put(i++, new SQLServerBaseCacheBulkRecord.ColumnMetadata(this, metaEdge.getInLabel() + "__I", sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(PropertyType.LONG)[0], 0, 0, null, PropertyType.LONG));
        } else {
            for (String identifier : this.inVertexLabel.getIdentifiers()) {
                bulkCopy.addColumnMapping(i, metaEdge.getInLabel() + "." + identifier + "__I");
                propertyType = ((PropertyColumn)this.inVertexLabel.getProperty(identifier).orElseThrow(() -> new IllegalStateException(String.format("BUG: Did not find the identifier property %s.", identifier)))).getPropertyType();
                this.columnMetadata.put(i++, new SQLServerBaseCacheBulkRecord.ColumnMetadata(this, metaEdge.getInLabel() + "." + identifier + "__I", sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(propertyType)[0], 0, 0, null, propertyType));
            }
        }
        if (this.outVertexLabel.hasIDPrimaryKey()) {
            bulkCopy.addColumnMapping(i, metaEdge.getOutLabel() + "__O");
            this.columnMetadata.put(i++, new SQLServerBaseCacheBulkRecord.ColumnMetadata(this, metaEdge.getOutLabel() + "__O", sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(PropertyType.LONG)[0], 0, 0, null, PropertyType.LONG));
        } else {
            for (String identifier : this.outVertexLabel.getIdentifiers()) {
                propertyType = ((PropertyColumn)this.outVertexLabel.getProperty(identifier).orElseThrow(() -> new IllegalStateException(String.format("BUG: Did not find the identifier property %s.", identifier)))).getPropertyType();
                bulkCopy.addColumnMapping(i, metaEdge.getOutLabel() + "." + identifier + "__O");
                this.columnMetadata.put(i++, new SQLServerBaseCacheBulkRecord.ColumnMetadata(this, metaEdge.getOutLabel() + "." + identifier + "__O", sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(propertyType)[0], 0, 0, null, propertyType));
            }
        }
    }

    @Override
    Object getValue(String column) {
        return ((Map)this.currentRow.getRight()).get(column);
    }

    public Object[] getRowData() {
        ArrayList<Object> values = new ArrayList<Object>();
        this.addValues(values);
        if (this.inVertexLabel.hasIDPrimaryKey()) {
            values.add(((RecordId)((SqlgVertex)this.currentRow.getMiddle()).id()).sequenceId());
        } else {
            for (Object identifier : ((RecordId)((SqlgVertex)this.currentRow.getMiddle()).id()).getIdentifiers()) {
                values.add(identifier);
            }
        }
        if (this.outVertexLabel.hasIDPrimaryKey()) {
            values.add(((RecordId)((SqlgVertex)this.currentRow.getLeft()).id()).sequenceId());
        } else {
            for (Object identifier : ((RecordId)((SqlgVertex)this.currentRow.getLeft()).id()).getIdentifiers()) {
                values.add(identifier);
            }
        }
        return values.toArray();
    }

    public boolean next() {
        if (this.rowIter.hasNext()) {
            Map.Entry<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>> entry = this.rowIter.next();
            this.currentRow = entry.getValue();
            return true;
        }
        return false;
    }
}

