/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.mssqlserver;

import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.lang3.tuple.Pair;
import org.umlg.sqlg.mssqlserver.SQLServerBaseCacheBulkRecord;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.SqlgVertex;
import org.umlg.sqlg.structure.topology.Schema;
import org.umlg.sqlg.structure.topology.VertexLabel;

class SQLServerVertexCacheBulkRecord
extends SQLServerBaseCacheBulkRecord
implements ISQLServerBulkRecord {
    private final Iterator<Map.Entry<SqlgVertex, Map<String, Object>>> rowIter;
    private Map<String, Object> currentRow;
    private final boolean dummy;

    SQLServerVertexCacheBulkRecord(SQLServerBulkCopy bulkCopy, SqlgGraph sqlgGraph, SchemaTable schemaTable, Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>> vertices) throws SQLServerException {
        this.rowIter = ((Map)vertices.getRight()).entrySet().iterator();
        if (!schemaTable.isTemporary()) {
            this.propertyColumns = ((VertexLabel)((Schema)sqlgGraph.getTopology().getSchema(schemaTable.getSchema()).orElseThrow(() -> new IllegalStateException(String.format("Schema %s not found", schemaTable.getSchema())))).getVertexLabel(schemaTable.getTable()).orElseThrow(() -> new IllegalStateException(String.format("VertexLabel %s not found", schemaTable.getTable())))).getProperties();
        } else {
            this.properties = sqlgGraph.getTopology().getPublicSchema().getTemporaryTable("V_" + schemaTable.getTable());
        }
        int i = 1;
        this.columns = (SortedSet)vertices.getLeft();
        this.dummy = this.columns.isEmpty();
        if (this.dummy) {
            bulkCopy.addColumnMapping(i, "dummy");
            this.columnMetadata.put(i, new SQLServerBaseCacheBulkRecord.ColumnMetadata(this, "dummy", sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(PropertyType.INTEGER)[0], 0, 0, null, PropertyType.INTEGER));
        } else {
            this.addMetaData(bulkCopy, sqlgGraph);
        }
    }

    public Object[] getRowData() {
        if (this.dummy) {
            return new Object[]{1};
        }
        ArrayList<Object> values = new ArrayList<Object>();
        this.addValues(values);
        return values.toArray();
    }

    @Override
    Object getValue(String column) {
        return this.currentRow.get(column);
    }

    public boolean next() {
        if (this.rowIter.hasNext()) {
            Map.Entry<SqlgVertex, Map<String, Object>> entry = this.rowIter.next();
            this.currentRow = entry.getValue();
            return true;
        }
        return false;
    }
}

