/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.mssqlserver;

import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.umlg.sqlg.mssqlserver.SQLServerBaseCacheBulkRecord;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.SqlgVertex;
import org.umlg.sqlg.structure.topology.PropertyColumn;

class SQLServerVertexGlobalUniqueIndexBulkRecord
extends SQLServerBaseCacheBulkRecord
implements ISQLServerBulkRecord {
    private final Iterator<Map.Entry<SqlgVertex, Map<String, Object>>> rowIter;
    private Map<String, Object> currentRow;
    private SqlgVertex currentVertex;
    private final PropertyColumn propertyColumn;

    SQLServerVertexGlobalUniqueIndexBulkRecord(SQLServerBulkCopy bulkCopy, SqlgGraph sqlgGraph, Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>> vertices, PropertyColumn propertyColumn) throws SQLServerException {
        this.rowIter = ((Map)vertices.getRight()).entrySet().iterator();
        this.propertyColumn = propertyColumn;
        bulkCopy.addColumnMapping(1, "value");
        this.columnMetadata.put(1, new SQLServerBaseCacheBulkRecord.ColumnMetadata(this, "value", sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(PropertyType.STRING)[0], 0, 0, null, PropertyType.STRING));
        bulkCopy.addColumnMapping(2, "recordId");
        this.columnMetadata.put(2, new SQLServerBaseCacheBulkRecord.ColumnMetadata(this, "recordId", sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(PropertyType.STRING)[0], 0, 0, null, PropertyType.STRING));
        bulkCopy.addColumnMapping(3, "property");
        this.columnMetadata.put(3, new SQLServerBaseCacheBulkRecord.ColumnMetadata(this, "property", sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(PropertyType.STRING)[0], 0, 0, null, PropertyType.STRING));
    }

    public Object[] getRowData() {
        ArrayList<Object> values = new ArrayList<Object>();
        Object value = this.currentRow.get(this.propertyColumn.getName());
        if (value == null) {
            value = "dummy_" + UUID.randomUUID().toString();
        }
        values.add(value);
        values.add(this.currentVertex.id().toString());
        values.add(this.propertyColumn.getName());
        return values.toArray();
    }

    @Override
    Object getValue(String column) {
        return this.currentRow.get(column);
    }

    public boolean next() {
        if (this.rowIter.hasNext()) {
            Map.Entry<SqlgVertex, Map<String, Object>> entry = this.rowIter.next();
            this.currentRow = entry.getValue();
            this.currentVertex = entry.getKey();
            return true;
        }
        return false;
    }
}

