/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.sql.dialect;

import com.fasterxml.jackson.databind.JsonNode;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.umlg.sqlg.sql.dialect.BaseSqlDialect;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgExceptions;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.util.SqlgUtil;

public class MysqlDialect
extends BaseSqlDialect {
    public int getMaximumSchemaNameLength() {
        return 63;
    }

    public int getMaximumTableNameLength() {
        return 63;
    }

    public int getMaximumColumnNameLength() {
        return 63;
    }

    public int getMaximumIndexNameLength() {
        return 63;
    }

    public boolean isMariaDb() {
        return true;
    }

    public boolean supportsValuesExpression() {
        return false;
    }

    public boolean supportsBatchMode() {
        return true;
    }

    public boolean supportsSchemas() {
        return false;
    }

    public String createSchemaStatement(String schemaName) {
        return "CREATE DATABASE IF NOT EXISTS " + this.maybeWrapInQoutes(schemaName) + " DEFAULT CHARACTER SET latin1 COLLATE latin1_general_cs";
    }

    public boolean needsTemporaryTableSchema() {
        return true;
    }

    public boolean supportsTemporaryTableOnCommitDrop() {
        return false;
    }

    public String sqlInsertEmptyValues() {
        return " VALUES ()";
    }

    public List<Triple<String, String, String>> getVertexTables(DatabaseMetaData metaData) {
        ArrayList<Triple<String, String, String>> vertexTables = new ArrayList<Triple<String, String, String>>();
        String[] types = new String[]{"TABLE"};
        try (ResultSet vertexRs = metaData.getTables(null, null, "V_%", types);){
            while (vertexRs.next()) {
                Object tblCat = null;
                String schema = vertexRs.getString(1);
                String table = vertexRs.getString(3);
                if (!table.startsWith("V_")) continue;
                vertexTables.add((Triple<String, String, String>)Triple.of(tblCat, (Object)schema, (Object)table));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return vertexTables;
    }

    public List<Triple<String, String, String>> getEdgeTables(DatabaseMetaData metaData) {
        ArrayList<Triple<String, String, String>> edgeTables = new ArrayList<Triple<String, String, String>>();
        String[] types = new String[]{"TABLE"};
        try (ResultSet edgeRs = metaData.getTables(null, null, "E_%", types);){
            while (edgeRs.next()) {
                Object edgCat = null;
                String schema = edgeRs.getString(1);
                String table = edgeRs.getString(3);
                if (!table.startsWith("E_")) continue;
                edgeTables.add((Triple<String, String, String>)Triple.of(edgCat, (Object)schema, (Object)table));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return edgeTables;
    }

    public List<Triple<String, Integer, String>> getTableColumns(DatabaseMetaData metaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        ArrayList<Triple<String, Integer, String>> columns = new ArrayList<Triple<String, Integer, String>>();
        try (ResultSet rs = metaData.getColumns(schemaPattern, schemaPattern, tableNamePattern, columnNamePattern);){
            while (rs.next()) {
                String columnName = rs.getString(4);
                int columnType = rs.getInt(5);
                String typeName = rs.getString("TYPE_NAME");
                columns.add((Triple<String, Integer, String>)Triple.of((Object)columnName, (Object)columnType, (Object)typeName));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return columns;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Triple<String, Boolean, String>> getIndexInfo(DatabaseMetaData metaData, String catalog, String schema, String table, boolean unique, boolean approximate) {
        ArrayList<Triple<String, Boolean, String>> indexes = new ArrayList<Triple<String, Boolean, String>>();
        try (ResultSet indexRs = metaData.getIndexInfo(schema, schema, table, false, true);){
            while (indexRs.next()) {
                String indexName = indexRs.getString("INDEX_NAME");
                boolean nonUnique = indexRs.getBoolean("NON_UNIQUE");
                String columnName = indexRs.getString("COLUMN_NAME");
                indexes.add((Triple<String, Boolean, String>)Triple.of((Object)indexName, (Object)nonUnique, (Object)columnName));
            }
            ArrayList<Triple<String, Boolean, String>> arrayList = indexes;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getSchemaNames(DatabaseMetaData metaData) {
        ArrayList<String> schemaNames = new ArrayList<String>();
        try (ResultSet schemaRs = metaData.getCatalogs();){
            while (schemaRs.next()) {
                String schema = schemaRs.getString(1);
                if (this.getInternalSchemas().contains(schema)) continue;
                schemaNames.add(schema);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return schemaNames;
    }

    public boolean schemaExists(DatabaseMetaData metadata, String schema) throws SQLException {
        ResultSet schemaRs = metadata.getCatalogs();
        while (schemaRs.next()) {
            String db = schemaRs.getString(1);
            if (!db.equals(schema)) continue;
            return true;
        }
        return false;
    }

    public String maybeWrapInQoutes(String field) {
        return this.getColumnEscapeKey() + field.replace(this.getColumnEscapeKey(), "\"" + this.getColumnEscapeKey()) + this.getColumnEscapeKey();
    }

    public String dialectName() {
        return "MysqlDialect";
    }

    public Set<String> getInternalSchemas() {
        return new HashSet<String>(Arrays.asList("information_schema", "performance_schema", "mysql", "test"));
    }

    public boolean supportsCascade() {
        return false;
    }

    public String getPublicSchema() {
        return "PUBLIC";
    }

    public String existIndexQuery(SchemaTable schemaTable, String prefix, String indexName) {
        StringBuilder sb = new StringBuilder("SELECT * FROM INFORMATION_SCHEMA.SYSTEM_INDEXINFO WHERE TABLE_SCHEM = '");
        sb.append(schemaTable.getSchema());
        sb.append("' AND  TABLE_NAME = '");
        sb.append(prefix);
        sb.append(schemaTable.getTable());
        sb.append("' AND INDEX_NAME = '");
        sb.append(indexName);
        sb.append("'");
        return sb.toString();
    }

    public boolean supportsTransactionalSchema() {
        return false;
    }

    public void validateProperty(Object key, Object value) {
        if (value instanceof String) {
            return;
        }
        if (value instanceof Character) {
            return;
        }
        if (value instanceof Boolean) {
            return;
        }
        if (value instanceof Byte) {
            return;
        }
        if (value instanceof Short) {
            return;
        }
        if (value instanceof Integer) {
            return;
        }
        if (value instanceof Long) {
            return;
        }
        if (value instanceof Double) {
            return;
        }
        if (value instanceof LocalDate) {
            return;
        }
        if (value instanceof LocalDateTime) {
            return;
        }
        if (value instanceof ZonedDateTime) {
            return;
        }
        if (value instanceof LocalTime) {
            return;
        }
        if (value instanceof Period) {
            return;
        }
        if (value instanceof Duration) {
            return;
        }
        if (value instanceof JsonNode) {
            return;
        }
        if (value instanceof byte[]) {
            return;
        }
        if (value instanceof boolean[]) {
            return;
        }
        if (value instanceof char[]) {
            return;
        }
        if (value instanceof short[]) {
            return;
        }
        if (value instanceof int[]) {
            return;
        }
        if (value instanceof long[]) {
            return;
        }
        if (value instanceof double[]) {
            return;
        }
        if (value instanceof String[]) {
            return;
        }
        if (value instanceof Character[]) {
            return;
        }
        if (value instanceof Boolean[]) {
            return;
        }
        if (value instanceof Byte[]) {
            return;
        }
        if (value instanceof Short[]) {
            return;
        }
        if (value instanceof Integer[]) {
            return;
        }
        if (value instanceof Long[]) {
            return;
        }
        if (value instanceof Double[]) {
            return;
        }
        if (value instanceof LocalDateTime[]) {
            return;
        }
        if (value instanceof LocalDate[]) {
            return;
        }
        if (value instanceof LocalTime[]) {
            return;
        }
        if (value instanceof ZonedDateTime[]) {
            return;
        }
        if (value instanceof Duration[]) {
            return;
        }
        if (value instanceof Period[]) {
            return;
        }
        if (value instanceof JsonNode[]) {
            return;
        }
        throw Property.Exceptions.dataTypeOfPropertyValueNotSupported((Object)value);
    }

    public String getColumnEscapeKey() {
        return "`";
    }

    public String getPrimaryKeyType() {
        return "BIGINT NOT NULL PRIMARY KEY";
    }

    public String getAutoIncrementPrimaryKeyConstruct() {
        return "SERIAL PRIMARY KEY";
    }

    public String[] propertyTypeToSqlDefinition(PropertyType propertyType) {
        switch (propertyType.ordinal()) {
            case 0: {
                return new String[]{"BOOLEAN"};
            }
            case 1: {
                return new String[]{"TINYINT"};
            }
            case 2: {
                return new String[]{"SMALLINT"};
            }
            case 3: {
                return new String[]{"INTEGER"};
            }
            case 4: {
                return new String[]{"BIGINT"};
            }
            case 6: {
                return new String[]{"DOUBLE"};
            }
            case 8: {
                return new String[]{"DATE"};
            }
            case 9: {
                return new String[]{"DATETIME(3)"};
            }
            case 11: {
                return new String[]{"DATETIME(3)", "TINYTEXT"};
            }
            case 10: {
                return new String[]{"TIME"};
            }
            case 12: {
                return new String[]{"INTEGER", "INTEGER", "INTEGER"};
            }
            case 13: {
                return new String[]{"BIGINT", "INTEGER"};
            }
            case 7: {
                return new String[]{"LONGTEXT"};
            }
            case 14: {
                return new String[]{"LONGTEXT"};
            }
            case 15: {
                throw new IllegalStateException("Mysql does not support gis types!");
            }
            case 17: {
                throw new IllegalStateException("Mysql does not support gis types!");
            }
            case 18: {
                throw new IllegalStateException("Mysql does not support gis types!");
            }
            case 19: {
                throw new IllegalStateException("Mysql does not support gis types!");
            }
            case 23: {
                return new String[]{"BLOB"};
            }
            case 22: {
                return new String[]{"BLOB"};
            }
            case 20: {
                return new String[]{"BOOLEAN ARRAY DEFAULT ARRAY[]"};
            }
        }
        throw SqlgExceptions.invalidPropertyType((PropertyType)propertyType);
    }

    public int[] propertyTypeToJavaSqlType(PropertyType propertyType) {
        switch (propertyType.ordinal()) {
            case 0: {
                return new int[]{16};
            }
            case 1: {
                return new int[]{-6};
            }
            case 2: {
                return new int[]{5};
            }
            case 3: {
                return new int[]{4};
            }
            case 4: {
                return new int[]{-5};
            }
            case 6: {
                return new int[]{8};
            }
            case 7: {
                return new int[]{2005};
            }
            case 9: {
                return new int[]{93};
            }
            case 8: {
                return new int[]{91};
            }
            case 10: {
                return new int[]{92};
            }
            case 11: {
                return new int[]{93, 2005};
            }
            case 12: {
                return new int[]{4, 4, 4};
            }
            case 13: {
                return new int[]{-5, 4};
            }
            case 14: {
                return new int[]{1111};
            }
            case 22: {
                return new int[]{2003};
            }
            case 23: {
                return new int[]{2003};
            }
        }
        throw new IllegalStateException("Unknown propertyType " + propertyType.name());
    }

    public PropertyType sqlTypeToPropertyType(SqlgGraph sqlgGraph, String schema, String table, String column, int sqlType, String typeName, ListIterator<Triple<String, Integer, String>> metaDataIter) {
        switch (sqlType) {
            case 16: {
                return PropertyType.BOOLEAN;
            }
            case 5: {
                return PropertyType.SHORT;
            }
            case 4: {
                return PropertyType.INTEGER;
            }
            case -5: {
                return PropertyType.LONG;
            }
            case 7: {
                return PropertyType.FLOAT;
            }
            case 8: {
                return PropertyType.DOUBLE;
            }
            case -1: {
                return PropertyType.STRING;
            }
            case 93: {
                return PropertyType.LOCALDATETIME;
            }
            case 91: {
                return PropertyType.LOCALDATE;
            }
            case 92: {
                return PropertyType.LOCALTIME;
            }
            case -3: {
                return PropertyType.BYTE_ARRAY;
            }
            case 2003: {
                return this.sqlArrayTypeNameToPropertyType(typeName, sqlgGraph, schema, table, column, metaDataIter);
            }
        }
        throw new IllegalStateException("Unknown sqlType " + sqlType);
    }

    public PropertyType sqlArrayTypeNameToPropertyType(String typeName, SqlgGraph sqlgGraph, String schema, String table, String columnName, ListIterator<Triple<String, Integer, String>> metaDataIter) {
        switch (typeName) {
            case "BOOLEAN ARRAY": {
                return PropertyType.BOOLEAN_ARRAY;
            }
            case "SMALLINT ARRAY": {
                return PropertyType.SHORT_ARRAY;
            }
            case "INTEGER ARRAY": {
                return PropertyType.INTEGER_ARRAY;
            }
            case "BIGINT ARRAY": {
                return PropertyType.LONG_ARRAY;
            }
            case "DOUBLE ARRAY": {
                return PropertyType.DOUBLE_ARRAY;
            }
            case "DATE ARRAY": {
                return PropertyType.LOCALDATE_ARRAY;
            }
            case "TIME WITH TIME ZONE ARRAY": {
                return PropertyType.LOCALTIME_ARRAY;
            }
            case "TIMESTAMP WITH TIME ZONE ARRAY": {
                Triple<String, Integer, String> metaData = metaDataIter.next();
                metaDataIter.previous();
                if (((String)metaData.getLeft()).startsWith(columnName + "~~~")) {
                    return PropertyType.ZONEDDATETIME_ARRAY;
                }
                return PropertyType.LOCALDATETIME_ARRAY;
            }
        }
        if (typeName.contains("VARCHAR") && typeName.contains("ARRAY")) {
            return PropertyType.STRING_ARRAY;
        }
        throw new RuntimeException(String.format("Array type not supported typeName = %s", typeName));
    }

    public String getForeignKeyTypeDefinition() {
        return "BIGINT UNSIGNED";
    }

    public String getArrayDriverType(PropertyType propertyType) {
        switch (propertyType.ordinal()) {
            case 20: {
                return "BOOLEAN";
            }
            case 21: {
                return "BOOLEAN";
            }
            case 25: {
                return "SMALLINT";
            }
            case 24: {
                return "SMALLINT";
            }
            case 27: {
                return "INTEGER";
            }
            case 26: {
                return "INTEGER";
            }
            case 29: {
                return "BIGINT";
            }
            case 28: {
                return "BIGINT";
            }
            case 33: {
                return "DOUBLE";
            }
            case 32: {
                return "DOUBLE";
            }
            case 34: {
                return "VARCHAR";
            }
            case 35: {
                return "TIMESTAMP";
            }
            case 36: {
                return "DATE";
            }
            case 37: {
                return "TIME";
            }
        }
        throw new IllegalStateException("propertyType " + propertyType.name() + " unknown!");
    }

    public String createTableStatement() {
        return "CREATE TABLE ";
    }

    public void validateColumnName(String column) {
        super.validateColumnName(column);
    }

    public Set<String> getSpacialRefTable() {
        return Collections.emptySet();
    }

    public List<String> getGisSchemas() {
        return Collections.emptyList();
    }

    public void lockTable(SqlgGraph sqlgGraph, SchemaTable schemaTable, String prefix) {
        throw new UnsupportedOperationException("Mysql does not support table locking!");
    }

    public void alterSequenceCacheSize(SqlgGraph sqlgGraph, SchemaTable schemaTable, String sequence, int batchSize) {
        throw new UnsupportedOperationException("Mysql does not support alterSequenceCacheSize!");
    }

    public long nextSequenceVal(SqlgGraph sqlgGraph, SchemaTable schemaTable, String prefix) {
        throw new UnsupportedOperationException("Mysql does not support nextSequenceVal!");
    }

    public long currSequenceVal(SqlgGraph sqlgGraph, SchemaTable schemaTable, String prefix) {
        throw new UnsupportedOperationException("Mysql does not support currSequenceVal!");
    }

    public String sequenceName(SqlgGraph sqlgGraph, SchemaTable outSchemaTable, String prefix) {
        throw new UnsupportedOperationException("Mysql does not support sequenceName!");
    }

    public boolean supportsBulkWithinOut() {
        return false;
    }

    public String createTemporaryTableStatement() {
        return "CREATE TEMPORARY TABLE " + this.maybeWrapInQoutes(this.getPublicSchema()) + ".";
    }

    public String afterCreateTemporaryTableStatement() {
        return "";
    }

    public List<String> sqlgTopologyCreationScripts() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`V_graph` (`ID` SERIAL PRIMARY KEY, `createdOn` DATETIME, `updatedOn` DATETIME, `version` TEXT);");
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`V_schema` (`ID` SERIAL PRIMARY KEY, `createdOn` DATETIME, `name` TEXT);");
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`V_vertex` (`ID` SERIAL PRIMARY KEY, `createdOn` DATETIME, `name` TEXT, `schemaVertex` TEXT);");
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`V_edge` (`ID` SERIAL PRIMARY KEY, `createdOn` DATETIME, `name` TEXT);");
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`V_property` (`ID` SERIAL PRIMARY KEY, `createdOn` DATETIME, `name` TEXT, `type` TEXT);");
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`V_index` (`ID` SERIAL PRIMARY KEY, `createdOn` DATETIME, `name` TEXT, `index_type` TEXT);");
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`V_globalUniqueIndex` (`ID` SERIAL PRIMARY KEY, `createdOn` DATETIME, `name` TEXT);");
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`E_schema_vertex`(`ID` SERIAL PRIMARY KEY, `sqlg_schema.vertex__I` BIGINT UNSIGNED, `sqlg_schema.schema__O` BIGINT UNSIGNED, FOREIGN KEY (`sqlg_schema.vertex__I`) REFERENCES `sqlg_schema`.`V_vertex` (`ID`), FOREIGN KEY (`sqlg_schema.schema__O`) REFERENCES `sqlg_schema`.`V_schema` (`ID`));");
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`E_in_edges`(`ID` SERIAL PRIMARY KEY, `sqlg_schema.edge__I` BIGINT UNSIGNED, `sqlg_schema.vertex__O` BIGINT UNSIGNED, FOREIGN KEY (`sqlg_schema.edge__I`) REFERENCES `sqlg_schema`.`V_edge` (`ID`), FOREIGN KEY (`sqlg_schema.vertex__O`) REFERENCES `sqlg_schema`.`V_vertex` (`ID`));");
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`E_out_edges`(`ID` SERIAL PRIMARY KEY, `sqlg_schema.edge__I` BIGINT UNSIGNED, `sqlg_schema.vertex__O` BIGINT UNSIGNED, FOREIGN KEY (`sqlg_schema.edge__I`) REFERENCES `sqlg_schema`.`V_edge` (`ID`), FOREIGN KEY (`sqlg_schema.vertex__O`) REFERENCES `sqlg_schema`.`V_vertex` (`ID`));");
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`E_vertex_property`(`ID` SERIAL PRIMARY KEY, `sqlg_schema.property__I` BIGINT UNSIGNED, `sqlg_schema.vertex__O` BIGINT UNSIGNED, FOREIGN KEY (`sqlg_schema.property__I`) REFERENCES `sqlg_schema`.`V_property` (`ID`), FOREIGN KEY (`sqlg_schema.vertex__O`) REFERENCES `sqlg_schema`.`V_vertex` (`ID`));");
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`E_edge_property`(`ID` SERIAL PRIMARY KEY, `sqlg_schema.property__I` BIGINT UNSIGNED, `sqlg_schema.edge__O` BIGINT UNSIGNED, FOREIGN KEY (`sqlg_schema.property__I`) REFERENCES `sqlg_schema`.`V_property` (`ID`), FOREIGN KEY (`sqlg_schema.edge__O`) REFERENCES `sqlg_schema`.`V_edge` (`ID`));");
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`E_vertex_index`(`ID` SERIAL PRIMARY KEY, `sqlg_schema.index__I` BIGINT UNSIGNED, `sqlg_schema.vertex__O` BIGINT UNSIGNED, FOREIGN KEY (`sqlg_schema.index__I`) REFERENCES `sqlg_schema`.`V_index` (`ID`), FOREIGN KEY (`sqlg_schema.vertex__O`) REFERENCES `sqlg_schema`.`V_vertex` (`ID`));");
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`E_edge_index`(`ID` SERIAL PRIMARY KEY, `sqlg_schema.index__I` BIGINT UNSIGNED, `sqlg_schema.edge__O` BIGINT UNSIGNED, FOREIGN KEY (`sqlg_schema.index__I`) REFERENCES `sqlg_schema`.`V_index` (`ID`), FOREIGN KEY (`sqlg_schema.edge__O`) REFERENCES `sqlg_schema`.`V_edge` (`ID`));");
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`E_index_property`(`ID` SERIAL PRIMARY KEY, `sqlg_schema.property__I` BIGINT UNSIGNED, `sqlg_schema.index__O` BIGINT UNSIGNED, `sequence` INTEGER, FOREIGN KEY (`sqlg_schema.property__I`) REFERENCES `sqlg_schema`.`V_property` (`ID`), FOREIGN KEY (`sqlg_schema.index__O`) REFERENCES `sqlg_schema`.`V_index` (`ID`));");
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`E_globalUniqueIndex_property`(`ID` SERIAL PRIMARY KEY, `sqlg_schema.property__I` BIGINT UNSIGNED, `sqlg_schema.globalUniqueIndex__O` BIGINT UNSIGNED, FOREIGN KEY (`sqlg_schema.property__I`) REFERENCES `sqlg_schema`.`V_property` (`ID`), FOREIGN KEY (`sqlg_schema.globalUniqueIndex__O`) REFERENCES `sqlg_schema`.`V_globalUniqueIndex` (`ID`));");
        result.add("CREATE TABLE IF NOT EXISTS `sqlg_schema`.`V_log`(`ID` SERIAL PRIMARY KEY, `timestamp` DATETIME, `pid` INTEGER, `log` TEXT);");
        return result;
    }

    public String sqlgCreateTopologyGraph() {
        return "CREATE TABLE IF NOT EXISTS `sqlg_schema`.`V_graph` (`ID` SERIAL PRIMARY KEY, `createdOn` DATETIME, `updatedOn` DATETIME, `version` TEXT);";
    }

    public String sqlgAddIndexEdgeSequenceColumn() {
        return "ALTER TABLE `sqlg_schema`.`E_index_property` ADD COLUMN `sequence` INTEGER DEFAULT 0;";
    }

    private Array createArrayOf(Connection conn, PropertyType propertyType, Object[] data) {
        try {
            switch (propertyType.ordinal()) {
                case 20: 
                case 21: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 41: {
                    return conn.createArrayOf(this.getArrayDriverType(propertyType), data);
                }
            }
            throw new IllegalStateException("Unhandled array type " + propertyType.name());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Object convertArray(PropertyType propertyType, Array array) throws SQLException {
        switch (propertyType.ordinal()) {
            case 21: {
                return SqlgUtil.convertObjectArrayToBooleanArray((Object[])((Object[])array.getArray()));
            }
            case 20: {
                return SqlgUtil.convertObjectArrayToBooleanPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 25: {
                return SqlgUtil.convertObjectOfIntegersArrayToShortArray((Object[])((Object[])array.getArray()));
            }
            case 24: {
                return SqlgUtil.convertObjectOfIntegersArrayToShortPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 27: {
                return SqlgUtil.convertObjectOfIntegersArrayToIntegerArray((Object[])((Object[])array.getArray()));
            }
            case 26: {
                return SqlgUtil.convertObjectOfIntegersArrayToIntegerPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 29: {
                return SqlgUtil.convertObjectOfLongsArrayToLongArray((Object[])((Object[])array.getArray()));
            }
            case 28: {
                return SqlgUtil.convertObjectOfLongsArrayToLongPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 33: {
                return SqlgUtil.convertObjectOfDoublesArrayToDoubleArray((Object[])((Object[])array.getArray()));
            }
            case 32: {
                return SqlgUtil.convertObjectOfDoublesArrayToDoublePrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 31: {
                return SqlgUtil.convertObjectOfFloatsArrayToFloatArray((Object[])((Object[])array.getArray()));
            }
            case 30: {
                return SqlgUtil.convertObjectOfFloatsArrayToFloatPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 34: {
                return SqlgUtil.convertObjectOfStringsArrayToStringArray((Object[])((Object[])array.getArray()));
            }
            case 35: {
                Object[] timestamps = (Object[])array.getArray();
                return SqlgUtil.copyObjectArrayOfTimestampToLocalDateTime((Object[])timestamps, (Object)new LocalDateTime[timestamps.length]);
            }
            case 36: {
                Object[] dates = (Object[])array.getArray();
                return SqlgUtil.copyObjectArrayOfDateToLocalDate((Object[])dates, (Object)new LocalDate[dates.length]);
            }
            case 37: {
                Object[] times = (Object[])array.getArray();
                return SqlgUtil.copyObjectArrayOfTimeToLocalTime((Object[])times, (Object)new LocalTime[times.length]);
            }
        }
        throw new IllegalStateException("Unhandled property type " + propertyType.name());
    }

    public void setArray(PreparedStatement statement, int index, PropertyType type, Object[] values) throws SQLException {
        statement.setArray(index, this.createArrayOf(statement.getConnection(), type, values));
    }

    public boolean isSystemIndex(String indexName) {
        return indexName.contains("_ibfk_") || indexName.equals("PRIMARY") || indexName.endsWith("__I") || indexName.endsWith("__O");
    }

    public boolean supportsBooleanArrayValues() {
        return false;
    }

    public boolean supportsDoubleArrayValues() {
        return false;
    }

    public boolean supportsFloatArrayValues() {
        return false;
    }

    public boolean supportsIntegerArrayValues() {
        return false;
    }

    public boolean supportsShortArrayValues() {
        return false;
    }

    public boolean supportsLongArrayValues() {
        return false;
    }

    public boolean supportsStringArrayValues() {
        return false;
    }

    public boolean supportsFloatValues() {
        return false;
    }

    public boolean supportsByteValues() {
        return false;
    }

    public boolean supportsLocalDateTimeArrayValues() {
        return false;
    }

    public boolean supportsLocalTimeArrayValues() {
        return false;
    }

    public boolean supportsLocalDateArrayValues() {
        return false;
    }

    public boolean supportsZonedDateTimeArrayValues() {
        return false;
    }

    public boolean supportsPeriodArrayValues() {
        return false;
    }

    public boolean supportsDurationArrayValues() {
        return false;
    }

    public boolean requiresIndexLengthLimit() {
        return true;
    }

    public String valueToValuesString(PropertyType propertyType, Object value) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean supportsType(PropertyType propertyType) {
        return false;
    }

    public String sqlToTurnOffReferentialConstraintCheck(String tableName) {
        return "SET FOREIGN_KEY_CHECKS=0";
    }

    public String sqlToTurnOnReferentialConstraintCheck(String tableName) {
        return "SET FOREIGN_KEY_CHECKS=1";
    }

    public String getSkipClause(long skip) {
        return " LIMIT " + skip + ", 1000000";
    }

    public boolean isMysql() {
        return true;
    }

    public void grantReadOnlyUserPrivilegesToSqlgSchemas(SqlgGraph sqlgGraph) {
        Connection conn = sqlgGraph.tx().getConnection();
        try (Statement statement = conn.createStatement();){
            statement.execute("CREATE USER 'sqlgReadOnly'@'localhost' IDENTIFIED BY 'sqlgReadOnly'");
            statement.execute("GRANT SELECT ON *.* TO 'sqlgReadOnly'@'localhost' IDENTIFIED BY 'sqlgReadOnly'");
            statement.executeQuery("FLUSH PRIVILEGES");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

