/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.sql.dialect;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mchange.v2.c3p0.C3P0ProxyConnection;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.PGgeometry;
import org.postgis.Point;
import org.postgis.Polygon;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyManager;
import org.postgresql.copy.PGCopyInputStream;
import org.postgresql.copy.PGCopyOutputStream;
import org.postgresql.core.BaseConnection;
import org.postgresql.util.PGbytea;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.gis.GeographyPoint;
import org.umlg.sqlg.gis.GeographyPolygon;
import org.umlg.sqlg.gis.Gis;
import org.umlg.sqlg.sql.dialect.BaseSqlDialect;
import org.umlg.sqlg.structure.BatchManager;
import org.umlg.sqlg.structure.MetaEdge;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.RecordId;
import org.umlg.sqlg.structure.SchemaManager;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgEdge;
import org.umlg.sqlg.structure.SqlgElement;
import org.umlg.sqlg.structure.SqlgExceptions;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.SqlgVertex;
import org.umlg.sqlg.util.SqlgUtil;

public class PostgresDialect
extends BaseSqlDialect {
    private static final String BATCH_NULL = "";
    private static final String COPY_COMMAND_DELIMITER = "\t";
    private static final String COPY_COMMAND_QUOTE = "e'\\x01'";
    private static final char QUOTE = '\u0001';
    private static final char ESCAPE = '\\';
    private static final int PARAMETER_LIMIT = Short.MAX_VALUE;
    private static final String COPY_DUMMY = "_copy_dummy";
    private Logger logger = LoggerFactory.getLogger((String)SqlgGraph.class.getName());
    private PropertyType postGisType;

    public String dialectName() {
        return "Postgresql";
    }

    public String createSchemaStatement() {
        return "CREATE SCHEMA IF NOT EXISTS ";
    }

    public boolean supportsBatchMode() {
        return true;
    }

    public Set<String> getDefaultSchemas() {
        return ImmutableSet.copyOf(Arrays.asList("pg_catalog", "public", "information_schema", "tiger", "tiger_data", "topology"));
    }

    public Set<String> getSpacialRefTable() {
        return ImmutableSet.copyOf(Collections.singletonList("spatial_ref_sys"));
    }

    public List<String> getGisSchemas() {
        return Arrays.asList("tiger", "tiger_data", "topology");
    }

    public String getForeignKeyTypeDefinition() {
        return "BIGINT";
    }

    public String getColumnEscapeKey() {
        return "\"";
    }

    public String getPrimaryKeyType() {
        return "BIGINT NOT NULL PRIMARY KEY";
    }

    public String getAutoIncrementPrimaryKeyConstruct() {
        return "BIGSERIAL PRIMARY KEY";
    }

    public void assertTableName(String tableName) {
        if (!StringUtils.isEmpty((CharSequence)tableName) && tableName.length() > 63) {
            throw new IllegalStateException(String.format("Postgres table names must be 63 characters or less! Given table name is %s", tableName));
        }
    }

    public String getArrayDriverType(PropertyType propertyType) {
        switch (propertyType) {
            case BYTE_ARRAY: {
                return "bytea";
            }
            case byte_ARRAY: {
                return "bytea";
            }
            case boolean_ARRAY: {
                return "bool";
            }
            case BOOLEAN_ARRAY: {
                return "bool";
            }
            case SHORT_ARRAY: {
                return "smallint";
            }
            case short_ARRAY: {
                return "smallint";
            }
            case INTEGER_ARRAY: {
                return "integer";
            }
            case int_ARRAY: {
                return "integer";
            }
            case LONG_ARRAY: {
                return "bigint";
            }
            case long_ARRAY: {
                return "bigint";
            }
            case FLOAT_ARRAY: {
                return "float";
            }
            case float_ARRAY: {
                return "float";
            }
            case DOUBLE_ARRAY: {
                return "float";
            }
            case double_ARRAY: {
                return "float";
            }
            case STRING_ARRAY: {
                return "varchar";
            }
            case LOCALDATETIME_ARRAY: {
                return "timestamptz";
            }
            case LOCALDATE_ARRAY: {
                return "date";
            }
            case LOCALTIME_ARRAY: {
                return "timetz";
            }
            case ZONEDDATETIME_ARRAY: {
                return "timestamptz";
            }
            case JSON_ARRAY: {
                return "jsonb";
            }
        }
        throw new IllegalStateException("propertyType " + propertyType.name() + " unknown!");
    }

    public String existIndexQuery(SchemaTable schemaTable, String prefix, String indexName) {
        StringBuilder sb = new StringBuilder("SELECT 1 FROM pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace");
        sb.append(" WHERE  c.relname = '");
        sb.append(indexName);
        sb.append("' AND n.nspname = '");
        sb.append(schemaTable.getSchema());
        sb.append("'");
        return sb.toString();
    }

    public Map<SchemaTable, Pair<Long, Long>> flushVertexCache(SqlgGraph sqlgGraph, Map<SchemaTable, Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>>> vertexCache) {
        LinkedHashMap<SchemaTable, Pair<Long, Long>> verticesRanges = new LinkedHashMap<SchemaTable, Pair<Long, Long>>();
        C3P0ProxyConnection con = (C3P0ProxyConnection)sqlgGraph.tx().getConnection();
        try {
            Method m = BaseConnection.class.getMethod("getCopyAPI", new Class[0]);
            Object[] arg = new Object[]{};
            CopyManager copyManager = (CopyManager)con.rawConnectionOperation(m, C3P0ProxyConnection.RAW_CONNECTION, arg);
            for (SchemaTable schemaTable : vertexCache.keySet()) {
                Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>> vertices = vertexCache.get(schemaTable);
                Map propertyTypeMap = (Map)sqlgGraph.getSchemaManager().getAllTables().get(schemaTable.getSchema() + "." + "V_" + schemaTable.getTable());
                long endHigh = 0L;
                long numberInserted = 0L;
                InputStream is = this.mapVertexToInputStream(propertyTypeMap, vertices);
                Throwable throwable = null;
                try {
                    StringBuilder sql = new StringBuilder();
                    sql.append("COPY ");
                    sql.append(this.maybeWrapInQoutes(schemaTable.getSchema()));
                    sql.append(".");
                    sql.append(this.maybeWrapInQoutes("V_" + schemaTable.getTable()));
                    sql.append(" (");
                    if (((SortedSet)vertices.getLeft()).isEmpty()) {
                        sqlgGraph.getSchemaManager().ensureColumnExist(schemaTable.getSchema(), "V_" + schemaTable.getTable(), ImmutablePair.of((Object)COPY_DUMMY, (Object)PropertyType.from((Object)0)));
                        sql.append(this.maybeWrapInQoutes(COPY_DUMMY));
                    } else {
                        int count = 1;
                        for (String key : (SortedSet)vertices.getLeft()) {
                            if (count > 1 && count <= ((SortedSet)vertices.getLeft()).size()) {
                                sql.append(", ");
                            }
                            ++count;
                            this.appendKeyForStream((PropertyType)propertyTypeMap.get(key), sql, key);
                        }
                    }
                    sql.append(")");
                    sql.append(" FROM stdin CSV DELIMITER '");
                    sql.append(COPY_COMMAND_DELIMITER);
                    sql.append("' ");
                    sql.append("QUOTE ");
                    sql.append(COPY_COMMAND_QUOTE);
                    sql.append(" ESCAPE '");
                    sql.append('\\');
                    sql.append("'");
                    sql.append(" NULL '");
                    sql.append(BATCH_NULL);
                    sql.append("';");
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(sql.toString());
                    }
                    if ((numberInserted = copyManager.copyIn(sql.toString(), is)) <= 0L) continue;
                    PreparedStatement preparedStatement = con.prepareStatement("SELECT CURRVAL('\"" + schemaTable.getSchema() + "\".\"" + "V_" + schemaTable.getTable() + "_ID_seq\"');");
                    Object object = null;
                    try {
                        ResultSet resultSet = preparedStatement.executeQuery();
                        resultSet.next();
                        endHigh = resultSet.getLong(1);
                        resultSet.close();
                    }
                    catch (Throwable throwable2) {
                        object = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (preparedStatement != null) {
                            if (object != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                preparedStatement.close();
                            }
                        }
                    }
                    long id = endHigh - numberInserted + 1L;
                    for (SqlgVertex sqlgVertex : ((Map)vertices.getRight()).keySet()) {
                        sqlgVertex.setInternalPrimaryKey(RecordId.from((SchemaTable)schemaTable, (Long)id++));
                    }
                    verticesRanges.put(schemaTable, (Pair<Long, Long>)Pair.of((Object)(endHigh - numberInserted + 1L), (Object)endHigh));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            return verticesRanges;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void flushEdgeCache(SqlgGraph sqlgGraph, Map<MetaEdge, Pair<SortedSet<String>, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>>> edgeCache) {
        C3P0ProxyConnection con = (C3P0ProxyConnection)sqlgGraph.tx().getConnection();
        try {
            Method m = BaseConnection.class.getMethod("getCopyAPI", new Class[0]);
            Object[] arg = new Object[]{};
            CopyManager copyManager = (CopyManager)con.rawConnectionOperation(m, C3P0ProxyConnection.RAW_CONNECTION, arg);
            for (MetaEdge metaEdge : edgeCache.keySet()) {
                Pair<SortedSet<String>, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>> triples = edgeCache.get(metaEdge);
                Map propertyTypeMap = (Map)sqlgGraph.getSchemaManager().getAllTables().get(metaEdge.getSchemaTable().getSchema() + "." + "E_" + metaEdge.getSchemaTable().getTable());
                InputStream is = this.mapEdgeToInputStream(propertyTypeMap, triples);
                Throwable throwable = null;
                try {
                    long endHigh;
                    StringBuilder sql = new StringBuilder();
                    sql.append("COPY ");
                    sql.append(this.maybeWrapInQoutes(metaEdge.getSchemaTable().getSchema()));
                    sql.append(".");
                    sql.append(this.maybeWrapInQoutes("E_" + metaEdge.getSchemaTable().getTable()));
                    sql.append(" (");
                    Iterator iterator = ((Map)triples.getRight()).values().iterator();
                    if (iterator.hasNext()) {
                        Triple triple = (Triple)iterator.next();
                        int count = 1;
                        sql.append(this.maybeWrapInQoutes(((SqlgVertex)triple.getLeft()).getSchema() + "." + ((SqlgVertex)triple.getLeft()).getTable() + "__O"));
                        sql.append(", ");
                        sql.append(this.maybeWrapInQoutes(((SqlgVertex)triple.getMiddle()).getSchema() + "." + ((SqlgVertex)triple.getMiddle()).getTable() + "__I"));
                        for (String key : (SortedSet)triples.getLeft()) {
                            if (count <= ((SortedSet)triples.getLeft()).size()) {
                                sql.append(", ");
                            }
                            ++count;
                            this.appendKeyForStream((PropertyType)propertyTypeMap.get(key), sql, key);
                        }
                    }
                    sql.append(") ");
                    sql.append(" FROM stdin CSV DELIMITER '");
                    sql.append(COPY_COMMAND_DELIMITER);
                    sql.append("' ");
                    sql.append("QUOTE ");
                    sql.append(COPY_COMMAND_QUOTE);
                    sql.append(" ESCAPE '");
                    sql.append('\\');
                    sql.append("';");
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(sql.toString());
                    }
                    long numberInserted = copyManager.copyIn(sql.toString(), is);
                    try (PreparedStatement preparedStatement = con.prepareStatement("SELECT CURRVAL('\"" + metaEdge.getSchemaTable().getSchema() + "\".\"" + "E_" + metaEdge.getSchemaTable().getTable() + "_ID_seq\"');");){
                        ResultSet resultSet = preparedStatement.executeQuery();
                        resultSet.next();
                        endHigh = resultSet.getLong(1);
                        resultSet.close();
                    }
                    long id = endHigh - numberInserted + 1L;
                    for (SqlgEdge sqlgEdge : ((Map)triples.getRight()).keySet()) {
                        sqlgEdge.setInternalPrimaryKey(RecordId.from((SchemaTable)metaEdge.getSchemaTable(), (Long)id++));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void flushVertexPropertyCache(SqlgGraph sqlgGraph, Map<SchemaTable, Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>>> schemaVertexPropertyCache) {
        this.flushElementPropertyCache(sqlgGraph, true, schemaVertexPropertyCache);
    }

    public void flushEdgePropertyCache(SqlgGraph sqlgGraph, Map<SchemaTable, Pair<SortedSet<String>, Map<SqlgEdge, Map<String, Object>>>> edgePropertyCache) {
        this.flushElementPropertyCache(sqlgGraph, false, edgePropertyCache);
    }

    public <T extends SqlgElement> void flushElementPropertyCache(SqlgGraph sqlgGraph, boolean forVertices, Map<SchemaTable, Pair<SortedSet<String>, Map<T, Map<String, Object>>>> schemaVertexPropertyCache) {
        Connection conn = sqlgGraph.tx().getConnection();
        Map allTables = sqlgGraph.getSchemaManager().getAllTables();
        for (SchemaTable schemaTable : schemaVertexPropertyCache.keySet()) {
            PropertyType propertyType;
            Pair<SortedSet<String>, Map<T, Map<String, Object>>> vertexKeysPropertyCache = schemaVertexPropertyCache.get(schemaTable);
            SortedSet keys = (SortedSet)vertexKeysPropertyCache.getLeft();
            Map vertexPropertyCache = (Map)vertexKeysPropertyCache.getRight();
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE ");
            sql.append(this.maybeWrapInQoutes(schemaTable.getSchema()));
            sql.append(".");
            sql.append(this.maybeWrapInQoutes((forVertices ? "V_" : "E_") + schemaTable.getTable()));
            sql.append(" a \nSET\n\t(");
            int count = 1;
            HashMap<String, PropertyType> keyPropertyTypeMap = new HashMap<String, PropertyType>();
            for (String key : keys) {
                propertyType = (PropertyType)((Map)allTables.get(schemaTable.getSchema() + "." + (forVertices ? "V_" : "E_") + schemaTable.getTable())).get(key);
                keyPropertyTypeMap.put(key, propertyType);
                this.appendKeyForBatchUpdate(propertyType, sql, key, false);
                if (count++ >= keys.size()) continue;
                sql.append(", ");
            }
            sql.append(") = \n\t(");
            count = 1;
            for (String key : keys) {
                sql.append("v.");
                propertyType = (PropertyType)keyPropertyTypeMap.get(key);
                this.appendKeyForBatchUpdate(propertyType, sql, key, true);
                switch (propertyType) {
                    case boolean_ARRAY: {
                        sql.append("::boolean[]");
                        break;
                    }
                    case byte_ARRAY: {
                        sql.append("::bytea");
                        break;
                    }
                    case short_ARRAY: {
                        sql.append("::smallint[]");
                        break;
                    }
                    case int_ARRAY: {
                        sql.append("::int[]");
                        break;
                    }
                    case long_ARRAY: {
                        sql.append("::bigint[]");
                        break;
                    }
                    case float_ARRAY: {
                        sql.append("::real[]");
                        break;
                    }
                    case double_ARRAY: {
                        sql.append("::double precision[]");
                        break;
                    }
                    case STRING_ARRAY: {
                        sql.append("::text[]");
                        break;
                    }
                    case BOOLEAN_ARRAY: {
                        sql.append("::boolean[]");
                        break;
                    }
                    case BYTE_ARRAY: {
                        sql.append("::bytea");
                        break;
                    }
                    case SHORT_ARRAY: {
                        sql.append("::smallint[]");
                        break;
                    }
                    case INTEGER_ARRAY: {
                        sql.append("::int[]");
                        break;
                    }
                    case LONG_ARRAY: {
                        sql.append("::bigint[]");
                        break;
                    }
                    case FLOAT_ARRAY: {
                        sql.append("::real[]");
                        break;
                    }
                    case DOUBLE_ARRAY: {
                        sql.append("::double precision[]");
                    }
                }
                if (count++ >= keys.size()) continue;
                sql.append(", ");
            }
            sql.append(")\nFROM (\nVALUES\n\t");
            count = 1;
            for (SqlgElement sqlgVertex : vertexPropertyCache.keySet()) {
                Map properties = (Map)vertexPropertyCache.get(sqlgVertex);
                sql.append("(");
                sql.append(((RecordId)sqlgVertex.id()).getId());
                sql.append(", ");
                int countProperties = 1;
                for (String key : keys) {
                    Object value = properties.get(key);
                    if (value == null) {
                        value = sqlgVertex.property(key).isPresent() ? sqlgVertex.value(key) : "null";
                    }
                    PropertyType propertyType2 = (PropertyType)keyPropertyTypeMap.get(key);
                    switch (propertyType2) {
                        case BOOLEAN: {
                            sql.append(value);
                            break;
                        }
                        case BYTE: {
                            sql.append(value);
                            break;
                        }
                        case SHORT: {
                            sql.append(value);
                            break;
                        }
                        case INTEGER: {
                            sql.append(value);
                            break;
                        }
                        case LONG: {
                            sql.append(value);
                            break;
                        }
                        case FLOAT: {
                            sql.append(value);
                            break;
                        }
                        case DOUBLE: {
                            sql.append(value);
                            break;
                        }
                        case STRING: {
                            sql.append("$token$");
                            sql.append(value);
                            sql.append("$token$");
                            break;
                        }
                        case LOCALDATETIME: {
                            sql.append("'");
                            sql.append(value.toString());
                            sql.append("'::TIMESTAMP");
                            break;
                        }
                        case LOCALDATE: {
                            sql.append("'");
                            sql.append(value.toString());
                            sql.append("'::DATE");
                            break;
                        }
                        case LOCALTIME: {
                            sql.append("'");
                            sql.append(PostgresDialect.shiftDST((LocalTime)value).toString());
                            sql.append("'::TIME");
                            break;
                        }
                        case ZONEDDATETIME: {
                            ZonedDateTime zonedDateTime = (ZonedDateTime)value;
                            LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
                            TimeZone timeZone = TimeZone.getTimeZone(zonedDateTime.getZone().getId());
                            sql.append("'");
                            sql.append(localDateTime.toString());
                            sql.append("'::TIMESTAMP");
                            sql.append(",'");
                            sql.append(timeZone.getID());
                            sql.append("'");
                            break;
                        }
                        case DURATION: {
                            Duration duration = (Duration)value;
                            sql.append("'");
                            sql.append(duration.getSeconds());
                            sql.append("'::BIGINT");
                            sql.append(",'");
                            sql.append(duration.getNano());
                            sql.append("'::INTEGER");
                            break;
                        }
                        case PERIOD: {
                            Period period = (Period)value;
                            sql.append("'");
                            sql.append(period.getYears());
                            sql.append("'::INTEGER");
                            sql.append(",'");
                            sql.append(period.getMonths());
                            sql.append("'::INTEGER");
                            sql.append(",'");
                            sql.append(period.getDays());
                            sql.append("'::INTEGER");
                            break;
                        }
                        case JSON: {
                            sql.append("'");
                            sql.append(value.toString());
                            sql.append("'::JSONB");
                            break;
                        }
                        case boolean_ARRAY: {
                            sql.append("'{");
                            boolean[] booleanArray = (boolean[])value;
                            int countBooleanArray = 1;
                            boolean[] blArray = booleanArray;
                            int n = blArray.length;
                            for (int i = 0; i < n; ++i) {
                                Boolean b = blArray[i];
                                sql.append(b);
                                if (countBooleanArray++ >= booleanArray.length) continue;
                                sql.append(",");
                            }
                            sql.append("}'");
                            break;
                        }
                        case BOOLEAN_ARRAY: {
                            sql.append("'{");
                            Boolean[] BooleanArray = (Boolean[])value;
                            int countBOOLEANArray = 1;
                            for (Boolean b : BooleanArray) {
                                sql.append(b);
                                if (countBOOLEANArray++ >= BooleanArray.length) continue;
                                sql.append(",");
                            }
                            sql.append("}'");
                            break;
                        }
                        case byte_ARRAY: {
                            try {
                                sql.append("'");
                                sql.append(PGbytea.toPGString((byte[])((byte[])value)));
                                sql.append("'");
                                break;
                            }
                            catch (SQLException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        case BYTE_ARRAY: {
                            try {
                                sql.append("'");
                                sql.append(PGbytea.toPGString((byte[])((byte[])SqlgUtil.convertByteArrayToPrimitiveArray((Byte[])((Byte[])value)))));
                                sql.append("'");
                                break;
                            }
                            catch (SQLException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        case short_ARRAY: {
                            Object s;
                            sql.append("'{");
                            short[] sortArray = (short[])value;
                            int countShortArray = 1;
                            short[] sArray = sortArray;
                            int b = sArray.length;
                            for (int i = 0; i < b; ++i) {
                                s = sArray[i];
                                sql.append(s);
                                if (countShortArray++ >= sortArray.length) continue;
                                sql.append(",");
                            }
                            sql.append("}'");
                            break;
                        }
                        case SHORT_ARRAY: {
                            sql.append("'{");
                            Short[] shortObjectArray = (Short[])value;
                            for (int i = 0; i < shortObjectArray.length; ++i) {
                                Short s = shortObjectArray[i];
                                sql.append(s);
                                if (i >= shortObjectArray.length - 1) continue;
                                sql.append(",");
                            }
                            sql.append("}'");
                            break;
                        }
                        case int_ARRAY: {
                            sql.append("'{");
                            int[] intArray = (int[])value;
                            int countIntArray = 1;
                            Object s = intArray;
                            int n = ((int[])s).length;
                            for (int i = 0; i < n; ++i) {
                                Integer i2 = s[i];
                                sql.append(i2);
                                if (countIntArray++ >= intArray.length) continue;
                                sql.append(",");
                            }
                            sql.append("}'");
                            break;
                        }
                        case INTEGER_ARRAY: {
                            sql.append("'{");
                            Integer[] integerArray = (Integer[])value;
                            int countIntegerArray = 1;
                            for (Integer i : integerArray) {
                                sql.append(i);
                                if (countIntegerArray++ >= integerArray.length) continue;
                                sql.append(",");
                            }
                            sql.append("}'");
                            break;
                        }
                        case LONG_ARRAY: {
                            sql.append("'{");
                            Long[] longArray = (Long[])value;
                            int countLongArray = 1;
                            for (Long l : longArray) {
                                sql.append(l);
                                if (countLongArray++ >= longArray.length) continue;
                                sql.append(",");
                            }
                            sql.append("}'");
                            break;
                        }
                        case long_ARRAY: {
                            sql.append("'{");
                            long[] longPrimitiveArray = (long[])value;
                            int countLongPrimitiveArray = 1;
                            long[] lArray = longPrimitiveArray;
                            int l = lArray.length;
                            for (int i = 0; i < l; ++i) {
                                Long l2 = lArray[i];
                                sql.append(l2);
                                if (countLongPrimitiveArray++ >= longPrimitiveArray.length) continue;
                                sql.append(",");
                            }
                            sql.append("}'");
                            break;
                        }
                        case FLOAT_ARRAY: {
                            sql.append("'{");
                            Float[] floatArray = (Float[])value;
                            int countFloatArray = 1;
                            for (Float f : floatArray) {
                                sql.append(f);
                                if (countFloatArray++ >= floatArray.length) continue;
                                sql.append(",");
                            }
                            sql.append("}'");
                            break;
                        }
                        case float_ARRAY: {
                            sql.append("'{");
                            float[] floatPrimitiveArray = (float[])value;
                            int countFloatPrimitiveArray = 1;
                            float[] fArray = floatPrimitiveArray;
                            int f = fArray.length;
                            for (int i = 0; i < f; ++i) {
                                Float f2 = Float.valueOf(fArray[i]);
                                sql.append(f2);
                                if (countFloatPrimitiveArray++ >= floatPrimitiveArray.length) continue;
                                sql.append(",");
                            }
                            sql.append("}'");
                            break;
                        }
                        case DOUBLE_ARRAY: {
                            sql.append("'{");
                            Double[] doubleArray = (Double[])value;
                            int countDoubleArray = 1;
                            for (Double d : doubleArray) {
                                sql.append(d);
                                if (countDoubleArray++ >= doubleArray.length) continue;
                                sql.append(",");
                            }
                            sql.append("}'");
                            break;
                        }
                        case double_ARRAY: {
                            sql.append("'{");
                            double[] doublePrimitiveArray = (double[])value;
                            int countDoublePrimitiveArray = 1;
                            double[] dArray = doublePrimitiveArray;
                            int d = dArray.length;
                            for (int i = 0; i < d; ++i) {
                                Double d2 = dArray[i];
                                sql.append(d2);
                                if (countDoublePrimitiveArray++ >= doublePrimitiveArray.length) continue;
                                sql.append(",");
                            }
                            sql.append("}'");
                            break;
                        }
                        case STRING_ARRAY: {
                            sql.append("'{");
                            String[] stringArray = (String[])value;
                            int countStringArray = 1;
                            for (String s : stringArray) {
                                sql.append("\"");
                                sql.append(s);
                                sql.append("\"");
                                if (countStringArray++ >= stringArray.length) continue;
                                sql.append(",");
                            }
                            sql.append("}'");
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown propertyType " + propertyType2.name());
                        }
                    }
                    if (countProperties++ >= keys.size()) continue;
                    sql.append(", ");
                }
                sql.append(")");
                if (count++ >= vertexPropertyCache.size()) continue;
                sql.append(",\n\t");
            }
            sql.append("\n) AS v(id, ");
            count = 1;
            for (String key : keys) {
                propertyType = (PropertyType)keyPropertyTypeMap.get(key);
                this.appendKeyForBatchUpdate(propertyType, sql, key, false);
                if (count++ >= keys.size()) continue;
                sql.append(", ");
            }
            sql.append(")");
            sql.append("\nWHERE a.\"ID\" = v.id");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(sql.toString());
            }
            try {
                Statement statement = conn.createStatement();
                Throwable throwable = null;
                try {
                    statement.execute(sql.toString());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String constructCompleteCopyCommandTemporarySqlVertex(SqlgGraph sqlgGraph, SqlgVertex vertex, Map<String, Object> keyValueMap) {
        return this.internalConstructCompleteCopyCommandSqlVertex(sqlgGraph, true, vertex, keyValueMap);
    }

    public String constructCompleteCopyCommandSqlVertex(SqlgGraph sqlgGraph, SqlgVertex vertex, Map<String, Object> keyValueMap) {
        return this.internalConstructCompleteCopyCommandSqlVertex(sqlgGraph, false, vertex, keyValueMap);
    }

    private String internalConstructCompleteCopyCommandSqlVertex(SqlgGraph sqlgGraph, boolean isTemp, SqlgVertex vertex, Map<String, Object> keyValueMap) {
        Map propertyTypeMap = (Map)sqlgGraph.getSchemaManager().getAllTables().get((!isTemp ? vertex.getSchema() + "." : BATCH_NULL) + "V_" + vertex.getTable());
        StringBuilder sql = new StringBuilder();
        sql.append("COPY ");
        if (!isTemp) {
            sql.append(this.maybeWrapInQoutes(vertex.getSchema()));
            sql.append(".");
        }
        sql.append(this.maybeWrapInQoutes("V_" + vertex.getTable()));
        sql.append(" (");
        if (keyValueMap.isEmpty()) {
            sqlgGraph.getSchemaManager().ensureColumnExist(vertex.getSchema(), "V_" + vertex.getTable(), ImmutablePair.of((Object)COPY_DUMMY, (Object)PropertyType.from((Object)0)));
            sql.append(this.maybeWrapInQoutes(COPY_DUMMY));
        } else {
            int count = 1;
            for (String key : keyValueMap.keySet()) {
                if (count > 1 && count <= keyValueMap.size()) {
                    sql.append(", ");
                }
                ++count;
                this.appendKeyForStream((PropertyType)propertyTypeMap.get(key), sql, key);
            }
        }
        sql.append(")");
        sql.append(" FROM stdin CSV DELIMITER '");
        sql.append(COPY_COMMAND_DELIMITER);
        sql.append("' ");
        sql.append("QUOTE ");
        sql.append(COPY_COMMAND_QUOTE);
        sql.append(" ESCAPE '");
        sql.append('\\');
        sql.append("'");
        sql.append(" NULL'");
        sql.append(BATCH_NULL);
        sql.append("';");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        return sql.toString();
    }

    public String constructCompleteCopyCommandSqlEdge(SqlgGraph sqlgGraph, SqlgEdge sqlgEdge, SqlgVertex outVertex, SqlgVertex inVertex, Map<String, Object> keyValueMap) {
        Map propertyTypeMap = (Map)sqlgGraph.getSchemaManager().getAllTables().get(sqlgEdge.getSchema() + "." + "E_" + sqlgEdge.getTable());
        StringBuilder sql = new StringBuilder();
        sql.append("COPY ");
        sql.append(this.maybeWrapInQoutes(sqlgEdge.getSchema()));
        sql.append(".");
        sql.append(this.maybeWrapInQoutes("E_" + sqlgEdge.getTable()));
        sql.append(" (");
        sql.append(this.maybeWrapInQoutes(outVertex.getSchema() + "." + outVertex.getTable() + "__O"));
        sql.append(", ");
        sql.append(this.maybeWrapInQoutes(inVertex.getSchema() + "." + inVertex.getTable() + "__I"));
        int count = 1;
        for (String key : keyValueMap.keySet()) {
            if (count <= keyValueMap.size()) {
                sql.append(", ");
            }
            ++count;
            this.appendKeyForStream((PropertyType)propertyTypeMap.get(key), sql, key);
        }
        sql.append(") ");
        sql.append(" FROM stdin CSV DELIMITER '");
        sql.append(COPY_COMMAND_DELIMITER);
        sql.append("' ");
        sql.append("QUOTE ");
        sql.append(COPY_COMMAND_QUOTE);
        sql.append(";");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        return sql.toString();
    }

    private void appendKeyForStream(PropertyType propertyType, StringBuilder sql, String key) {
        String[] sqlDefinitions = this.propertyTypeToSqlDefinition(propertyType);
        int countPerKey = 1;
        for (String sqlDefinition : sqlDefinitions) {
            if (countPerKey > 1) {
                sql.append(this.maybeWrapInQoutes(key + propertyType.getPostFixes()[countPerKey - 2]));
            } else {
                sql.append(this.maybeWrapInQoutes(key));
            }
            if (countPerKey++ >= sqlDefinitions.length) continue;
            sql.append(",");
        }
    }

    private void appendKeyForBatchUpdate(PropertyType propertyType, StringBuilder sql, String key, boolean withV) {
        String[] sqlDefinitions = this.propertyTypeToSqlDefinition(propertyType);
        int countPerKey = 1;
        for (String sqlDefinition : sqlDefinitions) {
            if (countPerKey > 1) {
                if (withV) {
                    sql.append("v.");
                }
                sql.append(this.maybeWrapInQoutes(key + propertyType.getPostFixes()[countPerKey - 2]));
            } else {
                sql.append(this.maybeWrapInQoutes(key));
            }
            if (countPerKey++ >= sqlDefinitions.length) continue;
            sql.append(",");
        }
    }

    public String temporaryTableCopyCommandSqlVertex(SqlgGraph sqlgGraph, SchemaTable schemaTable, Map<String, Object> keyValueMap) {
        StringBuilder sql = new StringBuilder();
        sql.append("COPY ");
        sql.append(this.maybeWrapInQoutes("V_" + schemaTable.getTable()));
        sql.append(" (");
        if (keyValueMap.isEmpty()) {
            sqlgGraph.getSchemaManager().ensureColumnExist(schemaTable.getSchema(), "V_" + schemaTable.getTable(), ImmutablePair.of((Object)COPY_DUMMY, (Object)PropertyType.from((Object)0)));
            sql.append(this.maybeWrapInQoutes(COPY_DUMMY));
        } else {
            int count = 1;
            for (String key : keyValueMap.keySet()) {
                if (count > 1 && count <= keyValueMap.size()) {
                    sql.append(", ");
                }
                ++count;
                sql.append(this.maybeWrapInQoutes(key));
            }
        }
        sql.append(")");
        sql.append(" FROM stdin CSV DELIMITER '");
        sql.append(COPY_COMMAND_DELIMITER);
        sql.append("' ");
        sql.append("QUOTE ");
        sql.append(COPY_COMMAND_QUOTE);
        sql.append(" ESCAPE '");
        sql.append('\\');
        sql.append("';");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        return sql.toString();
    }

    public void writeStreamingVertex(OutputStream out, Map<String, Object> keyValueMap) {
        try {
            int countKeys = 1;
            if (keyValueMap.isEmpty()) {
                out.write(Integer.toString(1).getBytes());
            } else {
                for (Map.Entry<String, Object> entry : keyValueMap.entrySet()) {
                    if (countKeys > 1 && countKeys <= keyValueMap.size()) {
                        out.write(COPY_COMMAND_DELIMITER.getBytes());
                    }
                    ++countKeys;
                    Object value = entry.getValue();
                    PropertyType propertyType = value == null ? PropertyType.STRING : PropertyType.from((Object)value);
                    if (PropertyType.JSON_ARRAY == propertyType) {
                        throw SqlgExceptions.invalidPropertyType((PropertyType)propertyType);
                    }
                    out.write(this.valueToStreamBytes(propertyType, value));
                }
            }
            out.write("\n".getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeStreamingEdge(OutputStream out, SqlgEdge sqlgEdge, SqlgVertex outVertex, SqlgVertex inVertex, Map<String, Object> keyValueMap) {
        try {
            String encoding = "UTF-8";
            out.write(((RecordId)outVertex.id()).getId().toString().getBytes(encoding));
            out.write(COPY_COMMAND_DELIMITER.getBytes(encoding));
            out.write(((RecordId)inVertex.id()).getId().toString().getBytes(encoding));
            for (Map.Entry<String, Object> entry : keyValueMap.entrySet()) {
                out.write(COPY_COMMAND_DELIMITER.getBytes(encoding));
                Object value = entry.getValue();
                PropertyType propertyType = PropertyType.from((Object)value);
                out.write(this.valueToStreamBytes(propertyType, value));
            }
            out.write("\n".getBytes(encoding));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] valueToStreamBytes(PropertyType propertyType, Object value) throws UnsupportedEncodingException {
        String encoding = "UTF-8";
        return this.valueToStreamString(propertyType, value).getBytes(encoding);
    }

    private String valueToStreamString(PropertyType propertyType, Object value) {
        String result;
        if (value == null) {
            result = this.getBatchNull();
        } else {
            switch (propertyType) {
                case ZONEDDATETIME: {
                    ZonedDateTime zonedDateTime = (ZonedDateTime)value;
                    LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
                    TimeZone timeZone = TimeZone.getTimeZone(zonedDateTime.getZone().getId());
                    result = localDateTime.toString() + COPY_COMMAND_DELIMITER + timeZone.getID();
                    break;
                }
                case PERIOD: {
                    Period period = (Period)value;
                    result = period.getYears() + COPY_COMMAND_DELIMITER + period.getMonths() + COPY_COMMAND_DELIMITER + period.getDays();
                    break;
                }
                case DURATION: {
                    Duration duration = (Duration)value;
                    result = duration.getSeconds() + COPY_COMMAND_DELIMITER + duration.getNano();
                    break;
                }
                case LOCALTIME: {
                    LocalTime lt = (LocalTime)value;
                    result = PostgresDialect.shiftDST(lt).toString();
                    break;
                }
                case ZONEDDATETIME_ARRAY: {
                    String result2;
                    ZonedDateTime zonedDateTime;
                    int i;
                    ZonedDateTime[] zonedDateTimes = (ZonedDateTime[])value;
                    StringBuilder sb = new StringBuilder();
                    sb.append("{");
                    int length = Array.getLength(value);
                    for (i = 0; i < length; ++i) {
                        zonedDateTime = zonedDateTimes[i];
                        LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
                        result2 = localDateTime.toString();
                        sb.append(result2);
                        if (i >= length - 1) continue;
                        sb.append(",");
                    }
                    sb.append("}");
                    sb.append(COPY_COMMAND_DELIMITER);
                    sb.append("{");
                    for (i = 0; i < length; ++i) {
                        zonedDateTime = zonedDateTimes[i];
                        TimeZone timeZone = TimeZone.getTimeZone(zonedDateTime.getZone().getId());
                        result2 = timeZone.getID();
                        sb.append(result2);
                        if (i >= length - 1) continue;
                        sb.append(",");
                    }
                    sb.append("}");
                    return sb.toString();
                }
                case DURATION_ARRAY: {
                    Duration duration;
                    int i;
                    Duration[] durations = (Duration[])value;
                    StringBuilder sb = new StringBuilder();
                    sb.append("{");
                    int length = Array.getLength(value);
                    for (i = 0; i < length; ++i) {
                        duration = durations[i];
                        sb.append(duration.getSeconds());
                        if (i >= length - 1) continue;
                        sb.append(",");
                    }
                    sb.append("}");
                    sb.append(COPY_COMMAND_DELIMITER);
                    sb.append("{");
                    for (i = 0; i < length; ++i) {
                        duration = durations[i];
                        sb.append(duration.getNano());
                        if (i >= length - 1) continue;
                        sb.append(",");
                    }
                    sb.append("}");
                    return sb.toString();
                }
                case PERIOD_ARRAY: {
                    Period period;
                    int i;
                    Period[] periods = (Period[])value;
                    StringBuilder sb = new StringBuilder();
                    sb.append("{");
                    int length = Array.getLength(value);
                    for (i = 0; i < length; ++i) {
                        period = periods[i];
                        sb.append(period.getYears());
                        if (i >= length - 1) continue;
                        sb.append(",");
                    }
                    sb.append("}");
                    sb.append(COPY_COMMAND_DELIMITER);
                    sb.append("{");
                    for (i = 0; i < length; ++i) {
                        period = periods[i];
                        sb.append(period.getMonths());
                        if (i >= length - 1) continue;
                        sb.append(",");
                    }
                    sb.append("}");
                    sb.append(COPY_COMMAND_DELIMITER);
                    sb.append("{");
                    for (i = 0; i < length; ++i) {
                        period = periods[i];
                        sb.append(period.getDays());
                        if (i >= length - 1) continue;
                        sb.append(",");
                    }
                    sb.append("}");
                    return sb.toString();
                }
                case LOCALTIME_ARRAY: {
                    LocalTime[] localTimes = (LocalTime[])value;
                    StringBuilder sb = new StringBuilder();
                    sb.append("{");
                    int length = Array.getLength(value);
                    for (int i = 0; i < length; ++i) {
                        LocalTime localTime = localTimes[i];
                        String result3 = PostgresDialect.shiftDST(localTime).toString();
                        sb.append(result3);
                        if (i >= length - 1) continue;
                        sb.append(",");
                    }
                    sb.append("}");
                    return sb.toString();
                }
                default: {
                    if (value.getClass().isArray()) {
                        if (value.getClass().getName().equals("[B")) {
                            try {
                                String valueOfArrayAsString = PGbytea.toPGString((byte[])((byte[])value));
                                return valueOfArrayAsString;
                            }
                            catch (SQLException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        StringBuilder sb = new StringBuilder();
                        sb.append("{");
                        int length = Array.getLength(value);
                        for (int i = 0; i < length; ++i) {
                            String valueOfArray = Array.get(value, i).toString();
                            sb.append(this.escapeSpecialCharacters(valueOfArray));
                            if (i >= length - 1) continue;
                            sb.append(",");
                        }
                        sb.append("}");
                        return sb.toString();
                    }
                    result = this.escapeSpecialCharacters(value.toString());
                }
            }
        }
        return result;
    }

    public void flushRemovedVertices(SqlgGraph sqlgGraph, Map<SchemaTable, List<SqlgVertex>> removeVertexCache) {
        if (!removeVertexCache.isEmpty()) {
            for (Map.Entry<SchemaTable, List<SqlgVertex>> schemaVertices : removeVertexCache.entrySet()) {
                SchemaTable schemaTable = schemaVertices.getKey();
                Pair tableLabels = sqlgGraph.getSchemaManager().getTableLabels(SchemaTable.of((String)schemaTable.getSchema(), (String)("V_" + schemaTable.getTable())));
                List<SqlgVertex> vertices = schemaVertices.getValue();
                int numberOfLoops = vertices.size() / Short.MAX_VALUE;
                int previous = 0;
                for (int i = 1; i <= numberOfLoops + 1; ++i) {
                    int subListTo = i * Short.MAX_VALUE;
                    List<SqlgVertex> subVertices = i <= numberOfLoops ? vertices.subList(previous, subListTo) : vertices.subList(previous, vertices.size());
                    previous = subListTo;
                    if (subVertices.isEmpty()) continue;
                    Set inLabels = (Set)tableLabels.getLeft();
                    Set outLabels = (Set)tableLabels.getRight();
                    this.deleteEdges(sqlgGraph, schemaTable, subVertices, inLabels, true);
                    this.deleteEdges(sqlgGraph, schemaTable, subVertices, outLabels, false);
                    StringBuilder sql = new StringBuilder("DELETE FROM ");
                    sql.append(sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes(schemaTable.getSchema()));
                    sql.append(".");
                    sql.append(sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes("V_" + schemaTable.getTable()));
                    sql.append(" WHERE ");
                    sql.append(sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes("ID"));
                    sql.append(" in (");
                    int count = 1;
                    for (SqlgVertex sqlgVertex : subVertices) {
                        sql.append("?");
                        if (count++ >= subVertices.size()) continue;
                        sql.append(",");
                    }
                    sql.append(")");
                    if (sqlgGraph.getSqlDialect().needsSemicolon()) {
                        sql.append(";");
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(sql.toString());
                    }
                    Connection conn = sqlgGraph.tx().getConnection();
                    try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
                        count = 1;
                        for (SqlgVertex sqlgVertex : subVertices) {
                            preparedStatement.setLong(count++, ((RecordId)sqlgVertex.id()).getId());
                        }
                        preparedStatement.executeUpdate();
                        continue;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    private void dropForeignKeys(SqlgGraph sqlgGraph, SchemaTable schemaTable) {
        SchemaManager schemaManager = sqlgGraph.getSchemaManager();
        Map edgeForeignKeys = schemaManager.getEdgeForeignKeys();
        for (Map.Entry edgeForeignKey : edgeForeignKeys.entrySet()) {
            String edgeTable = (String)edgeForeignKey.getKey();
            Set foreignKeys = (Set)edgeForeignKey.getValue();
            String[] schemaTableArray = edgeTable.split("\\.");
            for (String foreignKey : foreignKeys) {
                if (!foreignKey.startsWith(schemaTable.toString() + "_")) continue;
                Set<String> foreignKeyNames = this.getForeignKeyConstraintNames(sqlgGraph, schemaTableArray[0], schemaTableArray[1]);
                for (String foreignKeyName : foreignKeyNames) {
                    StringBuilder sql = new StringBuilder();
                    sql.append("ALTER TABLE ");
                    sql.append(this.maybeWrapInQoutes(schemaTableArray[0]));
                    sql.append(".");
                    sql.append(this.maybeWrapInQoutes(schemaTableArray[1]));
                    sql.append(" DROP CONSTRAINT ");
                    sql.append(this.maybeWrapInQoutes(foreignKeyName));
                    if (this.needsSemicolon()) {
                        sql.append(";");
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(sql.toString());
                    }
                    Connection conn = sqlgGraph.tx().getConnection();
                    try {
                        PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());
                        Throwable throwable = null;
                        try {
                            preparedStatement.executeUpdate();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (preparedStatement == null) continue;
                            if (throwable != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    private void createForeignKeys(SqlgGraph sqlgGraph, SchemaTable schemaTable) {
        SchemaManager schemaManager = sqlgGraph.getSchemaManager();
        Map edgeForeignKeys = schemaManager.getEdgeForeignKeys();
        for (Map.Entry edgeForeignKey : edgeForeignKeys.entrySet()) {
            String edgeTable = (String)edgeForeignKey.getKey();
            Set foreignKeys = (Set)edgeForeignKey.getValue();
            for (String foreignKey : foreignKeys) {
                if (!foreignKey.startsWith(schemaTable.toString() + "_")) continue;
                String[] schemaTableArray = edgeTable.split("\\.");
                StringBuilder sql = new StringBuilder();
                sql.append("ALTER TABLE ");
                sql.append(this.maybeWrapInQoutes(schemaTableArray[0]));
                sql.append(".");
                sql.append(this.maybeWrapInQoutes(schemaTableArray[1]));
                sql.append(" ADD FOREIGN KEY (");
                sql.append(this.maybeWrapInQoutes(foreignKey));
                sql.append(") REFERENCES ");
                sql.append(this.maybeWrapInQoutes(schemaTable.getSchema()));
                sql.append(".");
                sql.append(this.maybeWrapInQoutes("V_" + schemaTable.getTable()));
                sql.append(" MATCH SIMPLE");
                if (this.needsSemicolon()) {
                    sql.append(";");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(sql.toString());
                }
                Connection conn = sqlgGraph.tx().getConnection();
                try {
                    PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());
                    Throwable throwable = null;
                    try {
                        preparedStatement.executeUpdate();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (preparedStatement == null) continue;
                        if (throwable != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        preparedStatement.close();
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void deleteEdges(SqlgGraph sqlgGraph, SchemaTable schemaTable, List<SqlgVertex> subVertices, Set<SchemaTable> labels, boolean inDirection) {
        for (SchemaTable inLabel : labels) {
            StringBuilder sql = new StringBuilder();
            sql.append("DELETE FROM ");
            sql.append(this.maybeWrapInQoutes(inLabel.getSchema()));
            sql.append(".");
            sql.append(this.maybeWrapInQoutes(inLabel.getTable()));
            sql.append(" WHERE ");
            sql.append(this.maybeWrapInQoutes(schemaTable.toString() + (inDirection ? "__I" : "__O")));
            sql.append(" IN (");
            int count = 1;
            for (Vertex vertex : subVertices) {
                sql.append("?");
                if (count++ >= subVertices.size()) continue;
                sql.append(",");
            }
            sql.append(")");
            if (sqlgGraph.getSqlDialect().needsSemicolon()) {
                sql.append(";");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(sql.toString());
            }
            Connection conn = sqlgGraph.tx().getConnection();
            try {
                PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());
                Throwable throwable = null;
                try {
                    count = 1;
                    for (Vertex vertex : subVertices) {
                        preparedStatement.setLong(count++, ((RecordId)vertex.id()).getId());
                    }
                    int deleted = preparedStatement.executeUpdate();
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Deleted " + deleted + " edges from " + inLabel.toString());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (preparedStatement == null) continue;
                    if (throwable != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
        }
    }

    public void flushRemovedEdges(SqlgGraph sqlgGraph, Map<SchemaTable, List<SqlgEdge>> removeEdgeCache) {
        if (!removeEdgeCache.isEmpty()) {
            for (Map.Entry<SchemaTable, List<SqlgEdge>> schemaEdges : removeEdgeCache.entrySet()) {
                List<SqlgEdge> edges = schemaEdges.getValue();
                int numberOfLoops = edges.size() / Short.MAX_VALUE;
                int previous = 0;
                for (int i = 1; i <= numberOfLoops + 1; ++i) {
                    ArrayList<SqlgEdge> flattenedEdges = new ArrayList<SqlgEdge>();
                    int subListTo = i * Short.MAX_VALUE;
                    List<SqlgEdge> subEdges = i <= numberOfLoops ? edges.subList(previous, subListTo) : edges.subList(previous, edges.size());
                    previous = subListTo;
                    for (SchemaTable schemaTable : removeEdgeCache.keySet()) {
                        StringBuilder sql = new StringBuilder("DELETE FROM ");
                        sql.append(sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes(schemaTable.getSchema()));
                        sql.append(".");
                        sql.append(sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes("E_" + schemaTable.getTable()));
                        sql.append(" WHERE ");
                        sql.append(sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes("ID"));
                        sql.append(" in (");
                        int count = 1;
                        for (SqlgEdge sqlgEdge : subEdges) {
                            flattenedEdges.add(sqlgEdge);
                            sql.append("?");
                            if (count++ >= subEdges.size()) continue;
                            sql.append(",");
                        }
                        sql.append(")");
                        if (sqlgGraph.getSqlDialect().needsSemicolon()) {
                            sql.append(";");
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(sql.toString());
                        }
                        Connection conn = sqlgGraph.tx().getConnection();
                        try {
                            PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());
                            Throwable throwable = null;
                            try {
                                count = 1;
                                for (SqlgEdge sqlgEdge : subEdges) {
                                    preparedStatement.setLong(count++, ((RecordId)sqlgEdge.id()).getId());
                                }
                                preparedStatement.executeUpdate();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (preparedStatement == null) continue;
                                if (throwable != null) {
                                    try {
                                        preparedStatement.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                preparedStatement.close();
                            }
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        }
    }

    public String getBatchNull() {
        return BATCH_NULL;
    }

    private InputStream mapVertexToInputStream(Map<String, PropertyType> propertyTypeMap, Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>> vertexCache) throws SQLException {
        StringBuilder sb = new StringBuilder();
        int count = 1;
        for (SqlgVertex sqlgVertex : ((Map)vertexCache.getRight()).keySet()) {
            Map triple = (Map)((Map)vertexCache.getRight()).get(sqlgVertex);
            if (!((SortedSet)vertexCache.getLeft()).isEmpty()) {
                int countKeys = 1;
                block5: for (String key : (SortedSet)vertexCache.getLeft()) {
                    PropertyType propertyType = propertyTypeMap.get(key);
                    if (countKeys > 1 && countKeys <= ((SortedSet)vertexCache.getLeft()).size()) {
                        sb.append(COPY_COMMAND_DELIMITER);
                    }
                    ++countKeys;
                    Object value = triple.get(key);
                    switch (propertyType) {
                        case BYTE_ARRAY: {
                            String valueOfArrayAsString = PGbytea.toPGString((byte[])((byte[])SqlgUtil.convertByteArrayToPrimitiveArray((Byte[])((Byte[])value))));
                            sb.append(valueOfArrayAsString);
                            continue block5;
                        }
                        case byte_ARRAY: {
                            String valueOfArrayAsString = PGbytea.toPGString((byte[])((byte[])value));
                            sb.append(valueOfArrayAsString);
                            continue block5;
                        }
                    }
                    sb.append(this.valueToStreamString(propertyType, value));
                }
            } else {
                sb.append("0");
            }
            if (count++ >= ((Map)vertexCache.getRight()).size()) continue;
            sb.append("\n");
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private InputStream mapEdgeToInputStream(Map<String, PropertyType> propertyTypeMap, Pair<SortedSet<String>, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>> edgeCache) throws SQLException {
        StringBuilder sb = new StringBuilder();
        int count = 1;
        for (Triple triple : ((Map)edgeCache.getRight()).values()) {
            sb.append(((RecordId)((SqlgVertex)triple.getLeft()).id()).getId());
            sb.append(COPY_COMMAND_DELIMITER);
            sb.append(((RecordId)((SqlgVertex)triple.getMiddle()).id()).getId());
            if (!((SortedSet)edgeCache.getLeft()).isEmpty()) {
                sb.append(COPY_COMMAND_DELIMITER);
            }
            int countKeys = 1;
            for (String key : (SortedSet)edgeCache.getLeft()) {
                PropertyType propertyType = propertyTypeMap.get(key);
                Object value = ((Map)triple.getRight()).get(key);
                switch (propertyType) {
                    case BYTE_ARRAY: {
                        String valueOfArrayAsString = PGbytea.toPGString((byte[])((byte[])SqlgUtil.convertByteArrayToPrimitiveArray((Byte[])((Byte[])value))));
                        sb.append(valueOfArrayAsString);
                        break;
                    }
                    case byte_ARRAY: {
                        String valueOfArrayAsString = PGbytea.toPGString((byte[])((byte[])value));
                        sb.append(valueOfArrayAsString);
                        break;
                    }
                    default: {
                        sb.append(this.valueToStreamString(propertyType, value));
                    }
                }
                if (countKeys < ((SortedSet)edgeCache.getLeft()).size()) {
                    sb.append(COPY_COMMAND_DELIMITER);
                }
                ++countKeys;
            }
            if (count++ >= ((Map)edgeCache.getRight()).size()) continue;
            sb.append("\n");
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private String escapeSpecialCharacters(String s) {
        StringBuilder sb = new StringBuilder();
        boolean needEscape = s.length() == 0;
        for (int a = 0; a < s.length(); ++a) {
            char c = s.charAt(a);
            if (c == '\n' || c == '\r' || c == '\u0000' || c == COPY_COMMAND_DELIMITER.charAt(0)) {
                needEscape = true;
            }
            if (c == '\\' || c == '\u0001') {
                needEscape = true;
                sb.append('\\');
            }
            sb.append(c);
        }
        if (needEscape) {
            return '\u0001' + sb.toString() + '\u0001';
        }
        return s;
    }

    public String[] propertyTypeToSqlDefinition(PropertyType propertyType) {
        switch (propertyType) {
            case BOOLEAN: {
                return new String[]{"BOOLEAN"};
            }
            case SHORT: {
                return new String[]{"SMALLINT"};
            }
            case INTEGER: {
                return new String[]{"INTEGER"};
            }
            case LONG: {
                return new String[]{"BIGINT"};
            }
            case FLOAT: {
                return new String[]{"REAL"};
            }
            case DOUBLE: {
                return new String[]{"DOUBLE PRECISION"};
            }
            case LOCALDATE: {
                return new String[]{"DATE"};
            }
            case LOCALDATETIME: {
                return new String[]{"TIMESTAMP WITH TIME ZONE"};
            }
            case ZONEDDATETIME: {
                return new String[]{"TIMESTAMP WITH TIME ZONE", "TEXT"};
            }
            case LOCALTIME: {
                return new String[]{"TIME WITH TIME ZONE"};
            }
            case PERIOD: {
                return new String[]{"INTEGER", "INTEGER", "INTEGER"};
            }
            case DURATION: {
                return new String[]{"BIGINT", "INTEGER"};
            }
            case STRING: {
                return new String[]{"TEXT"};
            }
            case JSON: {
                return new String[]{"JSONB"};
            }
            case POINT: {
                return new String[]{"geometry(POINT)"};
            }
            case LINESTRING: {
                return new String[]{"geometry(LINESTRING)"};
            }
            case POLYGON: {
                return new String[]{"geometry(POLYGON)"};
            }
            case GEOGRAPHY_POINT: {
                return new String[]{"geography(POINT, 4326)"};
            }
            case GEOGRAPHY_POLYGON: {
                return new String[]{"geography(POLYGON, 4326)"};
            }
            case byte_ARRAY: {
                return new String[]{"BYTEA"};
            }
            case boolean_ARRAY: {
                return new String[]{"BOOLEAN[]"};
            }
            case short_ARRAY: {
                return new String[]{"SMALLINT[]"};
            }
            case int_ARRAY: {
                return new String[]{"INTEGER[]"};
            }
            case long_ARRAY: {
                return new String[]{"BIGINT[]"};
            }
            case float_ARRAY: {
                return new String[]{"REAL[]"};
            }
            case double_ARRAY: {
                return new String[]{"DOUBLE PRECISION[]"};
            }
            case STRING_ARRAY: {
                return new String[]{"TEXT[]"};
            }
            case LOCALDATETIME_ARRAY: {
                return new String[]{"TIMESTAMP WITH TIME ZONE[]"};
            }
            case LOCALDATE_ARRAY: {
                return new String[]{"DATE[]"};
            }
            case LOCALTIME_ARRAY: {
                return new String[]{"TIME WITH TIME ZONE[]"};
            }
            case ZONEDDATETIME_ARRAY: {
                return new String[]{"TIMESTAMP WITH TIME ZONE[]", "TEXT[]"};
            }
            case DURATION_ARRAY: {
                return new String[]{"BIGINT[]", "INTEGER[]"};
            }
            case PERIOD_ARRAY: {
                return new String[]{"INTEGER[]", "INTEGER[]", "INTEGER[]"};
            }
            case INTEGER_ARRAY: {
                return new String[]{"INTEGER[]"};
            }
            case BOOLEAN_ARRAY: {
                return new String[]{"BOOLEAN[]"};
            }
            case BYTE_ARRAY: {
                return new String[]{"BYTEA"};
            }
            case SHORT_ARRAY: {
                return new String[]{"SMALLINT[]"};
            }
            case LONG_ARRAY: {
                return new String[]{"BIGINT[]"};
            }
            case FLOAT_ARRAY: {
                return new String[]{"REAL[]"};
            }
            case DOUBLE_ARRAY: {
                return new String[]{"DOUBLE PRECISION[]"};
            }
            case JSON_ARRAY: {
                return new String[]{"JSONB[]"};
            }
        }
        throw new IllegalStateException("Unknown propertyType " + propertyType.name());
    }

    public PropertyType sqlTypeToPropertyType(SqlgGraph sqlgGraph, String schema, String table, String column, int sqlType, String typeName) {
        switch (sqlType) {
            case -7: {
                return PropertyType.BOOLEAN;
            }
            case 5: {
                return PropertyType.SHORT;
            }
            case 4: {
                return PropertyType.INTEGER;
            }
            case -5: {
                return PropertyType.LONG;
            }
            case 7: {
                return PropertyType.FLOAT;
            }
            case 8: {
                return PropertyType.DOUBLE;
            }
            case 12: {
                return PropertyType.STRING;
            }
            case 93: {
                return PropertyType.LOCALDATETIME;
            }
            case 91: {
                return PropertyType.LOCALDATE;
            }
            case 92: {
                return PropertyType.LOCALTIME;
            }
            case 1111: {
                switch (typeName) {
                    case "JSON": {
                        return PropertyType.JSON;
                    }
                    case "geometry": {
                        return this.getPostGisGeometryType(sqlgGraph, schema, table, column);
                    }
                    case "geography": {
                        return this.getPostGisGeographyType(sqlgGraph, schema, table, column);
                    }
                }
                throw new RuntimeException("Other type not supported " + typeName);
            }
            case -2: {
                return PropertyType.byte_ARRAY;
            }
            case 2003: {
                switch (typeName) {
                    case "_bool": {
                        return PropertyType.boolean_ARRAY;
                    }
                    case "_int2": {
                        return PropertyType.short_ARRAY;
                    }
                    case "_int4": {
                        return PropertyType.int_ARRAY;
                    }
                    case "_int8": {
                        return PropertyType.long_ARRAY;
                    }
                    case "_float4": {
                        return PropertyType.float_ARRAY;
                    }
                    case "_float8": {
                        return PropertyType.double_ARRAY;
                    }
                    case "_text": {
                        return PropertyType.STRING_ARRAY;
                    }
                }
                throw new RuntimeException("Array type not supported " + typeName);
            }
        }
        throw new IllegalStateException("Unknown sqlType " + sqlType);
    }

    public int propertyTypeToJavaSqlType(PropertyType propertyType) {
        switch (propertyType) {
            case BOOLEAN: {
                return 16;
            }
            case SHORT: {
                return 5;
            }
            case INTEGER: {
                return 4;
            }
            case LONG: {
                return -5;
            }
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 8;
            }
            case STRING: {
                return 2005;
            }
            case byte_ARRAY: {
                return 2003;
            }
            case LOCALDATETIME: {
                return 93;
            }
            case LOCALDATE: {
                return 91;
            }
            case LOCALTIME: {
                return 92;
            }
            case JSON: {
                return 1111;
            }
            case boolean_ARRAY: {
                return 2003;
            }
            case short_ARRAY: {
                return 2003;
            }
            case int_ARRAY: {
                return 2003;
            }
            case long_ARRAY: {
                return 2003;
            }
            case float_ARRAY: {
                return 2003;
            }
            case double_ARRAY: {
                return 2003;
            }
            case STRING_ARRAY: {
                return 2003;
            }
        }
        throw new IllegalStateException("Unknown propertyType " + propertyType.name());
    }

    public void validateProperty(Object key, Object value) {
        if (key instanceof String && ((String)key).length() > 63) {
            this.validateColumnName((String)key);
        }
        if (value instanceof String) {
            return;
        }
        if (value instanceof Character) {
            return;
        }
        if (value instanceof Boolean) {
            return;
        }
        if (value instanceof Byte) {
            return;
        }
        if (value instanceof Short) {
            return;
        }
        if (value instanceof Integer) {
            return;
        }
        if (value instanceof Long) {
            return;
        }
        if (value instanceof Float) {
            return;
        }
        if (value instanceof Double) {
            return;
        }
        if (value instanceof LocalDate) {
            return;
        }
        if (value instanceof LocalDateTime) {
            return;
        }
        if (value instanceof ZonedDateTime) {
            return;
        }
        if (value instanceof LocalTime) {
            return;
        }
        if (value instanceof Period) {
            return;
        }
        if (value instanceof Duration) {
            return;
        }
        if (value instanceof JsonNode) {
            return;
        }
        if (value instanceof Point) {
            return;
        }
        if (value instanceof LineString) {
            return;
        }
        if (value instanceof Polygon) {
            return;
        }
        if (value instanceof byte[]) {
            return;
        }
        if (value instanceof boolean[]) {
            return;
        }
        if (value instanceof char[]) {
            return;
        }
        if (value instanceof short[]) {
            return;
        }
        if (value instanceof int[]) {
            return;
        }
        if (value instanceof long[]) {
            return;
        }
        if (value instanceof float[]) {
            return;
        }
        if (value instanceof double[]) {
            return;
        }
        if (value instanceof String[]) {
            return;
        }
        if (value instanceof Character[]) {
            return;
        }
        if (value instanceof Boolean[]) {
            return;
        }
        if (value instanceof Byte[]) {
            return;
        }
        if (value instanceof Short[]) {
            return;
        }
        if (value instanceof Integer[]) {
            return;
        }
        if (value instanceof Long[]) {
            return;
        }
        if (value instanceof Float[]) {
            return;
        }
        if (value instanceof Double[]) {
            return;
        }
        if (value instanceof LocalDateTime[]) {
            return;
        }
        if (value instanceof LocalDate[]) {
            return;
        }
        if (value instanceof LocalTime[]) {
            return;
        }
        if (value instanceof ZonedDateTime[]) {
            return;
        }
        if (value instanceof Duration[]) {
            return;
        }
        if (value instanceof Period[]) {
            return;
        }
        if (value instanceof JsonNode[]) {
            return;
        }
        throw Property.Exceptions.dataTypeOfPropertyValueNotSupported((Object)value);
    }

    public boolean needForeignKeyIndex() {
        return true;
    }

    private Set<String> getForeignKeyConstraintNames(SqlgGraph sqlgGraph, String foreignKeySchema, String foreignKeyTable) {
        HashSet<String> result = new HashSet<String>();
        Connection conn = sqlgGraph.tx().getConnection();
        try {
            DatabaseMetaData metadata = conn.getMetaData();
            String childCatalog = null;
            String childSchemaPattern = foreignKeySchema;
            String childTableNamePattern = foreignKeyTable;
            ResultSet resultSet = metadata.getImportedKeys(childCatalog, childSchemaPattern, childTableNamePattern);
            while (resultSet.next()) {
                result.add(resultSet.getString("FK_NAME"));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public boolean supportsClientInfo() {
        return true;
    }

    public void validateSchemaName(String schema) {
        if (schema.length() > this.getMinimumSchemaNameLength()) {
            throw SqlgExceptions.invalidSchemaName((String)("Postgresql schema names can only be 63 characters. " + schema + " exceeds that"));
        }
    }

    public void validateTableName(String table) {
        if (table.length() > this.getMinimumTableNameLength()) {
            throw SqlgExceptions.invalidTableName((String)("Postgresql table names can only be 63 characters. " + table + " exceeds that"));
        }
    }

    public void validateColumnName(String column) {
        super.validateColumnName(column);
        if (column.length() > this.getMinimumColumnNameLength()) {
            throw SqlgExceptions.invalidColumnName((String)("Postgresql column names can only be 63 characters. " + column + " exceeds that"));
        }
    }

    public int getMinimumSchemaNameLength() {
        return 63;
    }

    public int getMinimumTableNameLength() {
        return 63;
    }

    public int getMinimumColumnNameLength() {
        return 63;
    }

    public boolean supportsILike() {
        return Boolean.TRUE;
    }

    public boolean needsTimeZone() {
        return Boolean.TRUE;
    }

    public void setJson(PreparedStatement preparedStatement, int parameterStartIndex, JsonNode json) {
        PGobject jsonObject = new PGobject();
        jsonObject.setType("jsonb");
        try {
            jsonObject.setValue(json.toString());
            preparedStatement.setObject(parameterStartIndex, jsonObject);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPoint(PreparedStatement preparedStatement, int parameterStartIndex, Object point) {
        Preconditions.checkArgument((boolean)(point instanceof Point), (Object)("point must be an instance of " + Point.class.getName()));
        try {
            preparedStatement.setObject(parameterStartIndex, new PGgeometry((Geometry)((Point)point)));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setLineString(PreparedStatement preparedStatement, int parameterStartIndex, Object lineString) {
        Preconditions.checkArgument((boolean)(lineString instanceof LineString), (Object)("lineString must be an instance of " + LineString.class.getName()));
        try {
            preparedStatement.setObject(parameterStartIndex, new PGgeometry((Geometry)((LineString)lineString)));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPolygon(PreparedStatement preparedStatement, int parameterStartIndex, Object polygon) {
        Preconditions.checkArgument((boolean)(polygon instanceof Polygon), (Object)("polygon must be an instance of " + Polygon.class.getName()));
        try {
            preparedStatement.setObject(parameterStartIndex, new PGgeometry((Geometry)((Polygon)polygon)));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setGeographyPoint(PreparedStatement preparedStatement, int parameterStartIndex, Object point) {
        Preconditions.checkArgument((boolean)(point instanceof GeographyPoint), (Object)("point must be an instance of " + GeographyPoint.class.getName()));
        try {
            preparedStatement.setObject(parameterStartIndex, new PGgeometry((Geometry)((GeographyPoint)((Object)point))));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void handleOther(Map<String, Object> properties, String columnName, Object o, PropertyType propertyType) {
        switch (propertyType) {
            case POINT: {
                properties.put(columnName, ((PGgeometry)o).getGeometry());
                break;
            }
            case LINESTRING: {
                properties.put(columnName, ((PGgeometry)o).getGeometry());
                break;
            }
            case GEOGRAPHY_POINT: {
                try {
                    Geometry geometry = PGgeometry.geomFromString((String)((PGobject)o).getValue());
                    properties.put(columnName, (Object)new GeographyPoint((Point)geometry));
                    break;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            case GEOGRAPHY_POLYGON: {
                try {
                    Geometry geometry = PGgeometry.geomFromString((String)((PGobject)o).getValue());
                    properties.put(columnName, (Object)new GeographyPolygon((Polygon)geometry));
                    break;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            case POLYGON: {
                properties.put(columnName, ((PGgeometry)o).getGeometry());
                break;
            }
            case JSON: {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    JsonNode jsonNode = objectMapper.readTree(((PGobject)o).getValue());
                    properties.put(columnName, jsonNode);
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case BYTE_ARRAY: {
                java.sql.Array array = (java.sql.Array)o;
                String arrayAsString = array.toString();
                arrayAsString = arrayAsString.substring(1);
                arrayAsString = arrayAsString.substring(0, arrayAsString.length() - 1);
                String[] byteAsString = arrayAsString.split(",");
                Byte[] result = new Byte[byteAsString.length];
                int count = 0;
                for (String s : byteAsString) {
                    Integer byteAsInteger = Integer.parseUnsignedInt(s.replace("\"", BATCH_NULL));
                    result[count++] = new Byte(BATCH_NULL);
                }
                properties.put(columnName, result);
                break;
            }
            default: {
                throw new IllegalStateException("sqlgDialect.handleOther does not handle " + propertyType.name());
            }
        }
    }

    public boolean supportsJson() {
        return true;
    }

    public OutputStream streamSql(SqlgGraph sqlgGraph, String sql) {
        C3P0ProxyConnection conn = (C3P0ProxyConnection)sqlgGraph.tx().getConnection();
        try {
            PGConnection pgConnection = (PGConnection)conn.unwrap(PGConnection.class);
            return new PGCopyOutputStream(pgConnection, sql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream inputStreamSql(SqlgGraph sqlgGraph, String sql) {
        C3P0ProxyConnection conn = (C3P0ProxyConnection)sqlgGraph.tx().getConnection();
        try {
            PGConnection pgConnection = (PGConnection)conn.unwrap(PGConnection.class);
            return new PGCopyInputStream(pgConnection, sql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private <L, R> void copyInBulkTempEdges(SqlgGraph sqlgGraph, SchemaTable schemaTable, Collection<Pair<L, R>> uids, PropertyType inPropertyType, PropertyType outPropertyType) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("COPY ");
            sql.append(this.maybeWrapInQoutes(schemaTable.getTable()));
            sql.append(" (");
            int count = 1;
            for (String key : Arrays.asList("in", "out")) {
                if (count > 1 && count <= 2) {
                    sql.append(", ");
                }
                ++count;
                sql.append(this.maybeWrapInQoutes(key));
            }
            sql.append(")");
            sql.append(" FROM stdin DELIMITER '");
            sql.append(COPY_COMMAND_DELIMITER);
            sql.append("';");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(sql.toString());
            }
            OutputStream out = this.streamSql(sqlgGraph, sql.toString());
            for (Pair<L, R> uid : uids) {
                out.write(this.valueToStreamBytes(inPropertyType, uid.getLeft()));
                out.write(COPY_COMMAND_DELIMITER.getBytes());
                out.write(this.valueToStreamBytes(outPropertyType, uid.getRight()));
                out.write("\n".getBytes());
            }
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <L, R> void bulkAddEdges(SqlgGraph sqlgGraph, SchemaTable in, SchemaTable out, String edgeLabel, Pair<String, String> idFields, Collection<Pair<L, R>> uids) {
        if (!sqlgGraph.tx().isInStreamingBatchMode() && !sqlgGraph.tx().isInStreamingWithLockBatchMode()) {
            throw SqlgExceptions.invalidMode((String)("Transaction must be in " + BatchManager.BatchModeType.STREAMING + " or " + BatchManager.BatchModeType.STREAMING_WITH_LOCK + " mode for bulkAddEdges"));
        }
        if (!uids.isEmpty()) {
            HashMap<String, PropertyType> columns = new HashMap<String, PropertyType>();
            Map inProperties = sqlgGraph.getSchemaManager().getTableFor(in.withPrefix("V_"));
            Map outProperties = sqlgGraph.getSchemaManager().getTableFor(out.withPrefix("V_"));
            PropertyType inPropertyType = ((String)idFields.getLeft()).equals("ID") ? PropertyType.INTEGER : (PropertyType)inProperties.get(idFields.getLeft());
            PropertyType outPropertyType = ((String)idFields.getRight()).equals("ID") ? PropertyType.INTEGER : (PropertyType)outProperties.get(idFields.getRight());
            columns.put("out", outPropertyType);
            columns.put("in", inPropertyType);
            SecureRandom random = new SecureRandom();
            byte[] bytes = new byte[6];
            random.nextBytes(bytes);
            String tmpTableIdentified = Base64.getEncoder().encodeToString(bytes);
            tmpTableIdentified = "BULK_TEMP_EDGE" + tmpTableIdentified;
            sqlgGraph.getSchemaManager().createTempTable(tmpTableIdentified, columns);
            this.copyInBulkTempEdges(sqlgGraph, SchemaTable.of((String)in.getSchema(), (String)tmpTableIdentified), uids, inPropertyType, outPropertyType);
            sqlgGraph.getSchemaManager().ensureEdgeTableExist(in.getSchema(), edgeLabel, out, in, new Object[0]);
            StringBuilder sql = new StringBuilder("INSERT INTO \n");
            sql.append(this.maybeWrapInQoutes(in.getSchema()));
            sql.append(".");
            sql.append(this.maybeWrapInQoutes("E_" + edgeLabel));
            sql.append(" (");
            sql.append(this.maybeWrapInQoutes(in.getSchema() + "." + in.getTable() + "__O"));
            sql.append(",");
            sql.append(this.maybeWrapInQoutes(out.getSchema() + "." + out.getTable() + "__I"));
            sql.append(") \n");
            sql.append("select _in.\"ID\" as \"");
            sql.append(in.getSchema() + "." + in.getTable() + "__O");
            sql.append("\", _out.\"ID\" as \"");
            sql.append(out.getSchema() + "." + out.getTable() + "__I");
            sql.append("\" FROM ");
            sql.append(this.maybeWrapInQoutes(in.getSchema()));
            sql.append(".");
            sql.append(this.maybeWrapInQoutes("V_" + in.getTable()));
            sql.append(" _in join ");
            sql.append(this.maybeWrapInQoutes(tmpTableIdentified) + " ab on ab.in = _in." + this.maybeWrapInQoutes((String)idFields.getLeft()) + " join ");
            sql.append(this.maybeWrapInQoutes(out.getSchema()));
            sql.append(".");
            sql.append(this.maybeWrapInQoutes("V_" + out.getTable()));
            sql.append(" _out on ab.out = _out." + this.maybeWrapInQoutes((String)idFields.getRight()));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(sql.toString());
            }
            Connection conn = sqlgGraph.tx().getConnection();
            try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void lockTable(SqlgGraph sqlgGraph, SchemaTable schemaTable, String prefix) {
        Preconditions.checkArgument((prefix.equals("V_") || prefix.equals("E_") ? 1 : 0) != 0, (Object)"prefix must be V_ or E_");
        StringBuilder sql = new StringBuilder();
        sql.append("LOCK TABLE ");
        sql.append(sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes(schemaTable.getSchema()));
        sql.append(".");
        sql.append(sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes(prefix + schemaTable.getTable()));
        sql.append(" IN SHARE MODE");
        if (this.needsSemicolon()) {
            sql.append(";");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        Connection conn = sqlgGraph.tx().getConnection();
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void alterSequenceCacheSize(SqlgGraph sqlgGraph, SchemaTable schemaTable, String sequence, int batchSize) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER SEQUENCE ");
        sql.append(sequence);
        sql.append(" CACHE ");
        sql.append(String.valueOf(batchSize));
        if (this.needsSemicolon()) {
            sql.append(";");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        Connection conn = sqlgGraph.tx().getConnection();
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public long nextSequenceVal(SqlgGraph sqlgGraph, SchemaTable schemaTable, String prefix) {
        long result;
        Preconditions.checkArgument((prefix.equals("V_") || prefix.equals("E_") ? 1 : 0) != 0, (Object)"prefix must be V_ or E_");
        Connection conn = sqlgGraph.tx().getConnection();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT NEXTVAL('\"" + schemaTable.getSchema() + "\".\"" + prefix + schemaTable.getTable() + "_ID_seq\"');");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            result = resultSet.getLong(1);
            resultSet.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public long currSequenceVal(SqlgGraph sqlgGraph, SchemaTable schemaTable, String prefix) {
        long result;
        Preconditions.checkArgument((prefix.equals("V_") || prefix.equals("E_") ? 1 : 0) != 0, (Object)"prefix must be V_ or E_");
        Connection conn = sqlgGraph.tx().getConnection();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT CURRVAL('\"" + schemaTable.getSchema() + "\".\"" + prefix + schemaTable.getTable() + "_ID_seq\"');");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            result = resultSet.getLong(1);
            resultSet.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public String sequenceName(SqlgGraph sqlgGraph, SchemaTable outSchemaTable, String prefix) {
        String result;
        Preconditions.checkArgument((prefix.equals("V_") || prefix.equals("E_") ? 1 : 0) != 0, (Object)"prefix must be V_ or E_");
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT pg_get_serial_sequence('\"");
        sql.append(outSchemaTable.getSchema());
        sql.append("\".\"");
        sql.append(prefix).append(outSchemaTable.getTable()).append("\"', 'ID')");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        Connection conn = sqlgGraph.tx().getConnection();
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            result = resultSet.getString(1);
            resultSet.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public boolean supportsBulkWithinOut() {
        return true;
    }

    public boolean isPostgresql() {
        return true;
    }

    public <T> T getGis(SqlgGraph sqlgGraph) {
        Gis gis = Gis.GIS;
        gis.setSqlgGraph(sqlgGraph);
        return (T)gis;
    }

    public String afterCreateTemporaryTableStatement() {
        return "ON COMMIT DROP";
    }

    public List<String> columnsToIgnore() {
        return Arrays.asList(COPY_DUMMY);
    }

    public List<String> sqlgTopologyCreationScripts() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("CREATE SCHEMA \"sqlg_schema\";");
        result.add("CREATE TABLE \"sqlg_schema\".\"V_schema\" (\"ID\" SERIAL PRIMARY KEY, \"createdOn\" TIMESTAMP WITH TIME ZONE, \"name\" TEXT);");
        result.add("CREATE TABLE \"sqlg_schema\".\"V_vertex\" (\"ID\" SERIAL PRIMARY KEY, \"createdOn\" TIMESTAMP WITH TIME ZONE, \"name\" TEXT, \"schemaVertex\" TEXT);");
        result.add("CREATE TABLE \"sqlg_schema\".\"V_edge\" (\"ID\" SERIAL PRIMARY KEY, \"createdOn\" TIMESTAMP WITH TIME ZONE, \"name\" TEXT);");
        result.add("CREATE TABLE \"sqlg_schema\".\"V_property\" (\"ID\" SERIAL PRIMARY KEY, \"createdOn\" TIMESTAMP WITH TIME ZONE, \"name\" TEXT, \"type\" TEXT);");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_schema_vertex\"(\"ID\" SERIAL PRIMARY KEY, \"sqlg_schema.vertex__I\" BIGINT, \"sqlg_schema.schema__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.vertex__I\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.schema__O\") REFERENCES \"sqlg_schema\".\"V_schema\" (\"ID\"));");
        result.add("CREATE INDEX ON \"sqlg_schema\".\"E_schema_vertex\" (\"sqlg_schema.vertex__I\");");
        result.add("CREATE INDEX ON \"sqlg_schema\".\"E_schema_vertex\" (\"sqlg_schema.schema__O\");");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_in_edges\"(\"ID\" SERIAL PRIMARY KEY, \"sqlg_schema.edge__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.edge__I\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));");
        result.add("CREATE INDEX ON \"sqlg_schema\".\"E_in_edges\" (\"sqlg_schema.edge__I\");");
        result.add("CREATE INDEX ON \"sqlg_schema\".\"E_in_edges\" (\"sqlg_schema.vertex__O\");");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_out_edges\"(\"ID\" SERIAL PRIMARY KEY, \"sqlg_schema.edge__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.edge__I\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));");
        result.add("CREATE INDEX ON \"sqlg_schema\".\"E_out_edges\" (\"sqlg_schema.edge__I\");");
        result.add("CREATE INDEX ON \"sqlg_schema\".\"E_out_edges\" (\"sqlg_schema.vertex__O\");");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_vertex_property\"(\"ID\" SERIAL PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));");
        result.add("CREATE INDEX ON \"sqlg_schema\".\"E_vertex_property\" (\"sqlg_schema.property__I\");");
        result.add("CREATE INDEX ON \"sqlg_schema\".\"E_vertex_property\" (\"sqlg_schema.vertex__O\");");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_edge_property\"(\"ID\" SERIAL PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.edge__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.edge__O\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"));");
        result.add("CREATE INDEX ON \"sqlg_schema\".\"E_edge_property\" (\"sqlg_schema.property__I\");");
        result.add("CREATE INDEX ON \"sqlg_schema\".\"E_edge_property\" (\"sqlg_schema.edge__O\");");
        return result;
    }

    private java.sql.Array createArrayOf(Connection conn, PropertyType propertyType, Object[] data) {
        try {
            switch (propertyType) {
                case boolean_ARRAY: 
                case BOOLEAN_ARRAY: 
                case SHORT_ARRAY: 
                case short_ARRAY: 
                case INTEGER_ARRAY: 
                case int_ARRAY: 
                case LONG_ARRAY: 
                case long_ARRAY: 
                case FLOAT_ARRAY: 
                case float_ARRAY: 
                case DOUBLE_ARRAY: 
                case double_ARRAY: 
                case STRING_ARRAY: 
                case LOCALDATETIME_ARRAY: 
                case LOCALDATE_ARRAY: 
                case LOCALTIME_ARRAY: 
                case ZONEDDATETIME_ARRAY: 
                case JSON_ARRAY: {
                    return conn.createArrayOf(this.getArrayDriverType(propertyType), data);
                }
            }
            throw new IllegalStateException("Unhandled array type " + propertyType.name());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Object convertArray(PropertyType propertyType, java.sql.Array array) throws SQLException {
        switch (propertyType) {
            case BOOLEAN_ARRAY: {
                return array.getArray();
            }
            case boolean_ARRAY: {
                return SqlgUtil.convertObjectArrayToBooleanPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case SHORT_ARRAY: {
                return SqlgUtil.convertObjectOfIntegersArrayToShortArray((Object[])((Object[])array.getArray()));
            }
            case short_ARRAY: {
                return SqlgUtil.convertObjectOfIntegersArrayToShortPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case INTEGER_ARRAY: {
                return array.getArray();
            }
            case int_ARRAY: {
                return SqlgUtil.convertObjectOfIntegersArrayToIntegerPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case LONG_ARRAY: {
                return array.getArray();
            }
            case long_ARRAY: {
                return SqlgUtil.convertObjectOfLongsArrayToLongPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case DOUBLE_ARRAY: {
                return array.getArray();
            }
            case double_ARRAY: {
                return SqlgUtil.convertObjectOfDoublesArrayToDoublePrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case FLOAT_ARRAY: {
                return array.getArray();
            }
            case float_ARRAY: {
                return SqlgUtil.convertObjectOfFloatsArrayToFloatPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case STRING_ARRAY: {
                return array.getArray();
            }
            case LOCALDATETIME_ARRAY: {
                Timestamp[] timestamps = (Timestamp[])array.getArray();
                return SqlgUtil.copyToLocalDateTime((Timestamp[])timestamps, (Object)new LocalDateTime[timestamps.length]);
            }
            case LOCALDATE_ARRAY: {
                Date[] dates = (Date[])array.getArray();
                return SqlgUtil.copyToLocalDate((Date[])dates, (Object)new LocalDate[dates.length]);
            }
            case LOCALTIME_ARRAY: {
                Time[] times = (Time[])array.getArray();
                return SqlgUtil.copyToLocalTime((Time[])times, (Object)new LocalTime[times.length]);
            }
            case JSON_ARRAY: {
                String arrayAsString = array.toString();
                arrayAsString = arrayAsString.substring(1);
                arrayAsString = arrayAsString.substring(0, arrayAsString.length() - 1);
                arrayAsString = StringEscapeUtils.unescapeJava((String)arrayAsString);
                arrayAsString = arrayAsString.substring(1);
                arrayAsString = arrayAsString.substring(0, arrayAsString.length() - 1);
                String[] jsons = arrayAsString.split("\",\"");
                JsonNode[] jsonNodes = new JsonNode[jsons.length];
                ObjectMapper objectMapper = new ObjectMapper();
                int count = 0;
                for (String json : jsons) {
                    try {
                        JsonNode jsonNode = objectMapper.readTree(json);
                        jsonNodes[count++] = jsonNode;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return jsonNodes;
            }
        }
        throw new IllegalStateException("Unhandled property type " + propertyType.name());
    }

    public void setArray(PreparedStatement statement, int index, PropertyType type, Object[] values) throws SQLException {
        statement.setArray(index, this.createArrayOf(statement.getConnection(), type, values));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PropertyType getPostGisGeometryType(SqlgGraph sqlgGraph, String schema, String table, String column) {
        Connection connection = sqlgGraph.tx().getConnection();
        try (PreparedStatement statement = connection.prepareStatement("SELECT type FROM geometry_columns WHERE f_table_schema = ? and f_table_name = ? and f_geometry_column = ?");){
            statement.setString(1, schema);
            statement.setString(2, table);
            statement.setString(3, column);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                String type = resultSet.getString(1);
                PropertyType propertyType = PropertyType.valueOf((String)type);
                return propertyType;
            }
            throw new IllegalStateException("PostGis property type for column " + column + " not found");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PropertyType getPostGisGeographyType(SqlgGraph sqlgGraph, String schema, String table, String column) {
        Connection connection = sqlgGraph.tx().getConnection();
        try (PreparedStatement statement = connection.prepareStatement("SELECT type FROM geography_columns WHERE f_table_schema = ? and f_table_name = ? and f_geography_column = ?");){
            String type;
            statement.setString(1, schema);
            statement.setString(2, table);
            statement.setString(3, column);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) throw new IllegalStateException("PostGis property type for column " + column + " not found");
            switch (type = resultSet.getString(1)) {
                case "Point": {
                    PropertyType propertyType = PropertyType.GEOGRAPHY_POINT;
                    return propertyType;
                }
                case "Polygon": {
                    PropertyType propertyType = PropertyType.GEOGRAPHY_POLYGON;
                    return propertyType;
                }
            }
            throw new IllegalStateException("Unhandled geography type " + type);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static Time shiftDST(LocalTime lt) {
        Time t = Time.valueOf(lt);
        int offset = Calendar.getInstance().get(16) / 1000;
        int m = t.getSeconds();
        t.setSeconds(m + offset);
        return t;
    }
}

