/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.swing;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SwingBackgroundTask<V> {
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(0);
    private final CountDownLatch latch = new CountDownLatch(1);
    private final int id = INSTANCE_COUNT.getAndIncrement();

    protected SwingBackgroundTask() {
    }

    public void execute() {
        Runnable task = new Runnable(){

            public void run() {
                try {
                    final Object result = SwingBackgroundTask.this.performTask();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SwingBackgroundTask.this.postProcessing(result);
                            SwingBackgroundTask.this.latch.countDown();
                        }
                    });
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SwingBackgroundTask.this.onError(throwable);
                            SwingBackgroundTask.this.latch.countDown();
                        }
                    });
                }
            }
        };
        new Thread(task, "SwingBackgroundTask-" + this.id).start();
    }

    public void waitForCompletion() throws InterruptedException {
        this.latch.await();
    }

    protected abstract V performTask() throws Exception;

    protected void postProcessing(V result) {
    }

    protected void onError(Throwable throwable) {
        throwable.printStackTrace();
        JOptionPane.showMessageDialog(null, throwable.getMessage(), throwable.getClass().getName(), 0);
    }
}

